<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus3D/src/View3D.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus3D/src/View3D.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module>View3D</module> EXPORTS <A HREF="View3D.i3"><implements>View3D</A></implements>, <A HREF="View3DPrivate.i3"><implements>View3DPrivate</A></implements>, <A HREF="View3DProxy.i3"><implements>View3DProxy</A></implements>;

IMPORT <A HREF="../../anim3D/src/AmbientLightGO.i3">AmbientLightGO</A>, <A HREF="../../anim3D/src/Anim3D.i3">Anim3D</A>, <A HREF="../../anim3D/src/AnimHandle.i3">AnimHandle</A>, <A HREF="../../mg/src/Animate.i3">Animate</A>, <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../anim3D/src/BooleanProp.i3">BooleanProp</A>,
       <A HREF="CameraManager.i3">CameraManager</A>, <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="ColorMenu.i3">ColorMenu</A>, <A HREF="../../anim3D/src/ColorProp.i3">ColorProp</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../formsvbt/src/FormsVBT.i3">FormsVBT</A>, <A HREF="../../anim3D/src/GO.i3">GO</A>, <A HREF="../../anim3D/src/GroupGO.i3">GroupGO</A>,
       <A HREF="../../fmtlex/src/Lex.i3">Lex</A>, <A HREF="LightManager.i3">LightManager</A>, <A HREF="../../anim3D/src/MouseCB.i3">MouseCB</A>, <A HREF="OrientGuide.i3">OrientGuide</A>, <A HREF="../../anim3D/src/Point3.i3">Point3</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../anim3D/src/PointLightGO.i3">PointLightGO</A>,
       <A HREF="../../anim3D/src/PositionCB.i3">PositionCB</A>, <A HREF="../../anim3D/src/Prop.i3">Prop</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../anim3D/src/RealProp.i3">RealProp</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../anim3D/src/RootGO.i3">RootGO</A>, <A HREF="../../vbtkitutils/src/Rsrc.i3">Rsrc</A>, <A HREF="../../fmtlex/src/Scan.i3">Scan</A>, <A HREF="../../anim3D/src/SurfaceGO.i3">SurfaceGO</A>,
       <A HREF="../../sx/src/Sx.i3">Sx</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../anim3D/src/TransformProp.i3">TransformProp</A>, <A HREF="../../ui/src/vbt/Trestle.i3">Trestle</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../zeus/src/View.i3">View</A>, <A HREF="../derived/View3DBundle.i3">View3DBundle</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>,
       <A HREF="../../anim3D/src/X_PEX_Base.i3">X_PEX_Base</A>, <A HREF="../../zeus/src/ZeusClass.i3">ZeusClass</A>, <A HREF="ZeusClock.i3">ZeusClock</A>, <A HREF="../../zeus/src/ZeusPanel.i3">ZeusPanel</A>;

&lt;* FATAL FormsVBT.Unimplemented, FormsVBT.Error *&gt;
&lt;* FATAL Prop.BadMethod *&gt;
</PRE>***************************************************************************
 Class T                                                                   
***************************************************************************

<P><PRE>REVEAL
  <A NAME="T">T</A> = Private BRANDED OBJECT
  (*** color choices ***)
    colorSelect   : ColorProp.Val;(* For which component is Color menu open? *)
    numColors     : INTEGER;
    colorpv       : ARRAY [0 .. 20] OF ColorProp.Val;
    numRotButtons : INTEGER;
    rotButton     : ARRAY [0 .. 20] OF Rotation;
    depthcueing   : BooleanProp.Val;
    wcsGroup      : GroupGO.T;
    wcsXform      : TransformProp.Val;
    spinXform     : TransformProp.Val;
    base          : X_PEX_Base.T;
    spinloopthread : Thread.T;
  OVERRIDES
    init              := Init;
    changeTitle       := ChangeTitle;
    findName          := FindName;
    installSubForm    := InstallSubForm;
    setWcs            := SetWcs;
    pause             := Pause;
    defineColor       := DefineColor;
    getColor          := GetColor;
    rotate            := Rotate;
    addRotationButton := AddRotationButton;
    discard           := Discard;
    snapshot          := Snapshot;
    restore           := Restore;
    isCompat          := IsCompat;
    reactivity        := Reactivity;
  END;

TYPE
  Rotation = RECORD
    a, b, c : REAL;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v : T; title : TEXT) : T =
  CONST
    win_x  = 10;
    win_y  = 10;
    win_w  = 500;
    win_h  = 500;
  BEGIN
    (*** set up the graphics base ***)
    v.base := NEW (X_PEX_Base.T).init (title, win_x, win_y, win_w, win_h);

    (*** read in the top-level control form ***)
    v.form := NEW (Form, view := v).initFromRsrc (
                                     &quot;CG-GenericCtrls.fv&quot;,
                                     Rsrc.BuildPath (View3DBundle.Get ()));

    (*** ... the rest should be independent of the graphics base ***)
    EVAL View.T.init (v, v.form);

    (*** set up an animation handle ***)
    v.ah := AnimHandle.New ();

    (*** start the rendering thread ***)
    v.spinloopthread := Thread.Fork (NEW (SpinLoopClosure, view := v));

    (*** set up the camera ***)
    v.camMgr := NEW (CameraManager.T).init (v);

    (*** create the root ***)
    v.root := NEW (RootGO.T).init (v.camMgr.getCamera (), v.base);

    (*** change the clock ***)
    Anim3D.ChangeClock (NEW (ZeusClock.T).init ());

    (*** set up the lights ***)
    v.lightMgr := NEW (LightManager.T).init (v);

    (*** set up the depth cueing ***)
    v.depthcueing := BooleanProp.NewConst (TRUE);
    v.root.setProp (RootGO.DepthcueSwitch.bind (v.depthcueing));
    v.root.setProp (RootGO.DepthcueColour.bind (ColorProp.NewConst (Color.Black)));
    v.root.setProp (RootGO.DepthcueFrontPlane.bind (RealProp.NewConst (1.0)));
    v.root.setProp (RootGO.DepthcueBackPlane.bind (RealProp.NewConst (0.0)));
    v.root.setProp (RootGO.DepthcueFrontScale.bind (RealProp.NewConst (1.0)));
    v.root.setProp (RootGO.DepthcueBackScale.bind (RealProp.NewConst (0.0)));

    (*** create a node to control the spinning of the scene ***)
    v.spinGroup := NEW (GroupGO.T).init ();
    v.spinXform := TransformProp.NewConst ();
    v.spinGroup.setProp (GO.Transform.bind (v.spinXform));
    v.spinGroup.setName (&quot;rotation-group&quot;);
    v.root.add (v.spinGroup);

    (*** create a node to control the world coordinate system ***)
    v.wcsGroup := NEW (GroupGO.T).init ();
    v.wcsXform := TransformProp.NewConst ();
    v.wcsGroup.setProp (GO.Transform.bind (v.wcsXform));
    v.spinGroup.add (v.wcsGroup);

    (*** set up the scene node ***)
    v.scene := NEW(GroupGO.T).init();
    v.wcsGroup.add (v.scene);

    (*** Create the orientation guide ***)
    v.guide := NEW (OrientGuide.T).init (v);

    (*** Attach mouse and position callbacks to the root ***)
    v.root.pushMouseCB (NEW (MyMouseCB, view := v, invoke := MouseInvoke).init());

    (*** set up the color management; initialize the background ***)
    v.numColors := 0;
    WITH pv = v.defineColor (&quot;background&quot;, Color.Black) DO
      v.root.setProp (RootGO.Background.bind (pv));
    END;

    (*** set up the rotation button array ***)
    v.numRotButtons := 0;

    FormsVBT.AttachProc (v.form,&quot;depth&quot;        , UpdateDepthCueingFlag);
    FormsVBT.AttachProc (v.form,&quot;lighting&quot;     , UpdateLightingModel);

    FormsVBT.AttachProc (v.form, &quot;colorChoice&quot;, UpdateColorChoice);
    FormsVBT.AttachProc (v.form, &quot;colorRedComponent&quot;, UpdateColorValue);
    FormsVBT.AttachProc (v.form, &quot;colorGreenComponent&quot;, UpdateColorValue);
    FormsVBT.AttachProc (v.form, &quot;colorBlueComponent&quot;, UpdateColorValue);

    FormsVBT.AttachProc (v.form, &quot;SpinStart&quot;, CallbackSpinStart);
    FormsVBT.AttachProc (v.form, &quot;SpinStop&quot; , CallbackSpinStop);
    FormsVBT.AttachProc (v.form, &quot;SpinSpeed&quot;, CallbackSpinSpeed);

    (* Fork a thread that waits until the rendering window gets deleted,
       and then destroys the control panel *)
    EVAL Thread.Fork (NEW (DestroyerClosure, view := v));

    RETURN v;
  END Init;

PROCEDURE <A NAME="ChangeTitle"><procedure>ChangeTitle</procedure></A> (self : T; title : TEXT) =
  BEGIN
    self.base.changeTitle (title);
  END ChangeTitle;

PROCEDURE <A NAME="FindName"><procedure>FindName</procedure></A> (self : T; name : TEXT) : GO.T =
  BEGIN
    RETURN self.root.findName (name);
  END FindName;

PROCEDURE <A NAME="InstallSubForm"><procedure>InstallSubForm</procedure></A> (self : T; file : TEXT) =
  BEGIN
    EVAL FormsVBT.InsertFromRsrc (self.form,
                                  &quot;SubFormSplit&quot;,
                                  file,
                                  ZeusPanel.GetPath (),
                                  1);
  END InstallSubForm;

PROCEDURE <A NAME="SetWcs"><procedure>SetWcs</procedure></A> (self : T; xmin, xmax, ymin, ymax, zmin, zmax : REAL) =
  BEGIN
    WITH beh = NARROW (self.wcsXform.beh, TransformProp.ConstBeh) DO
      beh.reset ();
      beh.translate (-0.5 * (xmin + xmax),
                     -0.5 * (ymin + ymax),
                     -0.5 * (zmin + zmax));
      beh.scale (5.0 / (xmax - xmin),
                 5.0 / (ymax - ymin),
                 5.0 / (zmax - zmin));
    END;
  END SetWcs;

PROCEDURE <A NAME="Pause"><procedure>Pause</procedure></A> (&lt;* UNUSED *&gt; self : T; duration : REAL) =
  VAR
    endtime := Animate.ATime () + duration;
  BEGIN
    REPEAT UNTIL Animate.ATime () &gt; endtime;
  END Pause;

PROCEDURE <A NAME="GetColor"><procedure>GetColor</procedure></A> (self : T; menu : TEXT) : ColorProp.Val RAISES {Error} =
  BEGIN
    FOR i := 0 TO self.numColors - 1 DO
      WITH text = FormsVBT.GetText (self.form, &quot;colorName&quot; &amp; Fmt.Int (i)) DO
        IF Text.Equal (menu, text) THEN
          RETURN self.colorpv[i];
        END;
      END;
    END;
    RAISE Error;
  END GetColor;

PROCEDURE <A NAME="Rotate"><procedure>Rotate</procedure></A> (self : T; a, b, c : REAL) =
  BEGIN
    WITH beh = NARROW (self.spinXform.beh, TransformProp.ConstBeh) DO
      beh.rotateX (a);
      beh.rotateY (b);
      beh.rotateZ (c);
    END;
  END Rotate;

PROCEDURE <A NAME="Discard"><procedure>Discard</procedure></A> (self : T) =
  BEGIN
    (*** alert the thread that spins the scene ***)
    Thread.Alert (self.spinloopthread);

    (*** Destroy the rendering window, if it's still around ***)
    IF self.base # NIL THEN
      NARROW (self.base, X_PEX_Base.T).destroy ();
    END;

    View.T.discard (self);
  END Discard;

PROCEDURE <A NAME="Snapshot"><procedure>Snapshot</procedure></A> (self : T; wr : Wr.T) RAISES {ZeusClass.Error} =
  BEGIN
    Wr.PutText(wr,&quot;(&quot;);
    self.lightMgr.snapshot (wr);
    self.camMgr.snapshot (wr);
    SnapshotColors (self, wr);
    View.T.snapshot (self, wr);
    TRY
      self.form.snapshot (wr);
    EXCEPT
      FormsVBT.Error(t) =&gt; RAISE ZeusClass.Error(t);
    END;
    Wr.PutText(wr,&quot;)&quot;);
  END Snapshot;

PROCEDURE <A NAME="Restore"><procedure>Restore</procedure></A> (self : T; rd : Rd.T) RAISES {ZeusClass.Error} =
  BEGIN
    IF rd = NIL THEN
      (*** create and register the default lights ***)
      self.lightMgr.addLight (AmbientLightGO.New (Color.White));
      self.lightMgr.addLight (PointLightGO.New (Color.White,
                                                Point3.T{10.0,10.0,10.0},
                                                1.0,
                                                0.02));

      (*** set the interactors on the form to &quot;reasonable&quot; default values ***)
      FormsVBT.PutBoolean (self.form, &quot;depth&quot;, FALSE);
      FormsVBT.PutBoolean  (self.form, &quot;lighting&quot;, TRUE);
      FormsVBT.PutChoice  (self.form, &quot;mousestyle&quot;, &quot;mhbmouse&quot;);
      self.guide.setFormDefaults ();
      (*** call View.T.restore (which can deal with a NIL reader) ***)
      View.T.restore (self, rd);
    ELSE
      Lex.Skip (rd);
      Lex.Match (rd, &quot;(&quot;);
      self.lightMgr.restore (rd);
      self.camMgr.restore (rd);
      RestoreColors (self, rd);
      View.T.restore (self, rd);
      TRY
        self.form.restore (rd);
      EXCEPT
        FormsVBT.Error(t) =&gt; RAISE ZeusClass.Error(t) ;
      END;
      Lex.Skip (rd);
      Lex.Match (rd, &quot;)&quot;);
    END;

    (*** update the internal state based on the restored form ***)
    WITH beh = NARROW (self.depthcueing.beh, BooleanProp.ConstBeh) DO
      beh.set (FormsVBT.GetBoolean (self.form,&quot;depth&quot;));
    END;

    SurfaceGO.SetLighting (self.scene,
                           FormsVBT.GetBoolean (self.form, &quot;lighting&quot;));

    self.guide.getFormState ();

  END Restore;

PROCEDURE <A NAME="IsCompat"><procedure>IsCompat</procedure></A> (&lt;* UNUSED *&gt; self : T;
                    &lt;* UNUSED *&gt; alg  : ZeusClass.T): BOOLEAN =
  BEGIN
    RETURN X_PEX_Base.Available ();
  END IsCompat;

PROCEDURE <A NAME="Reactivity"><procedure>Reactivity</procedure></A> (self : T; &lt;* UNUSED *&gt; on : BOOLEAN) =
  BEGIN
    View.T.reactivity (self, TRUE);
  END Reactivity;
</PRE>***************************************************************************
 Callback procedures                                                       
***************************************************************************

<P>***************************************************************************
 PROCEDURE UpdateDepthCueingFlag                                           
***************************************************************************

<P><PRE>PROCEDURE <A NAME="UpdateDepthCueingFlag"><procedure>UpdateDepthCueingFlag</procedure></A>(             form  : FormsVBT.T;
                                &lt;* UNUSED *&gt; event : TEXT;
                                &lt;* UNUSED *&gt; c     : REFANY;
                                &lt;* UNUSED *&gt; ts    : VBT.TimeStamp) =
  BEGIN
    WITH top = NARROW (form, Form), v = top.view DO
      WITH beh = NARROW (v.depthcueing.beh, BooleanProp.ConstBeh) DO
        beh.set (FormsVBT.GetBoolean (form,&quot;depth&quot;));
      END;
    END;
  END UpdateDepthCueingFlag;
</PRE>***************************************************************************
 PROCEDURE UpdateNoShadingReflectionModel                                  
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="UpdateLightingModel"><procedure>UpdateLightingModel</procedure></A> (form : FormsVBT.T;
                    &lt;* UNUSED *&gt; event : TEXT;
                    &lt;* UNUSED *&gt; c : REFANY;
                    &lt;* UNUSED *&gt; ts : VBT.TimeStamp) =
  BEGIN
    WITH top = NARROW (form, Form), v = top.view DO
      SurfaceGO.SetLighting (v.scene, FormsVBT.GetBoolean (form, &quot;lighting&quot;));
    END;
  END UpdateLightingModel;
</PRE>***************************************************************************
 Color Management                                                         
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="DefineColor"><procedure>DefineColor</procedure></A> (self    : T;
                       menu    : TEXT;
                       initial : Color.T) : ColorProp.Val =
  VAR
    pv : ColorProp.Val;
  BEGIN
    pv := ColorProp.NewConst (initial);
    self.colorpv[self.numColors] := pv;

    WITH index = Fmt.Int (self.numColors),
         name1 = &quot;color&quot; &amp; index,
         name2 = &quot;colorName&quot; &amp; index,
         title = &quot;(Text %&quot; &amp; name2 &amp; &quot; \&quot;&quot; &amp; menu &amp; &quot;\&quot;)&quot;,
         src   = &quot;(PopMButton %&quot; &amp; name1 &amp; &quot; (For ColorMenu) &quot; &amp; title &amp; &quot;)&quot; DO
      EVAL FormsVBT.Insert (self.form, &quot;ColorPulldownMenu&quot;, src, self.numColors);
      FormsVBT.AttachProc (self.form, name1, UpdateColor);

      INC (self.numColors);
    END;
    RETURN pv;
  END DefineColor;

PROCEDURE <A NAME="UpdateColor"><procedure>UpdateColor</procedure></A> (form  : FormsVBT.T;
                       event : TEXT;
           &lt;*UNUSED *&gt; c     : REFANY;
           &lt;*UNUSED *&gt; ts    : VBT.TimeStamp) =
  BEGIN
    WITH top = NARROW (form, Form),
         v   = top.view,
         eventSuffix = Text.Sub (event, 5, Text.Length(event) - 5),
         index = Scan.Int (eventSuffix) DO
      v.colorSelect := v.colorpv[index];
      ColorMenu.Put (form, v.colorSelect.get ());
    END;
  END UpdateColor;

PROCEDURE <A NAME="PutColor"><procedure>PutColor</procedure></A> (self : T; col : Color.T) =
  BEGIN
    self.colorSelect.beh := NEW (ColorProp.ConstBeh).init (col);
  END PutColor;

PROCEDURE <A NAME="UpdateColorChoice"><procedure>UpdateColorChoice</procedure></A> (            form  : FormsVBT.T;
                              &lt;*UNUSED *&gt; event : TEXT;
                              &lt;*UNUSED *&gt; c     : REFANY;
                              &lt;*UNUSED *&gt; ts    : VBT.TimeStamp) =
  BEGIN
    PutColor (NARROW (form, Form).view, ColorMenu.GetChoice (form));
  END UpdateColorChoice;

PROCEDURE <A NAME="UpdateColorValue"><procedure>UpdateColorValue</procedure></A> (            form  : FormsVBT.T;
                             &lt;*UNUSED *&gt; event : TEXT;
                             &lt;*UNUSED *&gt; c     : REFANY;
                             &lt;*UNUSED *&gt; ts    : VBT.TimeStamp) =
  BEGIN
    PutColor (NARROW (form, Form).view, ColorMenu.GetValue (form));
  END UpdateColorValue;

PROCEDURE <A NAME="SnapshotColors"><procedure>SnapshotColors</procedure></A> (self : T; wr : Wr.T) RAISES {ZeusClass.Error} =
  BEGIN
    TRY
      Wr.PutText (wr, &quot;(&quot;);
      FOR i := 0 TO self.numColors - 1 DO
        Wr.PutText (wr, &quot;(ColorAssoc &quot; &amp;
                        Fmt.Int(i) &amp; &quot; &quot; &amp;
                        ColorToText (self.colorpv[i].get()) &amp; &quot;)&quot;);
      END;
      Wr.PutText (wr, &quot;)&quot;);
    EXCEPT
    | ZeusClass.Error (t) =&gt; RAISE ZeusClass.Error (t);
    END;
  END SnapshotColors;

PROCEDURE <A NAME="RestoreColors"><procedure>RestoreColors</procedure></A> (self : T; rd : Rd.T) RAISES {ZeusClass.Error} =
  BEGIN
    WITH sx = Sx.Read (rd) DO
      TYPECASE sx OF
      | RefList.T (list) =&gt;
        WHILE list # NIL DO
          TYPECASE list.head OF
          | RefList.T (sublist) =&gt;
            &lt;* ASSERT RefList.Length (sublist) = 3 *&gt;
            TYPECASE RefList.Nth (sublist, 0) OF
            | Atom.T (a1) =&gt;
              IF a1 = Atom.FromText (&quot;ColorAssoc&quot;) THEN
                TYPECASE RefList.Nth (sublist, 1) OF
                | REF INTEGER (i) =&gt;
                  self.colorSelect := self.colorpv[i^];
                  PutColor (self, ColorFromSx (RefList.Nth (sublist, 2)));
                ELSE
                  RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
                END;
              ELSE
                RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
              END;
            ELSE
              RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
            END;
          ELSE
            RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
          END;
          list := list.tail;
        END;
      ELSE
        RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
      END;
    END;
  END RestoreColors;
</PRE>***************************************************************************
** WARNING: CODE REPLICATION                                             **
***************************************************************************

<P><PRE>PROCEDURE <A NAME="ColorToText"><procedure>ColorToText</procedure></A> (c : Color.T) : TEXT =
  BEGIN
     RETURN &quot;(Color &quot; &amp;
            Fmt.Real (c.r) &amp; &quot; &quot; &amp;
            Fmt.Real (c.g) &amp; &quot; &quot; &amp;
            Fmt.Real (c.b) &amp; &quot;)&quot;;
  END ColorToText;

PROCEDURE <A NAME="ColorFromSx"><procedure>ColorFromSx</procedure></A> (sx : Sx.T) : Color.T RAISES {ZeusClass.Error} =
  BEGIN
    TYPECASE sx OF
    | RefList.T (list) =&gt;
      &lt;* ASSERT RefList.Length(list) = 4 *&gt;
      TYPECASE list.head OF
      | Atom.T (a) =&gt;
        IF a = Atom.FromText (&quot;Color&quot;) THEN
          WITH r = RealFromSx (RefList.Nth (list, 1)),
               g = RealFromSx (RefList.Nth (list, 2)),
               b = RealFromSx (RefList.Nth (list, 3)) DO
            RETURN Color.T {r,g, b};
          END;
        ELSE
          RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
        END;
      ELSE
        RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
      END;
    ELSE
      RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
    END;
  END ColorFromSx;

PROCEDURE <A NAME="RealFromSx"><procedure>RealFromSx</procedure></A> (sx : Sx.T) : REAL RAISES {ZeusClass.Error} =
  BEGIN
    TYPECASE sx OF
    | REF REAL (rr) =&gt;
      RETURN rr^;
    | REF INTEGER (ri) =&gt;
      RETURN FLOAT(ri^);
    ELSE
      RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
    END;
  END RealFromSx;
</PRE>***************************************************************************
 Callbacks for Spinning Control                                            
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="CallbackSpinStart"><procedure>CallbackSpinStart</procedure></A> (            form  : FormsVBT.T;
                             &lt;*UNUSED *&gt; event : TEXT;
                             &lt;*UNUSED *&gt; c     : REFANY;
                             &lt;*UNUSED *&gt; ts    : VBT.TimeStamp) =
  BEGIN
    WITH v = NARROW (form, Form).view DO
      v.spin := TRUE;
      v.spin_x := 0.0;
      v.spin_y := FLOAT (FormsVBT.GetInteger (form, &quot;SpinSpeed&quot;)) * 0.002;
      v.spin_z := 0.0;
    END;
  END CallbackSpinStart;

PROCEDURE <A NAME="CallbackSpinStop"><procedure>CallbackSpinStop</procedure></A> (            form  : FormsVBT.T;
                            &lt;*UNUSED *&gt; event : TEXT;
                            &lt;*UNUSED *&gt; c     : REFANY;
                            &lt;*UNUSED *&gt; ts    : VBT.TimeStamp) =
  BEGIN
    WITH v = NARROW (form, Form).view DO
      v.spin := FALSE;
      v.spin_x := 0.0;
      v.spin_y := 0.0;
      v.spin_z := 0.0;
    END;
  END CallbackSpinStop;

PROCEDURE <A NAME="CallbackSpinSpeed"><procedure>CallbackSpinSpeed</procedure></A> (            form  : FormsVBT.T;
                             &lt;*UNUSED *&gt; event : TEXT;
                             &lt;*UNUSED *&gt; c     : REFANY;
                             &lt;*UNUSED *&gt; ts    : VBT.TimeStamp) =
  BEGIN
    WITH v = NARROW (form, Form).view DO
      IF v.spin THEN
        v.spin_x := 0.0;
        v.spin_y := FLOAT (FormsVBT.GetInteger (form, &quot;SpinSpeed&quot;)) * 0.002;
        v.spin_z := 0.0;
      END;
    END;
  END CallbackSpinSpeed;
</PRE>***************************************************************************
 Rotation Button Management                                                
***************************************************************************

<P><PRE>PROCEDURE <A NAME="AddRotationButton"><procedure>AddRotationButton</procedure></A> (self : T; title : TEXT; a, b, c : REAL) =
  BEGIN
    WITH name = &quot;rotButton&quot; &amp; Fmt.Int (self.numRotButtons),
         src  = &quot;(Button %&quot; &amp; name &amp; &quot; \&quot;&quot; &amp; title &amp; &quot;\&quot;)&quot; DO
      EVAL FormsVBT.Insert (self.form, &quot;RotationButtons&quot;, src);
      FormsVBT.AttachProc (self.form, name, PerformRotation);

      self.rotButton[self.numRotButtons] := Rotation {a, b, c};
      INC (self.numRotButtons);
    END;
  END AddRotationButton;

PROCEDURE <A NAME="PerformRotation"><procedure>PerformRotation</procedure></A> (form  : FormsVBT.T;
                           event : TEXT;
               &lt;*UNUSED *&gt; c     : REFANY;
               &lt;*UNUSED *&gt; ts    : VBT.TimeStamp) =
  BEGIN
    WITH suffix = Text.Sub (event, 9, Text.Length (event) - 9),
         index  = Scan.Int (suffix),
         v      = NARROW (form, Form).view,
         rot    = v.rotButton[index],
         beh    = NARROW (v.spinXform.beh, TransformProp.ConstBeh) DO
      beh.reset ();
      beh.rotateX (rot.a);
      beh.rotateY (rot.b);
      beh.rotateZ (rot.c);
    END;
  END PerformRotation;
</PRE>***************************************************************************
 Machinery for destroying the control panel                                
***************************************************************************

<P>
<P><PRE>TYPE
  DestroyerClosure = Thread.Closure OBJECT
    view : T;
  OVERRIDES
    apply := DestroyApply;
  END;

PROCEDURE <A NAME="DestroyApply"><procedure>DestroyApply</procedure></A> (self : DestroyerClosure) : REFANY =
  VAR
    view := self.view;
  BEGIN
    WITH base = NARROW (view.base, X_PEX_Base.T) DO
      base.awaitDelete ();
    END;

    view.base := NIL;
    Trestle.Delete (view);
</PRE><BLOCKQUOTE><EM>    Trestle.Delete (VBT.Parent (view));</EM></BLOCKQUOTE><PRE>
    RETURN NIL;
  END DestroyApply;
</PRE>***************************************************************************
 CLASS InteractionLoopClosure                                              
***************************************************************************

<P><PRE>TYPE
  SpinLoopClosure = Thread.Closure OBJECT
    view : T;
  OVERRIDES
    apply := SpinLoop;
  END;

PROCEDURE <A NAME="SpinLoop"><procedure>SpinLoop</procedure></A> (self : SpinLoopClosure) : REFANY =
  VAR
    view := self.view;
  BEGIN
    REPEAT
      IF view.spin THEN
        LOCK Anim3D.lock DO
          WITH beh = NARROW (view.spinXform.beh, TransformProp.ConstBeh) DO
            beh.rotateX (view.spin_x);
            beh.rotateY (view.spin_y);
            beh.rotateZ (view.spin_z);
          END;
        END;
      END;
      Thread.Pause (0.1d0);
    UNTIL Thread.TestAlert ();
    RETURN NIL;
  END SpinLoop;
</PRE>***************************************************************************
 RootGO callbacks                                                          
***************************************************************************

<P>
<P><PRE>TYPE
  MyPositionCB = PositionCB.T OBJECT
    view : T;
    pos : Point.T;
    but : VBT.Button;
  OVERRIDES
    invoke := PositionInvoke;
  END;

  MyMouseCB = MouseCB.T OBJECT
    view : T;
  OVERRIDES
    invoke := MouseInvoke;
  END;

PROCEDURE <A NAME="PositionInvoke"><procedure>PositionInvoke</procedure></A> (self : MyPositionCB; pr : PositionCB.Rec) =
  &lt;* FATAL GO.PropUndefined *&gt;
  BEGIN
    WITH d   = Point.Sub (pr.pos2D, self.pos),
         dx  = FLOAT (d.h), dy = FLOAT (d.v),
         v   = self.view,
         beh = NARROW (v.spinXform.beh, TransformProp.ConstBeh) DO
      IF VBT.Modifier.Shift IN pr.modifiers THEN
        CASE  self.but OF
        | VBT.Modifier.MouseL =&gt; beh.translate (dx * 0.01, -dy * 0.01, 0.0);
        | VBT.Modifier.MouseM =&gt; beh.scale (1.0 + dx * 0.01,
                                            1.0 + dx * 0.01,
                                            1.0 + dx * 0.01);
        | VBT.Modifier.MouseR =&gt; beh.translate (0.0, 0.0, dx * 0.01);
        ELSE
          (* Mice have only three buttons those days ... *)
        END;
      ELSIF VBT.Modifier.Control IN pr.modifiers THEN
        v.spin := TRUE;
        CASE  self.but OF
        | VBT.Modifier.MouseL =&gt; v.spin_x := dx * 0.01;
        | VBT.Modifier.MouseM =&gt; v.spin_y := dx * 0.01;
        | VBT.Modifier.MouseR =&gt; v.spin_z := dx * 0.01;
        ELSE
          (* Mice have only three buttons those days ... *)
        END;
      ELSE
        CASE  self.but OF
        | VBT.Modifier.MouseL =&gt; beh.rotateX (dx * 0.01);
        | VBT.Modifier.MouseM =&gt; beh.rotateY (dx * 0.01);
        | VBT.Modifier.MouseR =&gt; beh.rotateZ (dx * 0.01);
        ELSE
          (* Mice have only three buttons those days ... *)
        END;
      END;
    END;
    self.pos := pr.pos2D;
  END PositionInvoke;

PROCEDURE <A NAME="MouseInvoke"><procedure>MouseInvoke</procedure></A> (self : MyMouseCB; mr : MouseCB.Rec) =
  &lt;* FATAL GO.StackError *&gt;
  VAR
    v := self.view;
  BEGIN
    IF NOT VBT.Modifier.Control IN mr.modifiers THEN
      v.spin := FALSE;
      v.spin_x := 0.0;
      v.spin_y := 0.0;
      v.spin_z := 0.0;
    END;
    IF mr.clickType = VBT.ClickType.FirstDown THEN
      v.root.pushPositionCB (NEW (MyPositionCB,
                                  view := v,
                                  pos := mr.pos2D,
                                  but := mr.whatChanged).init());
    ELSIF mr.clickType = VBT.ClickType.LastUp THEN
      v.root.popPositionCB ();
    END;
  END MouseInvoke;
</PRE>***************************************************************************
 Module body                                                               
***************************************************************************

<P><PRE>BEGIN
END View3D.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
