#include "players.h"
#include "games.h"

/* #define META    "Mod1"         The modifier you like as META or ALT key */
#define META    "Meta"         /* The modifier you like as META or ALT key */
#define DEFTEXT "\"Press shift left mouse button for more info on a widget.\""
#define SETDEFTEXT "setvalues(*shortHelp, label," DEFTEXT ")"
#define ONENTER(action)             \
        "Ctrl<Key>j:" action "\\n"  \
        "Ctrl<Key>m:" action "\\n"  \
        "Ctrl<Key>o:" action "\\n"  \
        "<Key>Return:" action "\\n" \
        "<Key>KP_Enter:" action
#define ONTAB(action)                    \
        "~Shift Ctrl<Key>i:" action "\\n"\
        "~Shift<Key>Tab:"    action
#define ONBACKTAB(action)                \
        "Shift Ctrl<Key>i:" action "\\n" \
        "Shift<Key>Tab:" action
#define ASKTEXTTRAN()                        \
        ONTAB("asknexttext()") "\\n"         \
        ONBACKTAB("askprevioustext()") "\\n" \
        ONENTER("askendtext()") "\\n"        \
        "<Btn1Down>:asksettext() select-start()\\n" \
        "<Btn2Down>:asksettext() insert-selection(\"PRIMARY\",\"CUT_BUFFER0\")\\n" \
        "<Btn3Down>:asksettext() extend-start()\\n" \
        META "<Key>c:change() \\n"   \
        META "<Key>w:widgets()\\n"   \
        META "<Key>h:info()"
#define SHADOWTEXT(data)                \
        " textForm.Form"                \
            "(text.AsciiText" data      \
            ")"

/* The next 4 are a (tiny) bit nicer to the colormap, but don't work very well
   on b/w displays
#define GREEN1 "Green"
#define GREEN2 "LimeGreen"
#define GREEN3 "#40B040"
#define GREEN4 "DarkSeaGreen"
*/
#define GREEN1 "Green"
#define GREEN2 "#32CD32"
#define GREEN3 "#40B040"
#define GREEN4 "#8FBC8F"

String fallback_resources[] = {
#include "helptext.h"
    (String) "*analyzer.?.width:		   382",
    (String) "*analyzer.?.height:                  425",
    (String) "*analyzer.translations:              #override\\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol()\\n"
        "<ClientMessage>DELETE:         destroy()",
    (String) "*analyzer.collect*resizeToPreferred: True",
/*  (String) "*analyzer.collect.?.skipAdjust:      True",
    (String) "*analyzer.collect.scrollboard.skipAdjust:     False", */
    (String) "*analyzer*close.translations:        #override\\n"
        "Shift<Btn1Down>: help(analyze_close)\\n"
/*      "Shift<Btn3Down>: help(analyze_close, 1)\\n" */
        "<Btn1Up>: notify() unset() destroy(\"\")\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Quit this analyze session.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*analyzer*undo.translations:         #override\\n"
        "Shift<Btn1Down>: help(analyze_undo)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Undo the last move.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*analyzer*copy.translations:         #override\\n"
        "Shift<Btn1Down>: help(analyze_copy)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Make a new copy of the board being analyzed.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*analyzer*scroll.translations:       #override\\n"
        "Shift<Btn1Down>: help(analyze_scroll)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Scroll to older and/or more recent positions.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*analyzer*board.translations:        #override\\n"
        "Shift<Btn1Down>: help(analyze_board)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"View a position you are analyzing.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,

    (String) "*observe.title:                      %B [%b]%A vs [%w]%a %W",
    (String) "*observe.iconName:                   observing %B vs %W",
    (String) "*observe.?.width:                    382",
    (String) "*observe.?.height:                   540",
    (String) "*observe.translations:               #override\\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol()\\n"
        "<ClientMessage>DELETE:         destroy()",
    (String) "*observe.collect.info.height:        80",
    (String) "*observe.collect*resizeToPreferred:  True",
    (String) "*observe.collect.?.skipAdjust:       True",
    (String) "*observe.collect.scrollboard.skipAdjust:      False",
    (String) "*observe*titlePlay*editType:         edit",
    (String) "*observe*titlePlay.translations:     #override\\n"
        "Shift<Btn1Down>: help(observe_titlePlay)\\n"
        "<EnterWindow>: setfocus() "
            "setvalues(*shortHelp, label,"
            "\"Enter title you want to give this game.\")\\n"
        "<LeaveWindow>: setfocus(\"*input\") "
            "changetitle() "
            SETDEFTEXT "\\n"
        ONENTER("changetitle()") "\\n"
        META "<Key>c:   change()  \\n"
        META "<Key>w:   widgets() \\n"
        META "<Key>h:   info()",
    (String) "*observe*titleObserve.displayCaret:  False",
    (String) "*observe*titleObserve.translations:  #override\\n"
        "Shift<Btn1Down>: help(observe_titleObserve)\\n"
        "<EnterWindow>: "
            "setvalues(*shortHelp, label,"
            "\"Title of teaching game.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ONENTER("changetitle()") "\\n"
        META "<Key>c:   change()  \\n"
        META "<Key>w:   widgets() \\n"
        META "<Key>h:   info()",
    (String) "*observe*close.translations:         #override\\n"
        "Shift<Btn1Down>: help(observe_close)\\n"
        "<Btn1Up>: notify() unset() destroy(\"\")\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Close board widget.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*observe*undo.translations:          #override\\n"
        "Shift<Btn1Down>: help(observe_undo)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Undo your opponents last move.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*observe*pass.translations:          #override\\n"
        "Shift<Btn1Down>: help(observe_pass)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Pass.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*observe*done.translations:          #override\\n"
        "Shift<Btn1Down>: help(observe_done)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Stop scoring.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*observe*komi.translations:          #override\\n"
        "Shift<Btn1Down>: help(observe_komi)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Komi.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*observe*handicap.translations:      #override\\n"
        "Shift<Btn1Down>: help(observe_handicap)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Handicap.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*observe*captures.translations:      #override\\n"
        "Shift<Btn1Down>: help(observe_captures)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Number of stones captured by black and white.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*observe*move.translations:          #override\\n"
        "Shift<Btn1Down>: help(observe_moves)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Move number of current position / "
            "Number of moves played.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*observe*time.translations:          #override\\n"
        "Shift<Btn1Down>: help(observe_time)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Remaining time for black and white.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*observe*scroll.translations:        #override\\n"
        "Shift<Btn1Down>: help(observe_scroll)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Scroll to older and/or more recent positions.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*observe*board.translations:         #override\\n"
        "Shift<Btn1Down>: help(observe_board)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"View a position in a certain game.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*observe*info.translations:          #override\\n"
        "Shift<Btn1Down>: help(observe_info)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows the kibitzes in this game.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*observe.collect.input.translations: #override\\n"
        "Shift<Btn1Down>: help(observe_input)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Send a kibitz about this game.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ONENTER("kibitz()") "\\n"
        META "<Key>c:   change() \\n"
        META "<Key>w:   widgets()\\n"
        META "<Key>h:   info()",

/*  (String) "*review.title:                       %T", */
    (String) "*review.title:                       %B [%b]%A vs [%w]%a %W",
    (String) "*review.iconName:                    go review",
    (String) "*review.?.width:                     396",
    (String) "*review.?.height:                    540",
    (String) "*review.translations:                #override\\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol()\\n"
        "<ClientMessage>DELETE:         destroy()",
    (String) "*review.collect.info.height:         80",
    (String) "*review.collect*resizeToPreferred:   True",
    (String) "*review.collect.?.skipAdjust:        True",
    (String) "*review.collect.scrollboard.skipAdjust: False",
    (String) "*review*titleObserve.displayCaret:   False",
    (String) "*review*titleObserve.translations:   #override\\n"
        "Shift<Btn1Down>: help(review_title)\\n"
        "<EnterWindow>: "
            "setvalues(*shortHelp, label,"
            "\"Title of reviewed game.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ONENTER("changetitle()") "\\n"
        META "<Key>c:   change()  \\n"
        META "<Key>w:   widgets() \\n"
        META "<Key>h:   info()",
    (String) "*review*close.translations:          #override\\n"
        "Shift<Btn1Down>: help(review_close)\\n"
        "<Btn1Up>: notify() unset() popdown()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Close board widget.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*review*komi.translations:           #override\\n"
        "Shift<Btn1Down>: help(observe_komi)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Komi.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*review*handicap.translations:       #override\\n"
        "Shift<Btn1Down>: help(observe_handicap)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Handicap.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*review*captures.translations:       #override\\n"
        "Shift<Btn1Down>: help(observe_captures)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Number of stones captured by black and white.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*review*move.translations:           #override\\n"
        "Shift<Btn1Down>: help(observe_moves)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Move number of current position / "
            "Number of moves played.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*review*time.translations:           #override\\n"
        "Shift<Btn1Down>: help(review_time)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Remaining time for black and white.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*review*scroll.translations:         #override\\n"
        "Shift<Btn1Down>: help(observe_scroll)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Scroll to older and/or more recent positions.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*review*board.translations:          #override\\n"
        "Shift<Btn1Down>: help(observe_board)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"View a position in a certain game.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*review*info.translations:           #override\\n"
        "Shift<Btn1Down>: help(review_info)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows the comments for this game.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,

    (String) "*players.title:                      Players",
    (String) "*players.iconName:                   go players",
    (String) "*players.translations:               #override\\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol()\\n"
        "<ClientMessage>DELETE:         popdown()",
#ifndef   XAW3D
    (String) "*players.?.width:                    816",
#else  /* XAW3D */
    (String) "*players.?.width:                    834",
#endif /* XAW3D */
    (String) "*players.?.height:                   150",
    (String) "*players*set.height:                 50",
/*  (String) "*players*set.resizeToPreferred:      True", */
/*  (String) "*players.collect.strip.allowResize:  True",
    (String) "*players.collect.strip.resizeToPreferred:     True", */
    (String) "*players.collect.?.skipAdjust:       True",
    (String) "*players.collect.info.skipAdjust:    False",
    (String) "*players.collect.stripform.preferredPaneSize: 50",
/*  (String) "*players.collect.info.height:        80", */
    (String) "*players.collect.info.preferredPaneSize:      80",
    (String) "*players.collect.stats.label:        Players may exist",
    (String) "*players*allowResize.state:          True",
    (String) "*players*close.translations:         #override\\n"
        "Shift<Btn1Down>: help(players_close)\\n"
        "<Btn1Up>: notify() unset() popdown()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Popdown the players widget.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*players*update.translations:        #override\\n"
        "Shift<Btn1Down>: help(players_update)\\n"
        "<Btn1Down>,<Btn1Up>: sendcommand(who)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Ask the server for the current users.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*players*set*Command.foreground:     XtDefaultForeground",
    (String) "*players*set*Command.background:     "GREEN4,
    (String) "*players*set*playerEntryk.background:"GREEN3,
    (String) "*players*set*playerEntryd.background:"GREEN2,
    (String) "*players*set*playerEntryp.background:"GREEN1,
    (String) "*players*set*Command.translations:   #override\\n"
        "Shift<Btn1Down>: help(players_player)\\n"
        "Ctrl<Btn1Down>:  doplayer(" DUMPPLAYER ")\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Shows info on a logged on player.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n"
        "<Btn2Down>: set()\\n"
        "<Btn3Down>: set()\\n"
        "<Btn1Up>: doplayer(" PLAYERKEY1 ") unset()\\n"
        "<Btn2Up>: doplayer(" PLAYERKEY2 ") unset()\\n"
        "<Btn3Up>: doplayer(" PLAYERKEY3 ") unset()",
    (String) "*players*stats.translations:         #override\\n"
        "Shift<Btn1Down>: help(players_stats)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows the number of players and games.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*players*strip.translations:         #override\\n"
        "Shift<Btn1Down>: help(players_strip)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows a graph of the number of logged on players.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*players*info.translations:          #override\\n"
        "Shift<Btn1Down>: help(players_info)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows a history of connect/disconnect messages.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,

    (String) "*games.title:                        Games",
    (String) "*games.iconName:                     go games",
    (String) "*games.translations:                 #override\\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol()\\n"
        "<ClientMessage>DELETE:         popdown()",
#ifndef   XAW3D
    (String) "*games.?.width:                      496",
#else  /* XAW3D */
    (String) "*games.?.width:                      505",
#endif /* XAW3D */
    (String) "*games.?.height:                     150",
    (String) "*games*set.height:                   50",
/*  (String) "*games*set.resizeToPreferred:        True", */
/*  (String) "*games.collect.strip.allowResize:    True",
    (String) "*games.collect.strip.resizeToPreferred: True", */
    (String) "*games.collect.stripform.preferredPaneSize: 50",
/*  (String) "*games.collect.info.height:          80", */
    (String) "*games.collect.info.preferredPaneSize: 80",
    (String) "*games.collect.?.skipAdjust:         True",
    (String) "*games.collect.info.skipAdjust:      False",
    (String) "*games.collect.strip.skipAdjust:     False",
    (String) "*games*allowResize.state:            True",
    (String) "*games*close.translations:           #override\\n"
        "Shift<Btn1Down>: help(games_close)\\n"
        "<Btn1Up>: notify() unset() popdown()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Popdown the games widget.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*games*update.translations:          #override\\n"
        "Shift<Btn1Down>: help(games_update)\\n"
        "<Btn1Down>,<Btn1Up>: sendcommand(games)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Ask the server for the current games.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*games*set*Toggle.translations:      #override\\n"
        "Shift<Btn1Down>: help(games_game)\\n"
        "Ctrl<Btn1Down>:  dogame(" DUMPGAME ")\\n"
        "<EnterWindow>: highlight(Always) setvalues(*shortHelp, label,"
            "\"Shows information about a game in progress.\")\\n"
        "<LeaveWindow>: unhighlight() " SETDEFTEXT "\\n"
        "<Btn1Down>,<Btn1Up>: toggle() dogame(" GAMEKEY1 ")         \\n"
        "<Btn2Down>,<Btn2Up>: toggle() dogame(" GAMEKEY2 ") toggle()\\n"
        "<Btn3Down>,<Btn3Up>: toggle() dogame(" GAMEKEY3 ") toggle()",
    (String) "*games*set*Toggle.foreground:        XtDefaultForeground",
    (String) "*games*set*Toggle.background:        "GREEN4,
    (String) "*games*set*gameEntryk.background:    "GREEN3,
    (String) "*games*set*gameEntryd.background:    "GREEN2,
    (String) "*games*set*gameEntryp.background:    "GREEN1,
    (String) "*games*strip.translations:           #override\\n"
        "Shift<Btn1Down>: help(games_strip)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows a graph of the number of games in progress.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*games*info.translations:            #override\\n"
        "Shift<Btn1Down>: help(games_info)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows a history of messages about the games.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,

    (String) "*reviews.title:                      Reviews",
    (String) "*reviews.iconName:                   go reviews",
    (String) "*reviews.translations:               #override\\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol()\\n"
        "<ClientMessage>DELETE:         popdown()",
#ifndef   XAW3D
    (String) "*reviews.?.width:                    516",
#else  /* XAW3D */
    (String) "*reviews.?.width:                    527",
#endif /* XAW3D */
    (String) "*reviews*set*Command.width:          490",
    (String) "*reviews.?.height:                   150",
    (String) "*reviews*set.height:                 50",
    (String) "*reviews*allowResize.state:          False",
    (String) "*reviews*close.translations:         #override\\n"
        "Shift<Btn1Down>: help(reviews_close)\\n"
        "<Btn1Up>: notify() unset() popdown()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Pop down the reviews widget.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*reviews*update.translations:        #override\\n"
        "Shift<Btn1Down>: help(reviews_update)\\n"
        "<Btn1Down>,<Btn1Up>: sendcommand(reviews)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Ask the server for the currently available reviews.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
/*  (String) "*reviews*set*resizeToPreferred:True", */
    (String) "*reviews*set*Command.translations:   #override\\n"
        "Shift<Btn1Down>: help(reviews_game)\\n"
        "Ctrl<Btn1Down>:  dogame(" DUMPGAME ")\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Shows information about a game you can review.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n"
        "<Btn1Down>,<Btn1Up>: doreview(" GAMEKEY1 ")\\n"
        "<Btn2Down>,<Btn2Up>: doreview(" GAMEKEY2 ")\\n"
        "<Btn3Down>,<Btn3Up>: doreview(" GAMEKEY3 ") ",
    (String) "*reviews*set*Command.foreground:     XtDefaultForeground",
    (String) "*reviews*set*Command.background:     "GREEN4,
    (String) "*reviews*set*reviewEntry.background: "GREEN1,
    (String) "*reviews*set*reviewEntryPending.background: "GREEN2,
    (String) "*reviews*set*reviewEntryDone.background:    "GREEN3,

    (String) "*igsMessages.translations:           #override\\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol()\\n"
        "<ClientMessage>DELETE:         popdown()",
    (String) "*igsMessages.title:                  IGS messages",
    (String) "*igsMessages.iconName:               IGS messages",
    (String) "*igsMessages.?.width:                715",
    (String) "*igsMessages.?.height:               210",
    (String) "*igsMessages*close.translations:     #override\\n"
        "Shift<Btn1Down>: help(messages_close)\\n"
        "<Btn1Up>: notify() unset() popdown()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Popdown the window with IGS messages.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*igsMessages*save.translations:      #override\\n"
        "Shift<Btn1Down>: help(messages_save)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Save the current IGS messages to a file.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*igsMessages*info.translations:      #override\\n"
        "Shift<Btn1Down>: help(messages_info)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows important IGS related messages.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,

    (String) "*events.translations:                #override\\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol()\\n"
        "<ClientMessage>DELETE:         popdown()",
    (String) "*events.title:                       Events",
    (String) "*events.iconName:                    go events",
    (String) "*events.?.width:                     800",
    (String) "*events.?.height:                    210",
    (String) "*events*close.translations:          #override\\n"
        "Shift<Btn1Down>: help(events_close)\\n"
        "<Btn1Up>: notify() unset() popdown()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Popdown the window with event related messages.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*events*save.translations:           #override\\n"
        "Shift<Btn1Down>: help(events_save)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Save the current event related messages to a file.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*events*info.translations:           #override\\n"
        "Shift<Btn1Down>: help(events_info)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows event related messages.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,

    (String) "*broadcasts.translations:            #override\\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol()\\n"
        "<ClientMessage>DELETE:         popdown()",
    (String) "*broadcasts.title:                   Broadcasts",
    (String) "*broadcasts.iconName:                go broadcasts",
    (String) "*broadcasts.?.width:                 530",
    (String) "*broadcasts.?.height:                210",
    (String) "*broadcasts.collect.?.resizeToPreferred: True",
    (String) "*broadcasts.collect.?.skipAdjust:    True",
    (String) "*broadcasts.collect.info.skipAdjust: False",
    (String) "*broadcasts*close.translations:      #override\\n"
        "Shift<Btn1Down>: help(broadcasts_close)\\n"
        "<Btn1Up>: notify() unset() popdown()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Popdown the broadcasts widget.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*broadcasts*save.translations:       #override\\n"
        "Shift<Btn1Down>: help(broadcasts_save)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Save the current broadcasts (shouts) to a file.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*broadcasts*info.translations:       #override\\n"
        "Shift<Btn1Down>: help(broadcasts_info)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows the current broadcasts (shouts).\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*broadcasts.collect.input.translations: #override\\n"
        "Shift<Btn1Down>: help(broadcast_input)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Send a message to everybody on the server (shout).\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ONENTER("broadcast()") "\\n"
        META "<Key>c:   change()  \\n"
        META "<Key>w:   widgets() \\n"
        META "<Key>h:   info()",

    (String) "*yells.translations:                 #override\\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol()\\n"
        "<ClientMessage>DELETE:         popdown()",
    (String) "*yells.title:                        Channels",
    (String) "*yells.iconName:                     go channels",
    (String) "*yells.?.width:                      530",
    (String) "*yells.?.height:                     210",
    (String) "*yells.collect.?.resizeToPreferred:  True",
    (String) "*yells.collect.?.skipAdjust:         True",
    (String) "*yells.collect.info.skipAdjust:      False",
    (String) "*yells*close.translations:           #override\\n"
        "Shift<Btn1Down>: help(yells_close)\\n"
        "<Btn1Up>: notify() unset() popdown()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Popdown the channels widget.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*yells*save.translations:            #override\\n"
        "Shift<Btn1Down>: help(yells_save)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Save the current channel messages (yells) to a file.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*yells*channels.translations:        #override\\n"
        "Shift<Btn1Down>: help(yells_channels)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Show who is on which channel.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*yells*channel*string:               (None)",
    (String) "*yells*channel*editType:             edit",
    (String) "*yells*channel.displayCaret:         True",
    (String) "*yells*channel.resize:               never",
    (String) "*yells*channel.translations:         #override\\n"
        "Shift<Btn1Down>: help(yells_channel)\\n"
        "<EnterWindow>: setfocus() "
            "setvalues(\"textSource(*yells*channel)\", string,\"\") "
            "setvalues(*shortHelp, label,"
            "\"Enter channel you want to move to.\")\\n"
        "<LeaveWindow>: setfocus(\"*input\") "
            "changechannel() "
            SETDEFTEXT "\\n"
        ONENTER("changechannel()") "\\n"
        META "<Key>c:   change()    \\n"
        META "<Key>w:   widgets()   \\n"
        META "<Key>h:   info()",
    (String) "*yells*title.translations:           #override\\n"
        "Shift<Btn1Down>: help(yells_title)\\n"
        "<EnterWindow>: setfocus() "
            "setvalues(*yells*title, displayCaret, True) "
            "setvalues(*shortHelp, label,"
            "\"Shows the title of the channel you are on.\")\\n"
        "<LeaveWindow>: setfocus(\"*input\") "
            "setvalues(*yells*title, displayCaret, False) "
            "changechanneltitle() "
            SETDEFTEXT "\\n"
        ONENTER("changechanneltitle()"),
    (String) "*yells*title*editType:               edit",
    (String) "*yells*title.displayCaret:           False",
    (String) "*yells*moderator.translations:       #override\\n"
        "Shift<Btn1Down>: help(yells_moderator)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows the moderator of the channel you are on.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*yells*moderator.width:              1",
    (String) "*yells*moderator.displayCaret:       False",
    (String) "*yells*state.translations:           #override\\n"
        "Shift<Btn1Down>: help(yells_state)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows the state of the channel you are on.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*yells*state.width:                  1",
    (String) "*yells*state.displayCaret:           False",
    (String) "*yells*info.translations:            #override\\n"
        "Shift<Btn1Down>: help(yells_info)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows the current channel messages (yells).\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*yells.collect.input.translations:   #override\\n"
        "Shift<Btn1Down>: help(yells_input)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Sends a message (yell) on the current channel.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ONENTER("yell()") "\\n"
        META "<Key>c:   change()  \\n"
        META "<Key>w:   widgets() \\n"
        META "<Key>h:   info()",

    (String) "*tell.title:                         Talking to %N[%n]%A",
    (String) "*tell.iconName:                      talking to %N[%n]%A",
    (String) "*tell.?.width:                       530",
    (String) "*tell.?.height:                      210",
    (String) "*tell.translations:                  #override\\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol()\\n"
        "<ClientMessage>DELETE:         destroy()",
    (String) "*tell*bug.label:                     Beep",
    (String) "*tell.collect.?.allowResize:         True",
    (String) "*tell.collect*resizeToPreferred:     True",
    (String) "*tell.collect.?.skipAdjust:          True",
    (String) "*tell.collect.info.skipAdjust:       False",
    (String) "*tell*close.translations:            #override\\n"
        "Shift<Btn1Down>: help(tell_close)\\n"
        "<Btn1Up>: notify() unset() destroy(\"\")\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Quit talking and destroy widget.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*tell*save.translations:             #override\\n"
        "Shift<Btn1Down>: help(tell_save)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Save the current messages to a file.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*tell*bug.translations:              #override\\n"
        "Shift<Btn1Down>: help(tell_beep)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Send a beep command to the other person.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*tell*getStats.translations:         #override\\n"
        "Shift<Btn1Down>: help(tell_stats)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Get extra info about the other person.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*tell*getChallenge.translations:         #override\\n"
        "Shift<Btn1Down>: help(tell_challenge)\\n"
        "<EnterWindow>: highlight(Always) setvalues(*shortHelp, label,"
            "\"Popup a widget to challenge the other person.\")\\n"
        "<LeaveWindow>: unhighlight() " SETDEFTEXT,
    (String) "*tell*info.translations:             #override\\n"
        "Shift<Btn1Down>: help(tell_info)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows the current messages.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*tell.collect.input.translations:    #override\\n"
        "Shift<Btn1Down>: help(tell_input)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Send a message to the other person.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ONENTER("tell()") "\\n"
        META "<Key>c:   change() \\n"
        META "<Key>w:   widgets()\\n"
        META "<Key>h:   info()",

    (String) "*stats.title:                        Stats of %N[%n]%A",
    (String) "*stats.iconName:                     stats of %N[%n]%A",
    (String) "*stats.allowShellResize:             True",
    (String) "*stats.?.width:                      570",
/* high enough to allow text widgets to grow */
    (String) "*stats.?.height:                     220",
    (String) "*stats.translations:                 #override\\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol()\\n"
        "<ClientMessage>DELETE:         destroy(\"\")",
    (String) "*stats.collect.?*foreground:         XtDefaultForeground",
    (String) "*stats.collect.?*background:         Green",
    (String) "*stats.collect.close.foreground:     Yellow",
    (String) "*stats.collect.close.background:     Red",
#ifndef   XAW3D
    (String) "*stats.collect.close.shapeStyle:     roundedRectangle",
#endif /* XAW3D */
    (String) "*stats*Text.resize:                  both",
    (String) "*stats*info.scrollVertical:          never",
    (String) "*stats*Text.width:                   1",
    (String) "*stats*Text.wrap:                    never",
    (String) "*stats*Text.displayCaret:            False",
    (String) "*stats*Text.translations:            #override\\n"
        META "<Key>c:   change() \\n"
        META "<Key>w:   widgets()\\n"
        META "<Key>h:   info()",
    (String) "*stats*statsMyInfo*editType:         edit",
    (String) "*stats*statsMyInfo.displayCaret:     True",
    (String) "*stats*statsMyInfo.translations:     #override\\n"
        ONENTER("setinfo()") "\\n"
        META "<Key>c:   change() \\n"
        META "<Key>w:   widgets()\\n"
        META "<Key>h:   info()",
    (String) "*stats*close.translations:           #override\\n"
        "Shift<Btn1Down>: help(stats_close)\\n"
        "<Btn1Up>: notify() unset() destroy(\"\")\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Destroy this stats widget.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,

    (String) "*title:                              %N v %v",
    (String) "*iconName:                           %N",
    (String) "?.translations:                      #override\\n"
/*
        "<LeaveWindow>: setvalues(*shortHelp, label,"
            "\"Hey, where is your pointer going ?\")\\n"
        "<EnterWindow>: setvalues(*shortHelp, label," DEFTEXT ")\\n"
*/
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol()\\n"
        "<ClientMessage>DELETE:         output(Please log out in a clean way)\\n"
        "<ClientMessage>XGOSPEL_TRIP_PROBE: tripmessage()",
#ifdef HAVE_XPM
    /* Some window managers cannot do this. In that case use the bitmap */
    (String) "?.iconPixmap:                        pixmap(builtin(XgospelIcon))",
#else /* HAVE_XPM */
    (String) "?.iconPixmap:                        bitmap(builtin(XgospelIcon))",
#endif /* HAVE_XPM */

    (String) "*main.?.width:                       570",
    (String) "*main.?.height:                      400",
    (String) "*main.collect.?.resizeToPreferred:   True",
    (String) "*main.collect.?.skipAdjust:          True",
    (String) "*main.collect.info.skipAdjust:       False",
    (String) "*main*shortHelp.label: "
        "Press shift left mouse button for more info on a widget.",
#ifdef    XAW3D
    (String) "*main*shortHelp.shadowWidth:         0",
#endif /* XAW3D */
    (String) "*main*info.translations:             #override\\n"
        "Shift<Btn1Down>: help(main_info)",
    (String) "*main*quit.cursorName:               pirate",
    (String) "*main*quit.state:                    True",
    (String) "*main*quit.translations:             #override\\n"
        "Shift<Btn1Down>: help(main_quit)\\n"
        "<EnterWindow>: highlight(Always) setvalues(*shortHelp, label,"
            "\"Terminate with extreme prejudice.\")\\n"
        "<LeaveWindow>: unhighlight() " SETDEFTEXT,
    (String) "*main*gamesButton.translations:      #override\\n"
        "Shift<Btn1Down>: help(main_games)\\n"
        "<EnterWindow>: highlight(Always) setvalues(*shortHelp, label,"
            "\"Toggle display of games in progress.\")\\n"
        "<LeaveWindow>: unhighlight() " SETDEFTEXT "\\n"
        "Ctrl<Btn3Down>,<Btn3Up>: setvalues(*games, iconic, true)\\n"
        "<Btn3Down>,<Btn3Up>: setvalues(,state, true)  popup(*games) setvalues(*games, iconic, false)",
    (String) "*main*playersButton.translations:    #override\\n"
        "Shift<Btn1Down>: help(main_players)\\n"
        "<EnterWindow>: highlight(Always) setvalues(*shortHelp, label,"
            "\"Toggle display of players logged on.\")\\n"
        "<LeaveWindow>: unhighlight() " SETDEFTEXT "\\n"
        "Ctrl<Btn3Down>,<Btn3Up>: setvalues(*players, iconic, true)\\n"
        "<Btn3Down>,<Btn3Up>: setvalues(,state, true)  popup(*players) setvalues(*players, iconic, false)",
    (String) "*main*messageButton.translations:    #override\\n"
        "Shift<Btn1Down>: help(main_messages)\\n"
        "<EnterWindow>: highlight(Always) setvalues(*shortHelp, label,"
            "\"Toggle display of important server messages.\")\\n"
        "<LeaveWindow>: unhighlight() " SETDEFTEXT "\\n"
        "Ctrl<Btn3Down>,<Btn3Up>: setvalues(*igsMessages, iconic, true)\\n"
        "<Btn3Down>,<Btn3Up>: setvalues(,state, true)  popup(*igsMessages) setvalues(*igsMessages, iconic, false)",
    (String) "*main*broadcastButton.translations:  #override\\n"
        "Shift<Btn1Down>: help(main_broadcasts)\\n"
        "<EnterWindow>: highlight(Always) setvalues(*shortHelp, label,"
            "\"Toggle display of broadcast widget.\")\\n"
        "<LeaveWindow>: unhighlight() " SETDEFTEXT "\\n"
        "Ctrl<Btn3Down>,<Btn3Up>: setvalues(*broadcasts, iconic, true)\\n"
        "<Btn3Down>,<Btn3Up>: setvalues(,state, true)  popup(*broadcasts) setvalues(*broadcasts, iconic, false)",
    (String) "*main*yellButton.translations:       #override\\n"
        "Shift<Btn1Down>: help(main_channels)\\n"
        "<EnterWindow>: highlight(Always) setvalues(*shortHelp, label,"
            "\"Toggle display of channel widget.\")\\n"
        "<LeaveWindow>: unhighlight() " SETDEFTEXT "\\n"
        "<Btn2Down>,<Btn2Up>: toggle() usercommand(channels) toggle()\\n"
        "Ctrl<Btn3Down>,<Btn3Up>: setvalues(*yells, iconic, true)\\n"
        "<Btn3Down>,<Btn3Up>: setvalues(,state, true)  popup(*yells) setvalues(*yells, iconic, false)",
    (String) "*main*reviewsButton.translations:    #override\\n"
        "Shift<Btn1Down>: help(main_reviews)\\n"
        "<EnterWindow>: highlight(Always) setvalues(*shortHelp, label,"
            "\"Toggle display of available saved games.\")\\n"
        "<LeaveWindow>: unhighlight() " SETDEFTEXT "\\n"
        "Ctrl<Btn3Down>,<Btn3Up>: setvalues(*reviews, iconic, true)\\n"
        "<Btn3Down>,<Btn3Up>: setvalues(,state, true)  popup(*reviews) setvalues(*events, iconic, false)",
    (String) "*main*eventsButton.translations:     #override\\n"
        "Shift<Btn1Down>: help(main_events)\\n"
        "<EnterWindow>: highlight(Always) setvalues(*shortHelp, label,"
            "\"Toggle display of events.\")\\n"
        "<LeaveWindow>: unhighlight() " SETDEFTEXT "\\n"
        "Ctrl<Btn3Down>,<Btn3Up>: setvalues(*events, iconic, true)\\n"
        "<Btn3Down>,<Btn3Up>: setvalues(,state, true)  popup(*events) setvalues(*events, iconic, false)",
    (String) "*main*localTime.translations:        #override\\n"
        "Shift<Btn1Down>: help(main_localTime)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Displays your local time.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*main*universalTime.translations:    #override\\n"
        "Shift<Btn1Down>: help(main_universalTime)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Displays universal time.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*main*serverTime.translations:       #override\\n"
        "Shift<Btn1Down>: help(main_serverTime)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Displays IGS server local time.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*main*shortHelp.translations:        #override\\n"
        "Shift<Btn1Down>: help(main_shortHelp)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Gives short help on widget.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT,
    (String) "*main.collect.input.translations:    #override\\n"
        "Shift<Btn1Down>: help(main_input)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Enter server commands.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ONENTER("igscommand()") "\\n"
        META "<Key>c:   change()  \\n"
        META "<Key>w:   widgets() \\n"
        META "<Key>h:   info()",
    (String) "*main*wantConnect.state:             True",
    (String) "*main*connect.label:                 connection with %S %P:",
    (String) "*main*hasConnect.label:              have it",
    (String) "*main*wantConnect.label:             want it",

    (String) "*quitConfirm*confirm.label:          Do you really want to quit ?",
    (String) "*quitConfirm*Paned.?.showGrip:       False",
    (String) "*quitConfirm*Paned*Paned.orientation: horizontal",
    (String) "*quitConfirm*Paned*Paned.?.skipAdjust: True",
    (String) "*quitConfirm*Paned*Paned.filler.skipAdjust: False",
    (String) "*quitConfirm*ok.label:               Ok",
    (String) "*quitConfirm*ok.cursorName:          pirate",
    (String) "*quitConfirm*filler.width:           1",
    (String) "*quitConfirm*filler.height:          1",
    (String) "*quitConfirm*cancel.label:           Cancel",
    (String) "*quitConfirm*cancel.translations:    #override\\n"
        "<Btn1Up>: notify() popdown() unset()",
    (String) "*quitConfirm.title:                  Confirm",
    (String) "*quitConfirm.iconName:               Confirm",
    (String) "*quitConfirm.translations:           #override\\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol()\\n"
        "<ClientMessage>DELETE:         popdown()",

    (String) "*askString*allowShellResize:         True",
    (String) "*askString*Label.background:         Green",
    (String) "*askString*Command.background:       Green",
    (String) "*askString*userPassword.label:       Enter user and password",
    (String) "*askString*userLabel.label:          User:    ",
    (String) "*askString*passwordLabel.label:      Password:",
    (String) "*askString*sgfFilenameLabel.label:   sgf filename:",
    (String) "*askString*psFilenameLabel.label:    ps filename:",
    (String) "*askString*kibitzFilenameLabel.label:kibitz filename:",
    (String) "*askString*broadcastFilenameLabel.label: broadcasts filename:",
    (String) "*askString*yellFilenameLabel.label:  channels filename:",
    (String) "*askString*tellFilenameLabel.label:  tell filename:",
    (String) "*askString*serverFilenameLabel.label:igs messages filename:",
    (String) "*askString*eventsFilenameLabel.label:events filename:",
    (String) "*askString*mainFilenameLabel.label:  session filename:",
    (String) "*askString*analyzeSizeLabel.label:   analyzeboard size:",
    (String) "*askString*allowSuicideLabel.label:  allow suicide:    ",
    (String) "*askString*replayTimeoutLabel.label: replay rate:      ",
    (String) "*askString*whoTimeoutLabel.label:    who    rate:      ",
    (String) "*askString*gamesTimeoutLabel.label:  games  rate:      ",
    (String) "*askString*reviewsTimeoutLabel.label:review rate:      ",
    (String) "*askString*clockTimeoutLabel.label:  clock  rate:      ",
    (String) "*askString*playersUpdateTimeoutLabel.label: playerwindow rate:",
    (String) "*askString*gamesUpdateTimeoutLabel.label: game  window rate:",
    (String) "*askString*reviewsUpdateTimeoutLabel.label: reviewwindow rate:",
    (String) "*askString*serverTimeoutLabel.label: server timeout:   ",
    (String) "*askString*inactiveTimeoutLabel.label:  time to auto quit:",
    (String) "*askString*quitTimeoutLabel.label:   quit timeout:     ",
    (String) "*askString*tersePlayLabel.label:     terse  play traffic:",
    (String) "*askString*Text*editType:            edit",
    (String) "*askString*Text.resize:              both",
    (String) "*askString*Text.displayCaret:        False",
    (String) "*askString*password*Text*echo:       False",
    (String) "*askString*Paned.?.showGrip:         False",
    (String) "*askString*Paned.?.allowResize:      True",
    (String) "*askString*Paned.?.resizeToPreferred:True",
/*    (String) "*askString*collect.orientation:      vertical", */
    (String) "*askString*collect*Paned.orientation:horizontal",
    (String) "*askString*Text.translations:        #override\\n"
        ASKTEXTTRAN(),
    (String) "*askString*collect.translations:     #override\\n"
        "Shift<Btn1Down>: help(askstring_collect)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Enter value.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n",
    (String) "*askString*analyzeSize*Command.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_analyzeSize)\\n"
        "<Btn3Down>: set()\\n"
        "<Btn1Up>:notify() increase(*analyzeSize*text, -1, 2, 25) unset()\\n"
        "<Btn3Up>:notify() increase(*analyzeSize*text,  1, 2, 25) unset()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Enter new default size of analyze board.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n",
    (String) "*askString*analyzeSize*Text.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_analyzeSize)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Enter new default size of analyze board.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ASKTEXTTRAN(),
    (String) "*askString*allowSuicide*Command.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_allowSuicide)\\n"
        "<Btn3Down>: set()\\n"
        "<Btn1Up>:notify() toggleboolean(*allowSuicide*text) unset()\\n"
        "<Btn3Up>:notify() toggleboolean(*allowSuicide*text) unset()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Should suicide be allowed by default in analyze boards ??\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n",
    (String) "*askString*allowSuicide*Text.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_allowSuicide)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Should suicide be allowed by default in analyze boards ??\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ASKTEXTTRAN(),
    (String) "*askString*replayTimeout*Command.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_replayTimeout)\\n"
        "<Btn3Down>: set()\\n"
        "<Btn1Up>:notify() increase(*replayTimeout*text, -1, 1, 30) unset()\\n"
        "<Btn3Up>:notify() increase(*replayTimeout*text,  1, 1, 30) unset()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Enter new moverate for replay.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n",
    (String) "*askString*replayTimeout*Text.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_replayTimeout)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Enter new moverate for replay.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ASKTEXTTRAN(),
    (String) "*askString*whoTimeout*Command.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_whoTimeout)\\n"
        "<Btn3Down>: set()\\n"
        "<Btn1Up>:notify() increase(*whoTimeout*text, -60, 120,960) unset()\\n"
        "<Btn3Up>:notify() increase(*whoTimeout*text,  60, 120,960) unset()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Enter minimum rate at which to send who commands.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n",
    (String) "*askString*whoTimeout*Text.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_whoTimeout)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Enter minimum rate at which to send who commands.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ASKTEXTTRAN(),
    (String) "*askString*gamesTimeout*Command.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_gamesTimeout)\\n"
        "<Btn3Down>: set()\\n"
        "<Btn1Up>:notify() increase(*gamesTimeout*text,-60,120,960) unset()\\n"
        "<Btn3Up>:notify() increase(*gamesTimeout*text, 60,120,960) unset()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Enter minimum rate at which to send games commands.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n",
    (String) "*askString*gamesTimeout*Text.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_gamesTimeout)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Enter minimum rate at which to send games commands.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ASKTEXTTRAN(),
    (String) "*askString*reviewsTimeout*Command.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_reviewsTimeout)\\n"
        "<Btn3Down>: set()\\n"
        "<Btn1Up>:notify() increase(*reviewsTimeout*text,-120,600,7200) unset()\\n"
        "<Btn3Up>:notify() increase(*reviewsTimeout*text, 120,600,7200) unset()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Enter minimum rate at which to send review commands.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n",
    (String) "*askString*reviewsTimeout*Text.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_reviewsTimeout)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Enter minimum rate at which to send review commands.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ASKTEXTTRAN(),
    (String) "*askString*clockTimeout*Command.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_clockTimeout)\\n"
        "<Btn3Down>: set()\\n"
        "<Btn1Up>:notify() increase(*clockTimeout*text,-1,1,60) unset()\\n"
        "<Btn3Up>:notify() increase(*clockTimeout*text, 1,1,60) unset()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Enter rate at which to update the visible clicks.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n",
    (String) "*askString*clockTimeout*Text.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_clockTimeout)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Enter rate at which to update the visible clicks.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ASKTEXTTRAN(),
    (String) "*askString*inactiveTimeout*Command.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_inactiveTimeout)\\n"
        "<Btn3Down>: set()\\n"
        "<Btn1Up>:notify() increase(*inactiveTimeout*text,-300,300,7200) unset()\\n"
        "<Btn3Up>:notify() increase(*inactiveTimeout*text, 300,300,7200) unset()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Enter after how many seconds of inactivity the program should quit.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n",
    (String) "*askString*inactiveTimeout*Text.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_inactiveTimeout)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Enter after how many seconds of inactivity the program should quit.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ASKTEXTTRAN(),
    (String) "*askString*playersUpdateTimeout*Command.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_playersUpdateTimeout)\\n"
        "<Btn3Down>: set()\\n"
        "<Btn1Up>:notify() increase(*playersUpdateTimeout*text,-5,0,120) unset()\\n"
        "<Btn3Up>:notify() increase(*playersUpdateTimeout*text, 5,0,120) unset()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Enter rate at which to update the players widget.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n",
    (String) "*askString*playersUpdateTimeout*Text.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_playersUpdateTimeout)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Enter rate at which to update the players widget.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ASKTEXTTRAN(),
    (String) "*askString*gamesUpdateTimeout*Command.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_gamesUpdateTimeout)\\n"
        "<Btn3Down>: set()\\n"
        "<Btn1Up>:notify() increase(*gamesUpdateTimeout*text,-1,0,30) unset()\\n"
        "<Btn3Up>:notify() increase(*gamesUpdateTimeout*text, 1,0,30) unset()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Enter rate at which to update the games widget.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n",
    (String) "*askString*gamesUpdateTimeout*Text.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_gamesUpdateTimeout)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Enter rate at which to update the games widget.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ASKTEXTTRAN(),
    (String) "*askString*reviewsUpdateTimeout*Command.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_reviewsUpdateTimeout)\\n"
        "<Btn3Down>: set()\\n"
        "<Btn1Up>:notify() increase(*reviewsUpdateTimeout*text,-1,0,30) unset()\\n"
        "<Btn3Up>:notify() increase(*reviewsUpdateTimeout*text, 1,0,30) unset()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Enter rate at which to update the reviews widget.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n",
    (String) "*askString*reviewsUpdateTimeout*Text.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_reviewsUpdateTimeout)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Enter rate at which to update the reviews widget.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ASKTEXTTRAN(),
    (String) "*askString*serverTimeout*Command.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_serverTimeout)\\n"
        "<Btn3Down>: set()\\n"
        "<Btn1Up>:notify() increase(*serverTimeout*text,-60,60,7200) unset()\\n"
        "<Btn3Up>:notify() increase(*serverTimeout*text, 60,60,7200) unset()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Enter waiting period before resending a failed command.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n",
    (String) "*askString*serverTimeout*Text.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_serverTimeout)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Enter waiting period before resending a failed command.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ASKTEXTTRAN(),
    (String) "*askString*quitTimeout*Command.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_quitTimeout)\\n"
        "<Btn3Down>: set()\\n"
        "<Btn1Up>:notify() increase(*quitTimeout*text,-1,1,60) unset()\\n"
        "<Btn3Up>:notify() increase(*quitTimeout*text, 1,1,60) unset()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Enter waiting period before cutting connection while quitting.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n",
    (String) "*askString*quitTimeout*Text.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_quitTimeout)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Enter waiting period before cutting connection while quitting.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ASKTEXTTRAN(),
    (String) "*askString*tersePlay*Command.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_tersePlay)\\n"
        "<Btn3Down>: set()\\n"
        "<Btn1Up>:notify() toggleboolean(*tersePlay*text) unset()\\n"
        "<Btn3Up>:notify() toggleboolean(*tersePlay*text) unset()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Should we try to reduce server traffic while involved in a game ?\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n",
    (String) "*askString*tersePlay*Text.translations: #override\\n"
        "Shift<Btn1Down>: help(askstring_tersePlay)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Should we try to reduce server traffic while involved in a game ?\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ASKTEXTTRAN(),

    (String) "*stringList*allowShellResize:        True",
    (String) "*stringList*Text*editType:           edit",
    (String) "*stringList*Text.resize:             both",
    (String) "*stringList*Command.background:      Green",
#ifndef   XAW3D
    (String) "*stringList*Command*shapeStyle:      roundedRectangle",
#endif /* XAW3D */
    (String) "*stringList*cancel.background:       Red",
    (String) "*stringList*cancel.foreground:       Yellow",
    (String) "*stringList*cancel.translations:     #override\\n"
        "Shift<Btn1Down>: help(stringList_cancel)\\n"
        "<Btn1Up>: notify() unset() destroy(\"\")\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Forget it. Don't change the old values.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*stringList*ok.translations:         #override\\n"
        "Shift<Btn1Down>: help(stringList_ok)\\n"
        "<Btn1Up>: notify() unset()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Accept the entered values.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*stringList*Text.translations: #override\\n"
        "Shift<Btn1Down>: help(stringList_text)\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Enter what you want as new string list.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        META "<Key>c:change() \\n"
        META "<Key>w:widgets()\\n"
        META "<Key>h:info()",

    (String) "*challenge.title:                    Challenging %N[%n]%A",
    (String) "*challenge.iconName:                 challenging %N[%n]%A",
    (String) "*challenge.translations:             #override\\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol()\\n"
        "<ClientMessage>DELETE:         destroy()",
    (String) "*challenge*close.translations:       #override\\n"
        "Shift<Btn1Down>: help(challenge_close)\\n"
        "<Btn1Up>: notify() maydecline() unset() destroy(\"\")\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Destroy the challenge widget.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*challenge*ok.translations:          #override\\n"
        "Shift<Btn1Down>: help(challenge_ok)\\n"
        "<Btn1Up>: notify() unset()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Accept the current values and send proposal.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*challenge*decline.translations:     #override\\n"
        "Shift<Btn1Down>: help(challenge_decline)\\n"
        "<Btn1Up>: notify() maydecline() unset() destroy(\"\")\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Don't play against the other person.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*challenge*getTell.translations:     #override\\n"
        "Shift<Btn1Down>: help(challenge_tell)\\n"
        "<EnterWindow>: highlight(Always) setvalues(*shortHelp, label,"
            "\"Toggle a widget to talk to the other person.\")\\n"
        "<LeaveWindow>: unhighlight() " SETDEFTEXT,
    (String) "*challenge*getStats.translations:    #override\\n"
        "Shift<Btn1Down>: help(challenge_stats)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Get extra info about the other person.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*challenge*colorWhite.translations:  #override\\n"
        "Shift<Btn1Down>: help(challenge_colorWhite)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"With this choice you will play white.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n"
        "<Btn1Up>: notify() setmanage(*colorBlack, 1, *colorWhite, 0) unset()",
    (String) "*challenge*colorBlack.translations:  #override\\n"
        "Shift<Btn1Down>: help(challenge_colorBlack)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"With this choice you will play black.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n"
        "<Btn1Up>: notify() setmanage(*colorBlack, 0, *colorWhite, 1) unset()",
    (String) "*challenge*rulesIgs.translations:  #override\\n"
        "Shift<Btn1Down>: help(challenge_rulesIgs)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"The game will be played according to the IGS rules.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n"
        "<Btn1Up>: notify() setmanage(*rulesGoe, 1, *rulesIgs, 0) unset()",
    (String) "*challenge*rulesGoe.translations:  #override\\n"
        "Shift<Btn1Down>: help(challenge_rulesGoe)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"The game will be played according to the Ing rules.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n"
        "<Btn1Up>: notify() setmanage(*rulesGoe, 0, *rulesIgs, 1) unset()",
    (String) "*challenge*tournamentYes.translations:  #override\\n"
        "Shift<Btn1Down>: help(challenge_tournamentYes)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"The game will be a tournament game.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n"
        "<Btn1Up>: notify() setmanage(*tournamentNo, 1, *tournamentYes, 0) unset()",
    (String) "*challenge*tournamentNo.translations:  #override\\n"
        "Shift<Btn1Down>: help(challenge_tournamentNo)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"The game will be a non tournament game.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n"
        "<Btn1Up>: notify() setmanage(*tournamentNo, 0, *tournamentYes, 1) unset()",
    (String) "*challenge*sizeLabel.translations:   #override\\n"
        "Shift<Btn1Down>: help(challenge_sizeLabel)\\n"
        "<Btn3Down>: set()\\n"
        "<Btn1Up>: notify() increase(*size*text, -1, 2, 25) unset()\\n"
        "<Btn3Up>: notify() increase(*size*text,  1, 2, 25) unset()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Enter the board size.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*challenge*size*text.translations:   #override\\n"
        "Shift<Btn1Down>: help(challenge_size)\\n"
        ONTAB("nexttext()")"\\n"
        ONENTER("nexttext()")"\\n"
        ONBACKTAB("previoustext()")"\\n"
        "<Btn1Down>: thistext() select-start()\\n"
        "<Btn2Down>: thistext() insert-selection(\"PRIMARY\", \"CUT_BUFFER0\")\\n"
        "<Btn3Down>: thistext() extend-start()\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Enter the board size.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        META "<Key>c:change() \\n"
        META "<Key>w:widgets()\\n"
        META "<Key>h:info()",
    (String) "*challenge*timeLabel.translations:   #override\\n"
        "Shift<Btn1Down>: help(challenge_timeLabel)\\n"
        "<Btn3Down>: set()\\n"
        "<Btn1Up>: notify() increase(*time*text, -5, 0, 300) unset()\\n"
        "<Btn3Up>: notify() increase(*time*text,  5, 0, 300) unset()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Enter game time in minutes.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*challenge*time*text.translations:   #override\\n"
        "Shift<Btn1Down>: help(challenge_time)\\n"
        ONTAB("nexttext()")"\\n"
        ONENTER("nexttext()")"\\n"
        ONBACKTAB("previoustext()")"\\n"
        "<Btn1Down>: thistext() select-start()\\n"
        "<Btn2Down>: thistext() insert-selection(\"PRIMARY\", \"CUT_BUFFER0\")\\n"
        "<Btn3Down>: thistext() extend-start()\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Enter game time in minutes.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        META "<Key>c:change() \\n"
        META "<Key>w:widgets()\\n"
        META "<Key>h:info()",
    (String) "*challenge*byoYomiLabel.translations:   #override\\n"
        "Shift<Btn1Down>: help(challenge_byoYomiLabel)\\n"
        "<Btn3Down>: set()\\n"
        "<Btn1Up>: notify() increase(*byoYomi*text, -1, 0, 40) unset()\\n"
        "<Btn3Up>: notify() increase(*byoYomi*text,  1, 0, 40) unset()\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Enter byo yomi.\")\\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    (String) "*challenge*byoYomi*text.translations:   #override\\n"
        "Shift<Btn1Down>: help(challenge_byoYomi)\\n"
        ONTAB("nexttext()")"\\n"
        ONENTER("nexttext()")"\\n"
        ONBACKTAB("previoustext()")"\\n"
        "<Btn1Down>: thistext() select-start()\\n"
        "<Btn2Down>: thistext() insert-selection(\"PRIMARY\", \"CUT_BUFFER0\")\\n"
        "<Btn3Down>: thistext() extend-start()\\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Enter byo yomi.\")\\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        META "<Key>c:change() \\n"
        META "<Key>w:widgets()\\n"
        META "<Key>h:info()",
    (String) "*challenge*allowShellResize:         True",
#ifndef XAW3D
    (String) "*challenge.?.width:                  194",
#else  /* XAW3D */
    (String) "*challenge.?.width:                  207",
#endif /* XAW3D */
    (String) "*challenge*Label.background:         Green",
    (String) "*challenge*Command.background:       Green",
    (String) "*challenge*Toggle.background:        Green",
    (String) "*challenge*close.background:         Red",
    (String) "*challenge*Text*editType:            edit",
    (String) "*challenge*Text.resize:              both",
    (String) "*challenge*Text.displayCaret:        False",
/*  (String) "*challenge*Text.displayCaret:        False", */
    (String) "*challenge*Paned.?.showGrip:         False",
    (String) "*challenge*Paned.?.allowResize:      True",
    (String) "*challenge*Paned.?.resizeToPreferred:True",
    (String) "*challenge*Paned.?.showGrip:         False",
    (String) "*challenge*Paned.?.allowResize:      True",
    (String) "*challenge*Paned.?.resizeToPreferred:True",
/*    (String) "*challenge*collect.orientation:      vertical", */
    (String) "*challenge*collect*Paned.orientation:horizontal",
    (String) "*challenge*stateChallenger.label:    You are challenging",
    (String) "*challenge*stateChallengee.label:    You are challenged",
    (String) "*challenge*stateDispute.label:       There is a dispute",
    (String) "*challenge*stateDecline.label:       You were declined",
    (String) "*challenge*sizeLabel.label:          Board size:",
    (String) "*challenge*timeLabel.label:          game time :",
    (String) "*challenge*byoYomiLabel.label:       byo yomi  :",
    (String) "*challenge*colorBlack.label:         Black",
    (String) "*challenge*colorWhite.label:         White",
    (String) "*challenge*colorBlack.foreground:    White",
    (String) "*challenge*colorBlack.background:    Black",
    (String) "*challenge*colorWhite.foreground:    Black",
    (String) "*challenge*colorWhite.background:    White",
    (String) "*challenge*rulesIgs.label:           IGS",
    (String) "*challenge*rulesGoe.label:           GOE",
    (String) "*challenge*tournamentYes.label:      \\   Tournament",
    (String) "*challenge*tournamentNo.label:       No tournament",

    (String) "*popMessage*Label.background:        Green",
    (String) "*popMessage*ok.foreground:           Yellow",
    (String) "*popMessage*ok.background:           Red",
    (String) "*popMessage*Paned.?.showGrip:        False",
    (String) "*popMessage*ok.translations:         #override\\n"
        "<Btn1Down>,<Btn1Up>: destroy(\"\")",
    (String) "*buttons*quit.foreground:            Yellow",
    (String) "*buttons*quit.background:            Red",
    (String) "*buttons*close.foreground:           Yellow",
    (String) "*buttons*close.background:           Red",
/*
    (String) "*buttons.bug.foreground:             Yellow",
    (String) "*buttons.bug.background:             #6B238E",
*/
    (String) "*buttons*?.foreground:               XtDefaultForeground",
    (String) "*buttons*?.background:               Green",
    (String) "*buttons*quit.label:                 Quit",
    (String) "*buttons*close.label:                Close",
    (String) "*buttons*update.label:               Update",
    (String) "*buttons*gamesButton.label:          Games",
    (String) "*buttons*playersButton.label:        Players",
    (String) "*buttons*messageButton.label:        Messages",
    (String) "*buttons*broadcastButton.label:      Broadcasts",
    (String) "*buttons*yellButton.label:           Channels",
    (String) "*buttons*analyzeButton.label:        Analyze",
    (String) "*buttons*eventsButton.label:         Events",
    (String) "*buttons*reviewsButton.label:        Reviews",
    (String) "*buttons*Text.resize:                both",
    (String) "*buttons*Text.displayCaret:          False",
#ifndef   XAW3D
    (String) "*buttons*shapeStyle:                 roundedRectangle",
#endif /* XAW3D */
    (String) "*times*?.foreground:                 XtDefaultForeground",
    (String) "*times*?.background:                 Green",
    (String) "*times*Text.resize:                  both",
    (String) "*times*Text.displayCaret:            False",
#ifndef   XAW3D
    (String) "*times*shapeStyle:                   roundedRectangle",
#endif /* XAW3D */

    (String) "*scrollboard.orientation:            horizontal",
    (String) "*scrollboard.?.showGrip:             False",

#ifdef    XAW3D
    (String) "*Label.borderWidth:                  0",
#endif /* XAW3D */
    (String) "*getStats.label:                     Stats",
    (String) "*getTell.label:                      Tell",
    (String) "*getChallenge.label:                 Challenge",
    (String) "*options.label:                      Options",
    (String) "*commands.label:                     Commands",
    (String) "*undo.label:                         Undo",
    (String) "*copy.label:                         Copy",
    (String) "*pass.label:                         Pass",
    (String) "*done.label:                         Done",
    (String) "*save.label:                         Save",
    (String) "*options.translations:               #override\\n"
        "~Shift<Btn1Down>: reset() popupmenu(optionMenu)\\n"
        "~Shift<Btn3Down>: reset() popupmenu(optionMenu, 1)\\n"
        " Shift<Btn1Down>: help(help_options)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Press left mouse button for a menu with options.\")\\n"
        "<LeaveWindow>: reset() setvalues(*shortHelp, label," DEFTEXT ")",
    (String) "*commands.translations:              #override\\n"
        "~Shift<Btn1Down>: reset() popupmenu(commandMenu)\\n"
        "~Shift<Btn3Down>: reset() popupmenu(commandMenu, 1)\\n"
        " Shift<Btn1Down>: help(help_commands)\\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Press left mouse button for a menu with commands.\")\\n"
        "<LeaveWindow>: reset() setvalues(*shortHelp, label," DEFTEXT ")",

    (String) "*optionMenu*?.HorizontalMargins:     30",
    (String) "*optionMenu*SmeLabel.HorizontalMargins: 4",
    (String) "*optionMenu*sgfFromStart.state:      True",
    (String) "*optionMenu*psFromStart.state:       True",
    (String) "*optionMenu*messageLabel.label:      On message:",
    (String) "*optionMenu*fileLabel.label:         Save file:",
    (String) "*optionMenu*file.label:              filename",
    (String) "*optionMenu*othersLabel.label:       Other options:",
    (String) "*optionMenu*patternsLabel.label:     Regex patterns:",
    (String) "*optionMenu*passPattern.label:       pass",
    (String) "*optionMenu*killPattern.label:       kill",
    (String) "*optionMenu*analyzeSize.label:       analyze size",
    (String) "*optionMenu*programSettings.label:   program settings",
    (String) "*optionMenu*observeMoveLabel.label:  On move:",
    (String) "*optionMenu*moveBeep.label:          beep",
    (String) "*optionMenu*moveRaise.label:         raise",
    (String) "*optionMenu*errorLabel.label:        On Error:",
    (String) "*optionMenu*errorBeep.label:         beep",
    (String) "*optionMenu*errorRaise.label:        raise",
    (String) "*optionMenu*sortLabel.label:         Sort by:",
    (String) "*optionMenu*outputLabel.label:       On Output:",
    (String) "*optionMenu*beepLabel.label:         On Beep:",
    (String) "*optionMenu*beepBeep.label:          beep",
    (String) "*optionMenu*beepRaise.label:         raise",
    (String) "*optionMenu*kibitzActionLabel.label: On Kibitz:",
    (String) "*optionMenu*kibitzBeep.label:        beep",
    (String) "*optionMenu*kibitzRaise.label:       raise",
    (String) "*optionMenu*sgfLabel.label:          Sgf file:",
    (String) "*optionMenu*sgfFile.label:           filename",
    (String) "*optionMenu*sgfOverwrite.label:      overwrite",
    (String) "*optionMenu*sgfFromStart.label:      from start",
    (String) "*optionMenu*psLabel.label:           Ps file:",
    (String) "*optionMenu*psFile.label:            filename",
    (String) "*optionMenu*psOverwrite.label:       overwrite",
    (String) "*optionMenu*psFromStart.label:       from start",
    (String) "*optionMenu*kibitzLabel.label:       Kibitz file:",
    (String) "*optionMenu*kibitzFile.label:        filename",
    (String) "*optionMenu*kibitzOverwrite.label:   overwrite",
    (String) "*optionMenu*allowSuicide.label:      allow suicide",
    (String) "*optionMenu*sortName.label:          Name",
    (String) "*optionMenu*sortNumber.label:        Number",
    (String) "*optionMenu*sortStrength.label:      Strength",

    (String) "*players*optionMenu*sortName.radioGroup: *sortStrength",
    (String) "*games*optionMenu*sortNumber.radioGroup: *sortStrength",

    (String) "*commandMenu*declineAdjourn.label:   decline adjourn",
    (String) "*commandMenu*sgfSave.label:          save game",
    (String) "*commandMenu*psSave.label:           save postscript",
    (String) "*commandMenu*kibitzSave.label:       save kibitzes",
    (String) "*commandMenu*talkBlack.label:        talk to %B",
    (String) "*commandMenu*talkWhite.label:        talk to %W",
    (String) "*commandMenu*statsBlack.label:       stats %B",
    (String) "*commandMenu*statsWhite.label:       stats %W",
    (String) "*commandMenu*statsMe.label:          stats %N",

    (String) "*textForm.text*borderWidth:          0",
    (String) "*textForm.?.resizable:               True",
    (String) "*buttons*optionMenu*background:      XtDefaultBackground",
    (String) "*buttons*commandMenu*background:     XtDefaultBackground",
    (String) "*options.menuName:                   optionMenu",
    (String) "*igsMessages*raise.state:            True",
    (String) "*igsMessages*errorRaise.state:       True",
    (String) "*SmeBell.state:                      True",
    (String) "*blink.state:                        True",
    (String) "*info.scrollVertical:                whenNeeded",
    (String) "*Text.wrap:                          word",
    (String) "*Viewport.allowHoriz:                True",
    (String) "*Viewport.allowVert:                 True",
    (String) "*Viewport.forceBars:                 True",
    (String) "*input*editType:                     edit",
    (String) "*board.background:                   #FFA54F",
    (String) "*StripChart.jumpScroll:              1",
    (String) "*background:                         #BFD8D8",
    (String) "*?*accelerators:                     #augment\\n"
        META "<Key>c: change() \\n"
        META "<Key>w: widgets()\\n"
        META "<Key>h: info()",
#ifdef    XAW3D
    (String) "*shadowWidth:                        3",
#endif /* XAW3D */

    (String) "*widgetTreeMacro.mainWidget:"
        "main.Paned"
            "(collect.Paned"
                "(buttons.Box"
                    "(quit.Toggle"
                    " #mainOptions"
                    " commands.Command"
                        "(commandMenu.TearofMenu"
                            "(analyzeButton.SmeBSB"
                            " save.SmeBSB"
                            " statsMe.SmeBSB.statsMe"
                            ")"
                        ")"
                    " gamesButton.Toggle"
                    " playersButton.Toggle"
                    " messageButton.Toggle"
                    " broadcastButton.Toggle"
                    " yellButton.Toggle"
                    " reviewsButton.Toggle"
                    " eventsButton.Toggle"
                    ")"
                " times.Box"
                    "(localTime.AsciiText     [string.localTime]"
                    " universalTime.AsciiText [string.universalTime]"
                    " serverTime.AsciiText    [string.serverTime]"
                    ")"
                " shortHelp.Label"
                " info.AsciiText"
                " input.AsciiText"
                ")"
            ")",
    (String) "*widgetTreeMacro.mainOptions:"
        " options.Command"
            "(optionMenu.TearofMenu"
                "("
                " outputLabel.SmeLabel"
                " line.SmeLine"
                " beep.SmeBell"
                " raise.SmeToggle"
                " line.SmeLine"
                " #errorOptions"
                " line.SmeLine"
                " fileLabel.SmeLabel"
                " line.SmeLine"
                " file.SmeBSB"
                " overwrite.SmeToggle"
                " line.SmeLine"
                " connect.SmeLabel"
                " line.SmeLine"
                " hasConnect.SmeToggle"
                " wantConnect.SmeToggle"
                " line.SmeLine"
                " othersLabel.SmeLabel"
                " line.SmeLine"
                " programSettings.SmeBSB"
                " stdout.SmeToggle"
                ")"
            ")",
    (String) "*widgetTreeMacro.quitConfirm:"
        " quitConfirm.TopLevelShell"
            "(buttons.Paned"
                "(confirm.Label"
                " confirmContainer.Paned"
                    "(ok.Command"
                    " filler.Core"
                    " cancel.Command"
                    ")"
                ")"
            ")",
    (String) "*widgetTreeMacro.askText:"
        SHADOWTEXT(""),
    (String) "*widgetTreeMacro.askFilename:"
        SHADOWTEXT("[string.filename]"),
    (String) "*widgetTreeMacro.askTimeout:"
        SHADOWTEXT("[string.timeout]"),
    (String) "*widgetTreeMacro.askUserPass:"
        " user.Paned.user"
            "(userLabel.Label"
            " #askText"
            ")"
        " password.Paned.password"
            "(passwordLabel.Label"
            " #askText"
            ")",
    (String) "*widgetTreeMacro.askFiles:"
        " sgfFilename.Paned.sgfFilename"
            "(sgfFilenameLabel.Label"
            " #askFilename"
            ")"
        " psFilename.Paned.psFilename"
            "(psFilenameLabel.Label"
            " #askFilename"
            ")"
        " kibitzFilename.Paned.kibitzFilename"
            "(kibitzFilenameLabel.Label"
            " #askFilename"
            ")"
        " broadcastFilename.Paned.broadcastFilename"
            "(broadcastFilenameLabel.Label"
            " #askFilename"
            ")"
        " yellFilename.Paned.yellFilename"
            "(yellFilenameLabel.Label"
            " #askFilename"
            ")"
        " tellFilename.Paned.tellFilename"
            "(tellFilenameLabel.Label"
            " #askFilename"
            ")"
        " serverFilename.Paned.serverFilename"
            "(serverFilenameLabel.Label"
            " #askFilename"
            ")"
        " eventsFilename.Paned.eventsFilename"
            "(serverFilenameLabel.Label"
            " #askFilename"
            ")"
        " mainFilename.Paned.mainFilename"
            "(mainFilenameLabel.Label"
            " #askFilename"
            ")",
    (String) "*widgetTreeMacro.askTimeouts:"
        " replayTimeout.Paned.replayTimeout"
            "(replayTimeoutLabel.Command"
            " #askTimeout"
            ")"
        " whoTimeout.Paned.whoTimeout"
            "(whoTimeoutLabel.Command"
            " #askTimeout"
            ")"
        " gamesTimeout.Paned.gamesTimeout"
            "(gamesTimeoutLabel.Command"
            " #askTimeout"
            ")"
        " reviewsTimeout.Paned.reviewsTimeout"
            "(reviewsTimeoutLabel.Command"
            " #askTimeout"
            ")"
        " clockTimeout.Paned.clockTimeout"
            "(clockTimeoutLabel.Command"
            " #askTimeout"
            ")"
        " playersUpdateTimeout.Paned.playersUpdateTimeout"
            "(playersUpdateTimeoutLabel.Command"
            " #askTimeout"
            ")"
        " gamesUpdateTimeout.Paned.gamesUpdateTimeout"
            "(gamesUpdateTimeoutLabel.Command"
            " #askTimeout"
            ")"
        " reviewsUpdateTimeout.Paned.reviewsUpdateTimeout"
            "(reviewsUpdateTimeoutLabel.Command"
            " #askTimeout"
            ")"
        " serverTimeout.Paned.serverTimeout"
            "(serverTimeoutLabel.Command"
            " #askTimeout"
            ")"
        " inactiveTimeout.Paned.inactiveTimeout"
            "(inactiveTimeoutLabel.Command"
            " #askTimeout"
            ")"
        " quitTimeout.Paned.quitTimeout"
            "(quitTimeoutLabel.Command"
            " #askTimeout"
            ")",
    (String) "*widgetTreeMacro.askString:"
        " askString.TopLevelShell.askString [title.title][iconName.title]"
            "(collect.Box"
                "(#askUserPass"
                " #askFiles"
                " analyzeSize.Paned.analyzeSize"
                    "(analyzeSizeLabel.Command"
                      SHADOWTEXT("[string.size]")
                    ")"
                " allowSuicide.Paned.allowSuicide"
                    "(allowSuicideLabel.Command"
                      SHADOWTEXT("[string.boolean]")
                    ")"
                " #askTimeouts"
                " tersePlay.Paned.tersePlay"
                    "(tersePlayLabel.Command"
                      SHADOWTEXT("[string.boolean]")
                    ")"
                ")"
            ")"
        " stringList.TopLevelShell.stringList"
            "(collect.Box"
                "(cancel.Command"
                " ok.Command"
                " text.AsciiText[string.text]"
                ")"
            ")",
    (String) "*widgetTreeMacro.popMessage:"
        " popMessage.TopLevelShell.popMessage [title.title][iconName.title]"
            "(collect.Paned"
                "(message.Label[label.text]"
                " ok.Command"
                ")"
            ")",
    (String) "*widgetTreeMacro.players:"
        " players.TopLevelShell.players"
            "(collect.Paned"
                "(buttons.Box"
                    "(close.Command"
                    " options.Command"
                        "(optionMenu.TearofMenu"
                            "("
                            " sortLabel.SmeLabel"
                            " line.SmeLine"
                            " sortStrength.SmeToggle"
                            " sortName.SmeToggle"
                            " line.SmeLine"
                            " othersLabel.SmeLabel"
                            " line.SmeLine"
                            " allowResize.SmeToggle"
                            ")"
                        ")"
                    " update.Command"
                    ")"
/*
                " viewport.Viewport"
                    "("
*/
                    "set.Box"
                        "(,Command.entry[name.name])"
/*
                    ")"
*/
                " stats.Label"
                " stripform.Form"
                    "(strip.StripChart"
                    ")"
                " info.AsciiText"
                ")"
            ")",
    (String) "*widgetTreeMacro.games:"
        " games.TopLevelShell.games"
            "(collect.Paned"
                "(buttons.Box"
                    "(close.Command"
                    " options.Command"
                        "(optionMenu.TearofMenu"
                            "("
                            " sortLabel.SmeLabel"
                            " line.SmeLine"
                            " sortStrength.SmeToggle"
                            " sortNumber.SmeToggle"
                            " line.SmeLine"
                            " othersLabel.SmeLabel"
                            " line.SmeLine"
                            " allowResize.SmeToggle"
                            ")"
                        ")"
                    " update.Command"
                    ")"
/*
                " viewport.Viewport"
                    "("
*/
                    "set.Box"
                        "(,Toggle.entry[name.name])"
/*
                    ")"
*/
                " stripform.Form"
                    "(strip.StripChart"
                    ")"
                " info.AsciiText"
                ")"
            ")",
    (String) "*widgetTreeMacro.reviews:"
        " reviews.TopLevelShell.reviews"
            "(collect.Paned"
                "(buttons.Box"
                    "(close.Command"
                    " options.Command"
                        "(optionMenu.TearofMenu"
                            "("
                            " othersLabel.SmeLabel"
                            " line.SmeLine"
                            " allowResize.SmeToggle"
                            ")"
                        ")"
                    " update.Command"
                    ")"
                " viewport.Viewport"
                    "(set.Box"
                        "(,Command.entry[name.name])"
                    ")"
                ")"
            ")",
    (String) "*widgetTreeMacro.igsMessages:"
        " igsMessages.TopLevelShell.igsMessages"
            "(collect.Paned"
                "(buttons.Box"
                    "(close.Command"
                    " options.Command"
                        "(optionMenu.TearofMenu"
                            "(messageLabel.SmeLabel"
                            " line.SmeLine"
                            " beep.SmeBell"
                            " raise.SmeToggle"
                            " line.SmeLine"
                            " #errorOptions"
                            " line.SmeLine"
                            " fileLabel.SmeLabel"
                            " line.SmeLine"
                            " file.SmeBSB"
                            " overwrite.SmeToggle"
                            ")"
                        ")"
                    " save.Command"
                    ")"
                " info.AsciiText"
                ")"
            ")",
    (String) "*widgetTreeMacro.events:"
        " events.TopLevelShell.events"
            "(collect.Paned"
                "(buttons.Box"
                    "(close.Command"
                    " options.Command"
                        "(optionMenu.TearofMenu"
                            "(messageLabel.SmeLabel"
                            " line.SmeLine"
                            " beep.SmeBell"
                            " raise.SmeToggle"
                            " line.SmeLine"
                            " #errorOptions"
                            " line.SmeLine"
                            " fileLabel.SmeLabel"
                            " line.SmeLine"
                            " file.SmeBSB"
                            " overwrite.SmeToggle"
                            ")"
                        ")"
                    " save.Command"
                    ")"
                " info.AsciiText"
                ")"
            ")",
    (String) "*widgetTreeMacro.broadcasts:"
        " broadcasts.TopLevelShell.broadcasts"
            "(collect.Paned"
                "(buttons.Box"
                    "(close.Command"
                    " options.Command"
                        "(optionMenu.TearofMenu"
                            "(messageLabel.SmeLabel"
                            " line.SmeLine"
                            " beep.SmeBell"
                            " raise.SmeToggle"
                            " line.SmeLine"
                            " #errorOptions"
                            " line.SmeLine"
                            " fileLabel.SmeLabel"
                            " line.SmeLine"
                            " file.SmeBSB"
                            " overwrite.SmeToggle"
                            " line.SmeLine"
                            " patternsLabel.SmeLabel"
                            " line.SmeLine"
                            " killPattern.SmeBSB"
                            " passPattern.SmeBSB"
                            ")"
                        ")"
                    " save.Command"
                    ")"
                " info.AsciiText"
                " input.AsciiText"
                ")"
            ")",
    (String) "*widgetTreeMacro.yells:"
        " yells.TopLevelShell.yells"
            "(collect.Paned"
                "(buttons.Box"
                    "(close.Command"
                    " options.Command"
                        "(optionMenu.TearofMenu"
                            "(messageLabel.SmeLabel"
                            " line.SmeLine"
                            " beep.SmeBell"
                            " raise.SmeToggle"
                            " line.SmeLine"
                            " #errorOptions"
                            " line.SmeLine"
                            " fileLabel.SmeLabel"
                            " line.SmeLine"
                            " file.SmeBSB"
                            " overwrite.SmeToggle"
                            " line.SmeLine"
                            " patternsLabel.SmeLabel"
                            " line.SmeLine"
                            " killPattern.SmeBSB"
                            " passPattern.SmeBSB"
                            ")"
                        ")"
                    " save.Command"
                    " channels.Command"
                    " channel.AsciiText"
                    " moderator.AsciiText"
                    " state.AsciiText"
                    ")"
                " title.AsciiText"
                " info.AsciiText"
                " input.AsciiText"
                ")"
            ")",
    (String) "*widgetTreeMacro.tell:"
        " tell.TopLevelShell.tell"
            "(collect.Paned"
                "(buttons.Box"
                    "(close.Command"
                    " options.Command"
                        "(optionMenu.TearofMenu"
                            "(messageLabel.SmeLabel"
                            " line.SmeLine"
                            " beep.SmeBell"
                            " raise.SmeToggle"
                            " line.SmeLine"
                            " beepLabel.SmeLabel"
                            " line.SmeLine"
                            " beepBeep.SmeBell"
                            " beepRaise.SmeToggle"
                            " line.SmeLine"
                            " #errorOptions"
                            " line.SmeLine"
                            " fileLabel.SmeLabel"
                            " line.SmeLine"
                            " file.SmeBSB"
                            " overwrite.SmeToggle"
                            " line.SmeLine"
                            " patternsLabel.SmeLabel"
                            " line.SmeLine"
                            " killPattern.SmeBSB"
                            " passPattern.SmeBSB"
                            ")"
                        ")"
                    " save.Command"
                    " bug.Command"
                    " getStats.Command"
                    " getChallenge.Toggle"
                    ")"
                " info.AsciiText"
                " input.AsciiText"
                ")"
            ")",
    (String) "*widgetTreeMacro.stats:"
        " stats.TopLevelShell.stats"
            "(collect.Box"
                "(close.Command"
                " info.AsciiText.info[string.text][name.name]"
                " toggle.Toggle.toggle[label.text][name.name]"
                " results.AsciiText.results[string.text]"
                ")"
            ")",
    (String) "*widgetTreeMacro.sgfOptions:"
        " sgfLabel.SmeLabel"
        " line.SmeLine"
        " sgfFile.SmeBSB"
        " sgfFromStart.SmeToggle"
        " sgfOverwrite.SmeToggle",
    (String) "*widgetTreeMacro.psOptions:"
        " psLabel.SmeLabel"
        " line.SmeLine"
        " psFile.SmeBSB"
        " psFromStart.SmeToggle"
        " psOverwrite.SmeToggle",
    (String) "*widgetTreeMacro.moveOptions:"
        " observeMoveLabel.SmeLabel"
        " line.SmeLine"
        " moveBeep.SmeBell"
        " moveRaise.SmeToggle",
    (String) "*widgetTreeMacro.errorOptions:"
        " errorLabel.SmeLabel"
        " line.SmeLine"
        " errorBeep.SmeBell"
        " errorRaise.SmeToggle",
    (String) "*widgetTreeMacro.gameProperties:"
        " komi.Label     [label.komi]"
        " handicap.Label [label.handicap]"
        " captures.Label [label.captures]"
        " move.Label     [label.move]"
        " time.AsciiText [string.time]",
    (String) "*widgetTreeMacro.review:"
        " review.TopLevelShell.review"
            "(collect.Paned"
                "(buttons.Box"
                    "(close.Command"
                    " options.Command"
                        "(optionMenu.TearofMenu"
                            "(#moveOptions"
                            " line.SmeLine"
                            " kibitzActionLabel.SmeLabel"
                            " line.SmeLine"
                            " kibitzBeep.SmeBell"
                            " kibitzRaise.SmeToggle"
                            " line.SmeLine"
                            " #errorOptions"
                            " line.SmeLine"
                            " #sgfOptions"
                            " line.SmeLine"
                            " #psOptions"
                            " line.SmeLine"
                            " kibitzLabel.SmeLabel"
                            " line.SmeLine"
                            " kibitzFile.SmeBSB"
                            " kibitzOverwrite.SmeToggle"
                            " line.SmeLine"
                            " othersLabel.SmeLabel"
                            " line.SmeLine"
                            " blink.SmeToggle"
                            " replay.SmeToggle"
                            ")"
                        ")"
                    " commands.Command"
                        "(commandMenu.TearofMenu"
                            "(dup.SmeBSB"
                            " analyze.SmeBSB"
                            " sgfSave.SmeBSB"
                            " psSave.SmeBSB"
                            " kibitzSave.SmeBSB"
                            ")"
                        ")"
                    " #gameProperties"
                    ")"
                " titleObserve.AsciiText[string.title]"
                " scrollboard.Paned"
                    "(scroll.Scrollbar"
                    " board.Board [boardSize.boardSize]"
                    ")"
                " info.AsciiText"
                ")"
            ")",
    (String) "*widgetTreeMacro.observeObserve:"
        " observe.TopLevelShell.observe"
            "(collect.Paned"
                "(buttons.Box"
                    "(close.Command"
                    " options.Command"
                        "(optionMenu.TearofMenu"
                            "(#moveOptions"
                            " line.SmeLine"
                            " kibitzActionLabel.SmeLabel"
                            " line.SmeLine"
                            " kibitzBeep.SmeBell"
                            " kibitzRaise.SmeToggle"
                            " line.SmeLine"
                            " #errorOptions"
                            " line.SmeLine"
                            " #sgfOptions"
                            " line.SmeLine"
                            " #psOptions"
                            " line.SmeLine"
                            " kibitzLabel.SmeLabel"
                            " line.SmeLine"
                            " kibitzFile.SmeBSB"
                            " kibitzOverwrite.SmeToggle"
                            " line.SmeLine"
                            " patternsLabel.SmeLabel"
                            " line.SmeLine"
                            " killPattern.SmeBSB"
                            " passPattern.SmeBSB"
                            " line.SmeLine"
                            " othersLabel.SmeLabel"
                            " line.SmeLine"
                            " blink.SmeToggle"
                            " replay.SmeToggle"
                            ")"
                        ")"
                    " commands.Command"
                        "(commandMenu.TearofMenu"
                            "(refresh.SmeBSB"
                            " score.SmeBSB"
                            " bets.SmeBSB"
                            " observers.SmeBSB"
                            " dup.SmeBSB"
                            " analyze.SmeBSB"
                            " sgfSave.SmeBSB"
                            " psSave.SmeBSB"
                            " kibitzSave.SmeBSB"
                            " talkBlack.SmeBSB"
                            " talkWhite.SmeBSB"
                            " statsBlack.SmeBSB"
                            " statsWhite.SmeBSB"
                            ")"
                        ")"
                    " #gameProperties"
                    ")"
                " titleObserve.AsciiText[string.title]"
                " scrollboard.Paned"
                    "(scroll.Scrollbar"
                    " board.Board [boardSize.boardSize]"
                    ")"
                " info.AsciiText"
                " input.AsciiText"
                ")"
            ")",
    (String) "*widgetTreeMacro.observePlay:"
        " observe.TopLevelShell.play"
            "(collect.Paned"
                "(buttons.Box"
                    "(close.Command"
                    " options.Command"
                        "(optionMenu.TearofMenu"
                            "(#moveOptions"
                            " line.SmeLine"
                            " kibitzActionLabel.SmeLabel"
                            " line.SmeLine"
                            " kibitzBeep.SmeBell"
                            " kibitzRaise.SmeToggle"
                            " line.SmeLine"
                            " #errorOptions"
                            " line.SmeLine"
                            " #sgfOptions"
                            " line.SmeLine"
                            " #psOptions"
                            " line.SmeLine"
                            " kibitzLabel.SmeLabel"
                            " line.SmeLine"
                            " kibitzFile.SmeBSB"
                            " kibitzOverwrite.SmeToggle"
                            " line.SmeLine"
                            " othersLabel.SmeLabel"
                            " line.SmeLine"
                            " blink.SmeToggle"
                            " replay.SmeToggle"
                            ")"
                         ")"
                    " commands.Command"
                        "(commandMenu.TearofMenu"
                            "(resume.SmeBSB"
                            " adjourn.SmeBSB"
                            " declineAdjourn.SmeBSB"
                            " refresh.SmeBSB"
                            " score.SmeBSB"
                            " observers.SmeBSB"
                            " dup.SmeBSB"
                            " analyze.SmeBSB"
                            " sgfSave.SmeBSB"
                            " psSave.SmeBSB"
                            " kibitzSave.SmeBSB"
                            " talkBlack.SmeBSB"
                            " talkWhite.SmeBSB"
                            " statsBlack.SmeBSB"
                            " statsWhite.SmeBSB"
                            ")"
                        ")"
                    " undo.Command"
                    " pass.Command"
                    " done.Command"
                    " #gameProperties"
                    ")"
                " titlePlay.AsciiText[string.title]"
                " scrollboard.Paned"
                    "(scroll.Scrollbar"
                    " board.Board [boardSize.boardSize]"
                    ")"
                " info.AsciiText"
                " input.AsciiText"
                ")"
            ")",
    (String) "*widgetTreeMacro.analyzer:"
        " analyzer.TopLevelShell.analyzer"
            "(collect.Paned"
                "(buttons.Box"
                    "(close.Command"
                    " options.Command"
                        "(optionMenu.TearofMenu"
                            "(#moveOptions"
                            " line.SmeLine"
                            " #errorOptions"
                            " line.SmeLine"
                            " #sgfOptions"
                            " line.SmeLine"
                            " #psOptions"
                            " line.SmeLine"
                            " othersLabel.SmeLabel"
                            " line.SmeLine"
                            " allowSuicide.SmeToggle"
                            " blink.SmeToggle"
                            " replay.SmeToggle"
                            ")"
                        ")"
                    " commands.Command"
                        "(commandMenu.TearofMenu"
                            "(reset.SmeBSB"
                            " analyze.SmeBSB"
                            " sgfSave.SmeBSB"
                            " psSave.SmeBSB"
                            ")"
                        ")"
                    " undo.Command"
                    " copy.Command"
                    ")"
                " scrollboard.Paned"
                    "(scroll.Scrollbar"
                    " board.Board [boardSize.boardSize]"
                    ")"
                ")"
            ")",

    (String) "*widgetTreeMacro.challenge:"
        " challenge.TopLevelShell.challenge"
            "(collect.Paned"
                "(buttons.Box"
                    "(close.Command"
                    " ok.Command"
                    " decline.Command"
                    " getTell.Toggle"
                    " getStats.Command"
                    ")"
                " state.Paned"
                    "(stateChallenger.Label"
                    " stateChallengee.Label"
                    " stateDispute.Label"
                    " stateDecline.Label"
                    ")"
                " choices.Box"
                    "(colorWhite.Command"
                    " colorBlack.Command"
                    " rulesIgs.Command"
                    " rulesGoe.Command"
                    " tournamentYes.Command"
                    " tournamentNo.Command"
                    ")"
                " size.Paned"
                    "(sizeLabel.Command"
                      SHADOWTEXT("[string.size]")
                    ")"
                " time.Paned"
                    "(timeLabel.Command"
                      SHADOWTEXT("[string.time]")
                    ")"
                " byoYomi.Paned"
                    "(byoYomiLabel.Command"
                      SHADOWTEXT("[string.byoyomi]")
                    ")"
                ")"
            ")",

    (String) "*widgetTree: (,ApplicationShell "
                     "(#mainWidget"
                     " #quitConfirm"
                     " #askString"
                     " #popMessage"
                     " #players"
                     " #games"
                     " #reviews"
                     " #igsMessages"
                     " #events"
                     " #broadcasts"
                     " #yells"
                     " #tell"
                     " #stats"
                     " #review"
                     " #observeObserve"
                     " #observePlay"
                     " #analyzer"
                     " #challenge"
                     ")"
                 ")",
    NULL
};
