(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* by Steve Glassman, Mark Manasse and Greg Nelson           *)
(* Last modified on Mon May 10 15:19:43 PDT 1993 by msm      *)
(*      modified on Tue Mar 10 19:11:14 1992 by steveg   *)
(*      modified on Mon Feb 24 13:56:12 PST 1992 by muller   *)
(*      modified on Sat Nov  2 15:59:41 PST 1991 by gnelson  *)
<*PRAGMA LL*>

MODULE TrestleConf;

PROCEDURE Init(<*UNUSED*>createUser: UserProc) =
  BEGIN END Init;

REVEAL
  User = UserPublic BRANDED OBJECT OVERRIDES register := Register END;

PROCEDURE Register(<*UNUSED*>user: User) =
  BEGIN END Register;

REVEAL
  App = AppPublic BRANDED OBJECT
    user: User := NIL
   OVERRIDES
    init := AppInit;
    destroy := Destroy
  END;

PROCEDURE AppInit(app: App; user: User) =
  BEGIN
    app.user := user;
    app.add(user);
    app.activate(user)
  END AppInit;

PROCEDURE Destroy(app: App) =
  BEGIN
    IF app.user # NIL THEN
      app.delete(app.user);
      app.user := NIL
    END
  END Destroy;

BEGIN
END TrestleConf.
