MODULE VBTKitBundle;
(* Generated by m3bundle; see its manpage. *)

IMPORT Bundle, BundleRep, Text;
IMPORT Thread, Wr, TextWr;

TYPE T = Bundle.T OBJECT OVERRIDES get := LookUp END;

VAR bundle: T := NIL;

PROCEDURE Get(): Bundle.T =
  BEGIN
    IF (bundle = NIL) THEN bundle := NEW (T) END;
    RETURN bundle;
  END Get;

PROCEDURE LookUp (<*UNUSED*> self: T;  element: TEXT): TEXT = 
  BEGIN
    FOR i := 0 TO LAST (Names)-1 DO
      IF Text.Equal (Names[i], element) THEN
        IF Elements[i] = NIL THEN Elements[i] := GetElt (i) END;
        RETURN Elements[i];
      END;
    END;
    RETURN NIL;
  END LookUp;

CONST Names = ARRAY [0..22] OF TEXT {
  "NWDiagonal",
  "Close.pbm",
  "NEDiagonal",
  "checkMarkOff",
  "checkMarkOn",
  "radioOff",
  "radioOffExcited",
  "checkOff",
  "checkMarkOnExcited",
  "IvyScrollH",
  "minusOff",
  "checkOffExcited",
  "Grow.pbm",
  "checkOnExcited",
  "checkMarkOffExcited",
  "plusOff",
  "Grid",
  "IvyScrollV",
  "radioOnExcited",
  "checkOn",
  "Digital.pbm",
  "radioOn",
  NIL
};

VAR Elements := ARRAY [0..22] OF TEXT {
  E0,
  E1,
  E2,
  E3,
  E4,
  E5,
  E6,
  E7,
  E8,
  E9,
  E10,
  E11,
  E12,
  E13,
  E14,
  E15,
  E16,
  E17,
  E18,
  E19,
  NIL (* E20 .. E20_15 *),
  E21,
  NIL
};

PROCEDURE GetElt (n: INTEGER): TEXT =
  <*FATAL Thread.Alerted, Wr.Failure *>
  VAR wr := TextWr.New ();
  BEGIN
    CASE n OF
    | 20 =>
        Wr.PutText (wr, E20);
        Wr.PutText (wr, E20_0);
        Wr.PutText (wr, E20_1);
        Wr.PutText (wr, E20_2);
        Wr.PutText (wr, E20_3);
        Wr.PutText (wr, E20_4);
        Wr.PutText (wr, E20_5);
        Wr.PutText (wr, E20_6);
        Wr.PutText (wr, E20_7);
        Wr.PutText (wr, E20_8);
        Wr.PutText (wr, E20_9);
        Wr.PutText (wr, E20_10);
        Wr.PutText (wr, E20_11);
        Wr.PutText (wr, E20_12);
        Wr.PutText (wr, E20_13);
        Wr.PutText (wr, E20_14);
        Wr.PutText (wr, E20_15);
    ELSE (*skip*)
    END;
    RETURN TextWr.ToText (wr);
  END GetElt;

CONST E0 = 
   "P4\n16 16\n\210\210DD\"\"\021\021\210\210DD\"\"\021\021\210\210DD\"\"\021"
 & "\021\210\210DD\"\"\021\021";

CONST E1 = 
   "P4\n# created by \'xv <nil>\'\n14 17\n\000\003\000\003\377\377\200\007\200"
 & "\007\207\307\217\347\237\367\237\367\237\367\237\367\237\367\217\347\207"
 & "\307\200\007\377\377\000\003";

CONST E2 = 
   "P4\n16 16\n\021\021\"\"DD\210\210\021\021\"\"DD\210\210\021\021\"\"DD\210"
 & "\210\021\021\"\"DD\210\210";

CONST E3 = 
   "P4\n16 16\n\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
 & "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000";

CONST E4 = 
   "P4\n16 16\n\000\000\000\000\000\000\000\004\000\014\000\030\0000\000` \300"
 & "1\200\033\000\016\000\004\000\000\000\000\000\000\000";

CONST E5 = 
   "P4\n16 16\n\000\000\000\000\000\000\003\300\0140\010\020\020\010\020\010"
 & "\020\010\020\010\010\020\0140\003\300\000\000\000\000\000\000";

CONST E6 = 
   "P4\n16 16\n\000\000\000\000\007\300\017\360\0348\030\0300\0140\0140\014"
 & "0\014\030\030\0348\017\360\007\300\000\000\000\000";

CONST E7 = 
   "P4\n16 16\n\000\000\000\000\000\000\037\370\020\010\020\010\020\010\020"
 & "\010\020\010\020\010\020\010\020\010\037\370\000\000\000\000\000\000";

CONST E8 = 
   "P4\n16 16\n\000\000\000\000\000\004\000\016\000\036\000<\000x \360q\340"
 & "{\300?\200\037\000\016\000\004\000\000\000\000\000";

CONST E9 = 
   "P4\n16 16\n\210\210\"\"\210\210\"\"\210\210\"\"\210\210\"\"\210\210\"\""
 & "\210\210\"\"\210\210\"\"\210\210\"\"";

CONST E10 = 
   "P4\n16 16\n\000\000\000\000\000\000\000\000\000\000\000\000\037\370\020"
 & "\010\020\010\037\370\000\000\000\000\000\000\000\000\000\000\000\000";

CONST E11 = 
   "P4\n16 16\n\000\000\000\000?\374?\3740\0140\0140\0140\0140\0140\0140\014"
 & "0\014?\374?\374\000\000\000\000";

CONST E12 = 
   "P4\n# created by \'xv <nil>\'\n18 18\n\000\000?\000\000??\377?!\021?!\021"
 & "?!\021?!\021??\021? \021? \021? \021??\361? \001? \001? \001??\377?\000"
 & "\000?\000\000?";

CONST E13 = 
   "P4\n16 16\n\000\000\000\000?\374?\3748\0344,2L1\2141\2142L4,8\034?\374?"
 & "\374\000\000\000\000";

CONST E14 = 
   "P4\n16 16\n\000\000\000\000\000\004\000\n\000\022\000$\000H \220Q J@$\200"
 & "\021\000\n\000\004\000\000\000\000\000";

CONST E15 = 
   "P4\n16 16\n\000\000\000\000\000\000\003\300\002@\002@\036x\020\010\020\010"
 & "\036x\002@\002@\003\300\000\000\000\000\000\000";

CONST E16 = 
   "P4\n16 16\n\252\252\000\000\200\000\000\000\200\200\000\000\200\000\000"
 & "\000\210\210\000\000\200\000\000\000\200\200\000\000\200\000\000\000";

CONST E17 = 
   "P4\n16 16\nUU\000\000\252\252\000\000UU\000\000\252\252\000\000UU\000\000"
 & "\252\252\000\000UU\000\000\252\252\000\000";

CONST E18 = 
   "P4\n16 16\n\000\000\000\000\007\300\017\360\0348\033\3307\3547\3547\354"
 & "7\354\033\330\0348\017\360\007\300\000\000\000\000";

CONST E19 = 
   "P4\n16 16\n\000\000\000\000\000\000\037\370\030\030\024(\022H\021\210\021"
 & "\210\022H\024(\030\030\037\370\000\000\000\000\000\000";

CONST E20 = 
   "P1\n# created by \'xv /tmp_mnt/bamboozle/r/dlusers6/bharat/foo.ppm\'\n1"
 & "95 85\n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 ";

CONST E20_0 = 
   "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 ";

CONST E20_1 = 
   "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 "
 & "1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 \n0 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 \n1 "
 & "1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n0"
 & " 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 \n"
 & "1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 \n"
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n"
 & "1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 \n"
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 \n"
 & "1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 \n"
 & "0 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 ";

CONST E20_2 = 
   "0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0"
 & " 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 0 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n0 0 0 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 0 0 0 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 0 0 0 0 0 1 0 0 0 1"
 & " 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 \n1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 0 0 0"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 \n0 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1"
 & " 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 \n0 0 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 0 \n0 0 1 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 0 0 0 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 \n1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 0 "
 & "0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 \n1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 "
 & "1 0 0 0 0 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 \n1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 0 0"
 & " 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 \n1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1"
 & " 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 1 0 0 \n0 1 0 "
 & "0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 ";

CONST E20_3 = 
   "1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 0 0 \n0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 0 0 0 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 \n0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 0 0 0 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0"
 & " 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 "
 & "0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 \n1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 \n1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 "
 & "0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 \n1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 "
 & "1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 \n0 0 0 1 1 1 1 1 1 1 1 0 0 0 "
 & "0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 0"
 & " 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 \n1 0 0 0 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 \n1 1 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 \n1 1 1 1 1 1 1 1 0 0 0 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 \n0 1 1 1 1 1 1 1 1 0 0"
 & " 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 \n0 1 1 1 1 1 1 1 1 1 "
 & "0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 \n0 0 1 1 1 1 1 1 1 1"
 & " 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 ";

CONST E20_4 = 
   "1 1 1 1 0 0 \n0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 0"
 & " 0 0 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 "
 & "1 1 0 0 1 1 1 \n1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1"
 & " 1 1 0 0 0 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 "
 & "1 1 1 0 0 0 0 1 \n1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 \n0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 "
 & "0 0 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 \n1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 0 0 0 1 1 1 1 1 1 \n1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 "
 & "1 1 1 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 0 0 \n0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 0 0 0 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 "
 & "0 0 0 0 1 1 1 1 1 1 1 1 1 \n0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 0 0 0 1 1 1 1 1 1 1 1 \n0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 0 0 0 0 1 1 1 0 0 0 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 "
 & "0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 \n1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 "
 & "1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1"
 & " 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 \n0 0 0 0 0 0 1 1 0 0 0 0 1 1 1 0 0 0"
 & " 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 \n1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 0 "
 & "0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 \n1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0"
 & " 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 \n1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 "
 & "0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 \n1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1"
 & " 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 "
 & "1 1 1 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 ";

CONST E20_5 = 
   "\n0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 0"
 & " \n0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 "
 & "1 \n1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0"
 & " 0 \n0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 "
 & "1 1 \n1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 1 1 \n1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 "
 & "0 0 0 \n1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1"
 & " 1 0 0 \n0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 "
 & "0 0 0 0 \n0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1"
 & " 1 1 1 0 \n0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 \n0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 "
 & "0 0 1 1 1 1 \n1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1"
 & " 0 0 0 0 1 1 \n1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1 1 "
 & "1 1 0 0 0 1 1 \n1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 1 1 1 1 1"
 & " 1 1 0 0 0 0 1 \n1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 \n0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 0 0 0 0 0 0 0 1 1 1 0 0"
 & " 0 1 1 1 1 1 1 1 \n1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 "
 & "1 1 0 0 0 0 0 0 0 \n1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1"
 & " 0 0 0 1 1 1 1 1 1 \n1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 "
 & "0 1 1 1 1 1 1 0 0 0 \n0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1"
 & " 1 1 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 "
 & "1 1 1 0 0 0 0 1 1 1 1 \n1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0"
 & " 0 1 1 1 1 1 1 1 1 0 0 \n0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 1 1 1 "
 & "0 0 0 1 1 1 1 1 1 1 1 0 \n0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0"
 & " 0 0 0 1 1 1 1 1 1 1 1 1 \n0 0 0 1 1 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 "
 & "1 1 0 0 0 1 1 1 1 1 1 1 1 \n0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 0 1 1 1 1 1 "
 & "1 0 0 0 0 0 1 1 1 0 0 0 1 1 \n1 1 1 1 1 1";

CONST E20_6 = 
   " 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 \n0 0 0 0 0 "
 & "1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 \n1 1 1 1 1"
 & " 1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 0 0 "
 & "0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 \n0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 \n1 1 1 "
 & "1 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 \n1 1 1"
 & " 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 \n1 1 "
 & "1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 \n1 1"
 & " 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 \n1 "
 & "1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 \n"
 & "0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 1 1 \n"
 & "1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 \n"
 & "1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 \n"
 & "1 1 1 0 0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 \n"
 & "1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 \n"
 & "1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 \n"
 & "1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 \n"
 & "0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 \n"
 & "0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 \n"
 & "0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 \n"
 & "0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 \n"
 & "0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 \n"
 & "1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 \n"
 & "1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 \n"
 & "1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 \n"
 & "1 0 0 0 0 1 1 1 1 1 1 1";

CONST E20_7 = 
   " 1 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 \n1 1 1 0 0 0 1 1 1 1 1 "
 & "1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 \n1 1 0 0 0 0 1 1 1 1 1"
 & " 1 1 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 \n0 1 1 1 0 0 0 1 1 1 "
 & "1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 \n1 1 1 0 0 0 0 1 1 "
 & "1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 \n0 1 1 1 0 0 0 0 1"
 & " 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 \n0 0 0 1 1 1 1 1 "
 & "1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 \n0 0 0 1 1 1 0 0"
 & " 0 0 0 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 \n0 0 0 0 1 1 1 "
 & "1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0"
 & " 0 1 1 1 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 \n1 1 1 1 1 1 "
 & "0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 1 1 1 \n0 0 0 0 0 1"
 & " 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 \n1 1 1 1 1 "
 & "1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 \n1 1 0 0 0"
 & " 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 \n0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 \n0 1 1 1"
 & " 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 \n1 1 1 "
 & "0 0 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 \n1 1 1"
 & " 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 \n1 1 "
 & "1 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 \n1 1"
 & " 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 1 1 1 \n0"
 & " 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 0 0 \n"
 & "1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 \n"
 & "1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 \n"
 & "1 1 1 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 \n"
 & "1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 \n"
 & "1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 \n"
 & "1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0";

CONST E20_8 = 
   " 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 \n0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 "
 & "1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 \n0 0 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0"
 & " 0 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 1 0 \n0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 "
 & "1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 "
 & "1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 \n1 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 \n1 1 1 1 1 1 0 0 0 1 1 1 1 1 "
 & "1 1 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 1 1 \n1 1 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 \n1 1 1 1 1 1 1 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 1 1 1 1 1 1 0 0 0 0"
 & " 0 0 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 \n1 0 0 0 0 1 1 1 1 1 1 1 "
 & "1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 1 0 0 0 0 \n1 1 1 0 0 0 1 1 1 1 1 1"
 & " 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 \n1 1 1 0 0 0 0 0 0 0 1 "
 & "1 1 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 \n0 1 1 1 0 0 0 1 1 1 1"
 & " 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 \n0 1 1 0 0 0 0 1 1 1"
 & " 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 \n0 1 1 1 1 1 1 1 0 "
 & "0 0 0 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 \n0 0 0 1 1 1 1 1 1"
 & " 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 \n0 0 0 1 1 1 1 1 "
 & "1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 \n0 0 0 0 1 1 1 1"
 & " 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 "
 & "0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 \n1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 0 0 0 0 1 "
 & "1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 \n1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 "
 & "1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 \n0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 \n1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 0"
 & " 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0";

CONST E20_9 = 
   " 0 1 1 1 0 0 0 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 0 0 0 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 \n0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 0 0 0 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 0 "
 & "1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 \n0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 \n0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 0 \n0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 "
 & "1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 0 0 0 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 \n1 1 1 0 0 0 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 0 0 0 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 "
 & "0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 \n0 1 1 1 1 1 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 1 1 1 1";

CONST E20_10 = 
   " 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 \n0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1"
 & " 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 0 0 0 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 "
 & "0 0 0 0 0 0 0 0 \n0 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 0 0 0 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 \n1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 0 0 0 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 0 0 0 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 \n0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 0 0 0 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 0 0 0 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 \n0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1"
 & " 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 \n0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 "
 & "1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 \n1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"
 & " 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 \n";

CONST E20_11 = 
   "1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 \n"
 & "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 \n"
 & "1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 ";

CONST E20_12 = 
   "0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 \n1 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 \n0 0 0 0 1"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 \n0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 "
 & "1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0"
 & " 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 \n1 1"
 & " 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 0 0 1 0 1 1 0 0 1 1 0 0 0 0 1 1 1 0 \n0 "
 & "0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 0 0 0 1 1 1 \n0"
 & " 0 0 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 0 0 0 \n"
 & "0 1 0 0 0 0 0 0 0 0 1 1 1 0 0 0 1 0 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 0 \n"
 & "0 1 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 0 \n"
 & "0 1 0 0 1 1 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 \n"
 & "0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 0 \n"
 & "0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 \n"
 & "0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 0 0 \n"
 & "0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 0 \n"
 & "1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 0 0 0 \n"
 & "0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 0 \n"
 & "0 0 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 \n"
 & "0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 0 1 0 0 0 1 1 1 0 0 0 0 1 0 0 \n"
 & "0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 0 0 1 \n"
 & "0 1 0 0 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 \n"
 & "1 0 0 0 0 0 1 0 0 0 0 0 ";

CONST E20_13 = 
   "0 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 1 \n1 1 1 1 0 0 1 0 0 0 1 0"
 & " 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 \n0 0 1 0 0 0 1 0 0 0 0"
 & " 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 \n0 0 1 0 0 0 0 0 0 1 "
 & "0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 \n0 0 0 1 0 0 1 0 0 0"
 & " 0 0 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 0 \n0 0 1 0 0 0 0 0 0 "
 & "0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 \n0 0 0 0 1 0 0 0 0"
 & " 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 \n0 0 1 0 0 0 0 1"
 & " 0 0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 0 0 0 \n0 0 0 0 1 0 0 "
 & "0 1 0 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 \n0 0 1 0 0 1 0"
 & " 0 0 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 \n0 1 0 0 1 0 "
 & "0 0 1 0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 0 0 1 0 0 0 \n0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n1 1 1 1 0 "
 & "0 0 0 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 0 0 0 1 \n0 0 0 1 0"
 & " 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 \n1 0 0 0 "
 & "0 1 1 1 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 0 0 1 0 0 0 0 0 0 1 1 1 \n0 0 0 1"
 & " 0 0 0 1 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 0 \n1 0 0 "
 & "0 0 1 1 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 \n0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n"
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 ";

CONST E20_14 = 
   "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 \n1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 ";

CONST E20_15 = 
   "0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 0"
 & " 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 \n0 0 0 0 0 0 0 0 0 0 0 0 "
 & "0 0 0 0 0 0 0 0 ";

CONST E21 = 
   "P4\n16 16\n\000\000\000\000\000\000\003\300\0140\013\320\027\350\027\350"
 & "\027\350\027\350\013\320\0140\003\300\000\000\000\000\000\000";


BEGIN
END VBTKitBundle.
