/* Copyright (C) 1994, Digital Equipment Corporation           */
/* All rights reserved.                                        */
/* See the file COPYRIGHT for a full description.              */
/***************************************************************/
/* File: trap.h                                                */
/* Last modified on Thu Jun  2 15:57:58 PDT 1994 by kalsow     */
/*      modified on Fri May  6 14:14:32 PDT 1994 by wobber     */
/*      modified on Fri May 17 13:04:05 1991 by hisgen         */
/*      modified on Mon Feb  2 09:14:54 1987 by roberts        */
/* ----------------------------------------------------------- */
/*     The trap package contains routines used to handle       */
/* dynamically-nested exceptions in C.  It is based loosely    */
/* on the setjmp(3) facility, but is much more powerful and    */
/* easier to use.  In addition, the trap package defines an    */
/* error routine, which is universally used to report errors   */
/* by the extended C library and most applications.            */
/*                                                             */
/*     Exceptions are named by character strings and all       */
/* exception nesting is performed by the package.  Thus,       */
/* there is no need to declare exception names or resolve      */
/* references at load time.                                    */
/*                                                             */
/*     Exceptions are entered by the pseudo-function           */
/* trap(name), which acts in much the same manner as setjmp    */
/* in the sense that the initial call to trap returns FALSE    */
/* and any generated exception conditions return TRUE.         */
/*                                                             */
/*     If trap is called within the same control scope as an   */
/* old exception, the old value is overwritten.  If the trap   */
/* call occurs at a lower level of nesting, the exception is   */
/* nested beneath the original, and the old exception will be  */
/* restored when the current trap is cleared by an untrap      */
/* call.                                                       */
/*                                                             */
/*     A exception is triggered by the raise function which    */
/* takes an exception name as argument.  An error occurs if    */
/* no exception is found with that name.  All exceptions       */
/* beneath this level of control are untrapped by a raise,     */
/* but all those declared within this scope remain active.     */
/*                                                             */
/*     The untrap pseudo-function removes all exceptions       */
/* at or below this control level and should be called when    */
/* any routine that uses trap exits normally.                  */
/*                                                             */
/*     The error routine is used for error reporting througout */
/* the library packages and in most applications.  To the      */
/* user, error looks like printf and, barring any use of the   */
/* trap routine, simply prints a message to stderr of the form */
/*                                                             */
/*                 Error: <error-message>\n                    */
/*                                                             */
/* where <error-message> is composed of the string msg after   */
/* substitution of any % parameters in the standard printf     */
/* style, plus the special %M specification for the text of    */
/* the system error specified in errno.  After printing the    */
/* message, error ordinarily calls exit with status 1.         */
/*                                                             */
/*     If an error trap has been set by calling                */
/*                                                             */
/*                 trap("error")                               */
/*                                                             */
/* the message is copied into the global errmsg buffer and     */
/* a raise("error") is simulated.                              */
/***************************************************************/



#ifndef _trap_h
#define _trap_h

#define trap(name) (_trap(name, setjmp(_trapbuf)))
#define untrap() (_untrap(setjmp(_trapbuf)))

/***************************************************************/
/* Global variables                                            */
/***************************************************************/

extern string errmsg;
extern int *_trapbuf;

/***************************************************************/
/* Global routines                                             */
/***************************************************************/

int _trap(/* name, sjflag */);
void _untrap(/* sjflag */);
void raise(/* name */);

void error(/* msg, ... */);

#endif
