(* Copyright (C) 1993, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)
(*                                                             *)
(* Last modified on Wed Aug 24 16:10:57 PDT 1994 by isard      *)
(*      modified on Fri Nov 19 09:30:31 PST 1993 by kalsow     *)
(*      modified on Mon Apr 13 09:55:12 PDT 1992 by muller     *)

INTERFACE ObjFilex86;

IMPORT M3CG, M3x86, Wrx86;

FROM M3CG IMPORT Name, ByteSize, Alignment, Type, TypeUID, ByteOffset;

FROM M3x86 IMPORT x86Var, x86Proc, VLoc;

TYPE T <: Public;
TYPE Public = OBJECT
      METHODS
        put(seg: Segment; val, size: INTEGER);
        ranput(seg: Segment; offset, val, size: INTEGER);
        get(seg: Segment; offset, size: INTEGER): INTEGER;
        cursor(seg: Segment): INTEGER;
        reloc(src, dest: ReLoc);
        import_global(n: Name; s: ByteSize; a: Alignment; t: Type;
                      m3t: TypeUID): ByteOffset;
        declare_segment(n: Name; m3t: TypeUID): ByteOffset;
        bind_segment(o: ByteOffset; s: ByteSize; a: Alignment; t: Type;
                     exported, inited: BOOLEAN);
        declare_global(n: Name; s: ByteSize; a: Alignment; t: Type;
                       m3t: TypeUID; exported, inited: BOOLEAN): ByteOffset;
        declare_param(v: x86Var; n: Name;  s: ByteSize; a: Alignment; t: Type;
                      m3t: TypeUID): INTEGER;
        import_procedure(n: Name; n_params: INTEGER; type: Type; lang: TEXT):
                        ByteOffset;
        declare_procedure(n: Name; n_params: INTEGER; type: Type;
                          exported: BOOLEAN; lev: INTEGER; proc: x86Proc);
        begin_init(v: x86Var);
        end_init(v: x86Var);
        init_int(o: ByteOffset; i, size: INTEGER);
        init_relocaddr(o: ByteOffset; loc: VLoc; valoff, bias: ByteOffset);
        init_chars(o: ByteOffset; txt: TEXT);
      END;

TYPE Segment = {text, data, global};

TYPE ReLoc = RECORD
  seg: Segment;
  sym, o: INTEGER;
END;

PROCEDURE New(wr: Wrx86.T): T;

END ObjFilex86.
