(* Copyright (C) 1993, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)
(*                                                             *)
(* Last modified on Mon Aug  8 13:16:19 PDT 1994 by isard      *)
(*      modified on Fri Nov 19 09:30:31 PST 1993 by kalsow     *)
(*      modified on Mon Apr 13 09:55:12 PDT 1992 by muller     *)

INTERFACE Regx86;

IMPORT Codex86, Stackx86;

FROM M3CG_Ops IMPORT ErrorHandler;

FROM M3x86 IMPORT MVar, Force, RegSet, Regno;

TYPE T <: Public;
TYPE Public = OBJECT
      METHODS
        unlock ();
        clearall ();
        rdiscard (depth: INTEGER);
        find (stackp: INTEGER; force: Force; set := RegSet {});
        freereg (set := RegSet {}): Regno;
        set_error_handler (err: ErrorHandler);
        init ();
        end ();
      END;

TYPE
  Register = RECORD
    stackp: INTEGER := -1;
    last_store: MVar;
    locked := FALSE;
  END;

PROCEDURE New (cg: Codex86.T; vst: Stackx86.T): T;

END Regx86.
