(* Copyright (C) 1994, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)
(*                                                             *)
(* Last modified on Tue Dec 13 16:32:14 PST 1994 by kalsow     *)

INTERFACE Buf;

TYPE
  T = REF ARRAY OF CHAR;

PROCEDURE FromFile (path: TEXT): T;
(* Read and return the entire contents of the file named by "path".
   If an error occurs, "NIL" is returned. *)

PROCEDURE FromText (txt: TEXT): T;
(* Return the contents of 'txt' as a buffer *)

END Buf.

