(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: OS.m3                                                 *)
(* Last modified on Thu Dec  8 08:44:58 PST 1994 by kalsow     *)
(*      modified on Tue Mar 24 16:04:38 PST 1992 by muller     *)

UNSAFE MODULE OS;

IMPORT M3toC, Time;
IMPORT Unix, Ustat;

PROCEDURE CreateTime (file: TEXT): Time.T =
  VAR s: Ustat.struct_stat;
  BEGIN
    IF Ustat.stat (M3toC.TtoS (file), ADR (s)) = 0
      THEN RETURN FLOAT (s.st_mtime, LONGREAL);
      ELSE RETURN NO_TIME;
    END;
  END CreateTime;

PROCEDURE GetHostName (): TEXT =
  VAR nm: ARRAY [0..255] OF CHAR;
  BEGIN
    IF Unix.gethostname (ADR (nm[0]), BYTESIZE (nm)) = 0
      THEN RETURN M3toC.CopyStoT (ADR (nm[0]));
      ELSE RETURN NIL;
    END;
  END GetHostName;

BEGIN
END OS.

