(* Copyright (C) 1994, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)
(*                                                             *)
(* File: M3File.m3                                             *)
(* Last modified on Wed Aug  3 13:57:17 PDT 1994 by kalsow     *)

UNSAFE MODULE M3File;

IMPORT File, OSError;

TYPE
  BufPtr = UNTRACED REF ARRAY BufferLength OF File.Byte;

PROCEDURE Read (f: File.T; VAR(*OUT*)buf: Buffer; len: BufferLength): INTEGER
  RAISES {OSError.E} =
  VAR ptr := LOOPHOLE (ADR (buf[0]), BufPtr);
  BEGIN
    RETURN f.read (SUBARRAY (ptr^, 0, MIN (len, NUMBER (buf))),
                   mayBlock := TRUE);
  END Read;

BEGIN
END M3File.

