(* Copyright (C) 1990, Digital Equipment Corporation.             *)
(* All rights reserved.                                           *)
(* See the file COPYRIGHT for a full description.                 *)


(* Last modified on Mon Jan 30 14:56:05 PST 1995 by kalsow                 *)
(*      modified on Tue Jun 23 10:42:31 PDT 1992 by schilit@xerox.com      *)
(*      modified on Thu Jul 25 20:16:14 PDT 1991 by stolfi                 *)
(*      modified on Mon Apr 22 17:42:17 1991 by nichols@xerox.com          *)
(*      modified on Tue Apr 10 23:47:30 1990 by muller                     *)


UNSAFE MODULE Parse;

IMPORT NewFormatter AS Formatter;
IMPORT Ctypes, FBE, M3toC;

(* Do various setups, then call C init routine. *)
PROCEDURE Init (         inputFile      : TEXT;
                         output         : Formatter.T;
                READONLY info           : Options;
                         calledFromEmacs: BOOLEAN      ) RAISES {FBE.Failed} =
  VAR
    bf, kf, bif, pf, cf, fcf, ff: FBE.Font;
    infile                      : Ctypes.char_star := NIL;
    fbe: FBE.T := Formatter.UnderlyingFBE(output);
  BEGIN
    bf := fbe.GetFont(info.bodyFont);
    kf := fbe.GetFont(info.keywordFont);
    bif := fbe.GetFont(info.builtinIDFont);
    pf := fbe.GetFont(info.procNameFont);
    cf := fbe.GetFont(info.commentFont);
    fcf := fbe.GetFont(info.fixedCommentFont);
    ff := fbe.GetFont(info.fixedFont);
    IF inputFile # NIL THEN infile := M3toC.TtoS(inputFile); END;
    initParser(
      infile      := infile,
      output      := output,
      emacs       := ORD (calledFromEmacs),
      lowerCase   := ORD (info.lowerCase),
      bf := bf, kf := kf, bif := bif, pf := pf,
      cf := cf, fcf := fcf, ff := ff,
      offset      := FLOAT (info.offset * fbe.CharWidth(' ', bf), LONGREAL),
      commentColumn := FLOAT (info.commentColumn * fbe.CharWidth(' ', bf), LONGREAL),
      style       := ORD (info.style),
      alignDecls  := ORD (info.alignDecls),
      breakType   := ORD (info.breakType),
      follow (* comBreakNLs *) := ORD(info.follow),
      callSpace   := ORD (info.callSpace),
      charWidth   := CharWidth,
      flush       := Formatter.Flush,
      setFont     := Formatter.SetFont,
      putChar     := Formatter.PutChar,
      break       := Break,
      newLine     := NewLine,
      unitedBreak := UnitedBreak,
      group       := Formatter.Group,
      begin       := Begin,
      align       := Align,
      noAlign     := Formatter.NoAlign,
      col         := Col,
      end         := Formatter.End
    );
  END Init;

(*------------------------------------------------------------ C wrappers ---*)
(* This code is a bit kludgy.  Since C insists on promoting floats to
   doubles, we must provide some conversion wrappers. *)

(* Called from the C code. *)
PROCEDURE CharWidth(f: Formatter.T; font: FBE.Font; c: CHAR): LONGREAL =
  VAR fbe := Formatter.UnderlyingFBE(f);
  BEGIN
    RETURN FLOAT (fbe.CharWidth(c, font), LONGREAL);
  END CharWidth;

PROCEDURE Break (t: Formatter.T;
                 offset: LONGREAL;
                 type := Formatter.BreakType.OptimalBreak;
                 freshLine: INTEGER) RAISES {FBE.Failed} =
  BEGIN
    Formatter.Break (t, FLOAT (offset, REAL), type, freshLine # 0);
  END Break;

PROCEDURE NewLine (t: Formatter.T;
                   offset: LONGREAL;
                   freshLine: INTEGER) RAISES {FBE.Failed} =
  BEGIN
    Formatter.NewLine (t, FLOAT (offset, REAL), freshLine # 0);
  END NewLine;

PROCEDURE UnitedBreak (t: Formatter.T;
                       offset: LONGREAL;
                       freshLine: INTEGER) RAISES {FBE.Failed} =
  BEGIN
    Formatter.UnitedBreak (t, FLOAT (offset, REAL), freshLine # 0);
  END UnitedBreak;

PROCEDURE Begin (t: Formatter.T;
                 offset: LONGREAL;
                 width: LONGREAL) RAISES {FBE.Failed} =
  BEGIN
    Formatter.Begin (t, FLOAT (offset, REAL), FLOAT (width, REAL));
  END Begin;

PROCEDURE Align (t:          Formatter.T;
                 columns:    CARDINAL;
                 tryOneLine: INTEGER;
                 tryAlign:   INTEGER) RAISES {FBE.Failed} =
  BEGIN
    IF (tryAlign # 0)
      THEN Formatter.Align (t, columns, tryOneLine # 0, 0.0, NIL);
      ELSE Formatter.Align (t, columns, tryOneLine # 0, 0.0, falsePred);
    END;
  END Align;

VAR falsePred := NEW(Formatter.AlignPred, pred := FalseProc);

PROCEDURE FalseProc (
    <*UNUSED*> arg: REFANY;
    <*UNUSED*> column: CARDINAL;
    <*UNUSED*> maxWidth: REAL;
    <*UNUSED*> width: REAL
  ): BOOLEAN =
  BEGIN
    RETURN FALSE;
  END FalseProc;

PROCEDURE Col (t: Formatter.T;
               column: LONGREAL;
               relative: INTEGER;
               space: LONGREAL) RAISES {FBE.Failed} =
  BEGIN
    Formatter.Col (t, FLOAT (column, REAL), relative # 0, FLOAT (space, REAL));
  END Col;


BEGIN
END Parse.
