(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* by Steve Glassman, Mark Manasse and Greg Nelson *)
(* Last modified on Tue Jan 31 09:31:13 PST 1995 by kalsow *)
(*      modified on Fri Apr 16 15:28:16 PDT 1993 by steveg *)
(*      modified on Wed Oct 21 16:46:17 PDT 1992 by msm *)
(* modified on Mon Feb 24 13:59:46 PST 1992 by muller *)

UNSAFE MODULE NT;

IMPORT Rect, WinBase, WinDef;

<* INLINE *>
PROCEDURE ToRect (READONLY rc: WinDef.RECT): Rect.T =
  BEGIN
    RETURN Rect.T{west := rc.left, east := rc.right, north := rc.top,
                  south := rc.bottom}
  END ToRect;

<* INLINE *>
PROCEDURE FromRect (READONLY r: Rect.T): WinDef.RECT =
  BEGIN
    RETURN WinDef.RECT{left := r.west, right := r.east, top := r.north,
                  bottom := r.south}
  END FromRect;

PROCEDURE True (b: WinDef.BOOL): BOOLEAN =
  BEGIN
    RETURN b # 0;
  END True;

PROCEDURE Assert(res: INTEGER) =
  VAR error: INTEGER;
  BEGIN
    IF 0 = res THEN 
      error := WinBase.GetLastError();
      Crash();
    END;
  END Assert;

PROCEDURE BAssert(b: BOOLEAN) =
  BEGIN Assert(ORD(b)) END BAssert;

EXCEPTION Fatal;

PROCEDURE Crash() =
  <* FATAL Fatal *>
  BEGIN
    RAISE Fatal;
  END Crash;

BEGIN
  CNULL := LOOPHOLE(0, ADDRESS);
END NT.

