(* Copyright C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* by Steve Glassman, Mark Manasse and Greg Nelson *)
(* Last modified on Thu Apr 22 17:18:28 PDT 1993 by steveg *)
(*      modified on Tue Feb 23 17:34:43 PST 1993 by msm *)
(* modified on Mon Feb 24 13:59:43 PST 1992 by muller *)
(* modified on Sat Jan 11 19:03:47 PST 1992 by gnelson*)


<*PRAGMA LL*>

(* Partitioning following the efforts of
   Steve.Freeman@computer-lab.cambridge.ac.uk - 92-05-13 *)

UNSAFE INTERFACE NTClientF;

IMPORT Ctypes, IntRefTbl, NTClient, NTScreenType, Point, ProperSplit, 
       Region, TrestleOnNT, Trestle, TrestleClass, TrestleComm, VBT, WinDef;

REVEAL
  TrestleClass.RootVBT <: ProperSplit.T;
  TrestleOnNT.Display <: T_Abs;

TYPE
  T_Abs <: T_Rel;
  T_Rel =
    NTClient.T_Public OBJECT
      (* protection = self *)
      dead (*, hasMessenger, hasSelectThread *) := FALSE;
      vbts : IntRefTbl.T;
      sel: SelArray           := NIL;
      (*params: Trestle.Parameters;*)
      screens: REF ARRAY OF NTScreenType.T;
      (* Types of the screens on the NT server. *)
      defaultScreen: CARDINAL;
      (* index in screens of default screen for this NT server. *)

      (* The next fields are protected by VBT.mu and self *)
      current, mouseFocus: VBT.T := NIL;
      (* The child that has received a FirstDown but no corresponding
         LastUp, or NIL if there is no such child. *)
      otherCages: BOOLEAN := FALSE;
     
      (* protection = scheduler *)
      inst: TEXT;
    END;

TYPE
  Child = ProperSplit.Child OBJECT
            (* fields below protected by parent lock *)
            hwnd   : WinDef.HWND;
            conn   : NTClient.T;
            nwValid                := FALSE;
            nw     : Point.T;
            (* The nw field is the location of the northwest corner of the
               window on the root window, if nwValid is TRUE.*)
            inside := FALSE;
            (* whether the cursor is inside the window. *)
            isNTFocus, underNTFocus := FALSE;
            (* The boolean isNTFocus is true if this window has the X
               keyboard focus, and underNTFocus is true if the XNTkeyboard
               focus is an ancestor of this window. *)
            owns           : OwnsArray := NIL;
            recentlyOutside            := TRUE;
            (* true if the cursor has been outside our window since the
               last time a takefocus message was sent *)
            width, height: CARDINAL;
            (* width and height of NT window. *)
            oldWidth, oldHeight                        := LAST(INTEGER);
            serial             : Ctypes.UnsignedLong;
            userPosition                               := FALSE;
            (* indicates whether the position to be set was generated by a
               user-specification in global coordinates *)
            (* everywhereCage = TRUE, => ignore all mouse motion events *)
            everywhereCage: BOOLEAN    := TRUE;
            cage          : VBT.Cage;
            badR                       := Region.Empty;
            (* The actual bad region of a Child ur is ur.badR union
               bad(ur.ch). *)
            sh, sv: VBT.SizeRange;
            (* The last hor and ver sizeranges that were reported to NT. *)
            csid: WinDef.HCURSOR;
            (* The last cursor that was reported to NT. *)
            cageCovered := FALSE;
            (* TRUE during delivery of a button click, to avoid setting the
               cage twice. *)
          END;

TYPE
  SelectionRecord = RECORD
                      v   : VBT.T         := NIL;
                      ts  : VBT.TimeStamp := 0;
                    END;

  SelArray = REF ARRAY OF SelectionRecord;

  OwnsArray = REF ARRAY OF BOOLEAN;

TYPE
  NewScreenProp = REF RECORD
                        len, format: INTEGER;
                        data       : REF ARRAY OF Ctypes.char
                      END;

PROCEDURE Kill (trsl: NTClient.T);
<* LL.sup = trsl *>
(* clean way to close a Trestle *)

(* ---------- various utilities ---------- *)
PROCEDURE ValidateNW (trsl: NTClient.T; ch: Child; st: NTScreenType.T)
  RAISES {TrestleComm.Failure};

PROCEDURE SetTitle(trsl: NTClient.T; v: VBT.T; ch: Child) RAISES {TrestleComm.Failure};
<* LL = trsl *>

PROCEDURE SetDecoration (trsl    : NTClient.T;
                         v       : VBT.T;
                         ch      : Child;
                         hwnd    : WinDef.HWND;
                         old, new: TrestleClass.Decoration)
  RAISES {TrestleComm.Failure};

PROCEDURE GetDomain (ur: Child; VAR (* OUT*) width, height: CARDINAL);
(* Return the domain of ur's NT window, or 0,0 when the window is unmapped,
   and clear ur.reshapeComing.  LL = ur.ch.parent *)

PROCEDURE AdjustCoverage (xcon: NTClient.T; d: [-1 .. 1] := 0)
  RAISES {TrestleComm.Failure};
(* see TrestleOnNT.Enter() *)

PROCEDURE Delete (trsl: NTClient.T; ch: VBT.T; ur: Child);

PROCEDURE Reshape (ch: VBT.T; width, height: CARDINAL; sendMoved := FALSE);
(* Reshape ch to new width and height.  LL = VBT.mu *)

PROCEDURE Connect (inst: TEXT; t: NTClient.T := NIL): Trestle.T
  RAISES {TrestleComm.Failure};
(* If t is NIL, allocate a new T and return it.  In any case, connect
   t to the X server named inst. *)

(* ---------- connection management ---------- *)
PROCEDURE DoConnect (             self     : TrestleClass.ConnectClosure;
                                  inst     : TEXT;
                                  localOnly: BOOLEAN;
                     VAR (* OUT*) t        : Trestle.T                    ):
  BOOLEAN;
(* Apply procedure for TrestleClass.ConnectClosure.  Establishes connection
   with NT server *)

END NTClientF.
