(* Copyright (C) 1993, Digital Equipment Corporation       *)
(* All rights reserved.                                    *)
(* See the file COPYRIGHT for a full description.          *)
(*                                                         *)
(* Last modified on Thu Nov 11 10:48:16 PST 1993 by kalsow *)
(*      modified on Tue Apr 13 15:07:22 PDT 1993 by steveg *)

MODULE NTDebug;

(* Writes messages to a visible console log *)

IMPORT FileWin32, FileWr, Fmt, OSError, Point, Rect, Thread, WinBase, WinCon, Wr;

<* FATAL OSError.E, Wr.Failure, Thread.Alerted *>

PROCEDURE NewLine() =
  BEGIN
   Wr.PutText(con, "\r\n");
    Wr.Flush(con);
  END NewLine;

PROCEDURE PText (msg: TEXT; data: TEXT := "") =
  BEGIN
    Wr.PutText(con, Fmt.F("%s%s", msg, data));
    Wr.Flush(con);
  END PText;

PROCEDURE PBool (msg: TEXT; b: BOOLEAN)  =
  VAR data: TEXT;
  BEGIN
    IF b THEN
      data := "TRUE"
    ELSE
      data := "FALSE"
    END;
    Wr.PutText(con, Fmt.F("%s %s", msg, data));
    Wr.Flush(con);
  END PBool;

PROCEDURE PInt (msg: TEXT; int: INTEGER)  =
  VAR data := Fmt.Int(int);
  BEGIN
    Wr.PutText(con, Fmt.F("%s %s", msg, data));
    Wr.Flush(con);
  END PInt;

PROCEDURE PPoint (msg: TEXT; READONLY pt: Point.T)  =
  VAR data := Fmt.F("%s (%s, %s) ", msg, Fmt.Int(pt.h), Fmt.Int(pt.v));
  BEGIN
    Wr.PutText(con, data);
    Wr.Flush(con);
  END PPoint;

PROCEDURE PRect (msg: TEXT; READONLY r: Rect.T) =
  VAR
    data := Fmt.F("%s (%s, %s, %s, %s) ", msg, Fmt.Int(r.west), Fmt.Int(r.east),
                  Fmt.Int(r.north), Fmt.Int(r.south));
  BEGIN
    Wr.PutText(con, data);
    Wr.Flush(con);
  END PRect;

VAR
  con: FileWr.T;

BEGIN
  EVAL WinCon.AllocConsole();
    con := NEW(FileWr.T).init(FileWin32.New(
                               WinBase.GetStdHandle(WinBase.STD_OUTPUT_HANDLE),
                               FileWin32.Write));
END NTDebug.

