(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* by Steve Glassman, Mark Manasse and Greg Nelson *)
(* Last modified on Thu Apr 22 16:35:20 PDT 1993 by steveg *)
(*      modified on Wed Oct 21 16:46:17 PDT 1992 by msm *)
(* modified on Mon Feb 24 13:59:46 PST 1992 by muller *)

<* PRAGMA LL *>

UNSAFE INTERFACE NTMsgs;

IMPORT NTClient, NTScreenType, TrestleComm, VBT, WinDef, WinUser;

PROCEDURE CreateNTWindow (conn: NTClient.T;
                          ch  : VBT.T;
                          st  : NTScreenType.T;
                          x, y: INTEGER          := WinUser.CW_USEDEFAULT;
                          iconic: BOOLEAN := FALSE) RAISES {TrestleComm.Failure};
<* LL <= VBT.mu *>
(* Schedules the creation of an NT window on "conn" for "ch" with screentype "st". 
   "x" and "y" are the horizontal and vertical position of the 
   NW corner of "ch".  If "iconic" then the window is created iconic.

   CreateNTWindow forks off a thread to handle NT messages for the window.
   The thread terminates when the window is deleted.
 *)

PROCEDURE Init(); <* LL = {} *>
(* Creates and registers the NT window class for Trestle VBT's *)

PROCEDURE NullWindow(trsl: NTClient.T): WinDef.HWND; <* LL = trsl *>
(* An invisible window for times when an HWND is needed *)

PROCEDURE DefaultAllMessages(); <* LL = undefined *>
(* Escape hatch for applications which get unexpected messages from NT.  Call
   DefaultAllMessages to send all unexpected messages to the DefWindowProc *)

END NTMsgs.
