(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* by Steve Glassman, Mark Manasse and Greg Nelson *)
(* Last modified on Tue Apr 20 13:21:55 PDT 1993 by steveg *)
(*      modified on Fri Nov  6 16:58:29 PST 1992 by msm *)
(* modified on Mon Feb 24 13:59:50 PST 1992 by muller *)
(* modified on Wed Nov 20 18:49:31 PST 1991 by gnelson *)

<*PRAGMA LL*>

UNSAFE INTERFACE NTScreenType;

IMPORT NTClient, Rect, VBT, WinDef;

PROCEDURE New (trsl: NTClient.T; i: INTEGER): T;
(* Create a screentype for the ith screen, which is the NT connection
   underlying trsl.  LL <= VBT.mu. *)

TYPE
  T <: Public;
  Public =
    VBT.ScreenType OBJECT
      trsl: NTClient.T;
      (* Remaining fields protected by the .trsl field. *)
      rootDom: Rect.T;
      screenID: INTEGER := 0;
      nullCursor: WinDef.HCURSOR; (* for peekaboo mode, set on cage *)
    END;

END NTScreenType.
