(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* by Steve Glassman, Mark Manasse and Greg Nelson *)
(* Last modified on Thu Apr 22 10:18:59 PDT 1993 by steveg *)
(*      modified on Fri Nov  6 18:03:00 PST 1992 by msm    *)
(*      modified on Mon Feb 24 13:59:53 PST 1992 by muller *)
<*PRAGMA LL*>

UNSAFE MODULE NTScrnCmap;

IMPORT NT, NTMsgs, NTScreenType, NTScrnTpRep, ScrnColorMap, TrestleComm,
       TrestleOnNT, WinDef, WinGDI, WinUser;

TYPE
  ColorMapOracle =
    ScrnColorMap.Oracle OBJECT
      st       : NTScreenType.T;
      defaultCM: NTColorMap;
    METHODS
      <* LL.sup = SELF.st.trsl *>
      init (st: NTScreenType.T):
            ColorMapOracle RAISES {TrestleComm.Failure} := InitColorMapOracle;
    OVERRIDES
      standard := ColorMapDefault;
      new      := ColorMapNew;
      list     := ColorMapList;
      lookup   := ColorMapLookup
    END;

PROCEDURE NewOracle (scrn: NTScreenType.T):
  ScrnColorMap.Oracle RAISES {TrestleComm.Failure} =
  BEGIN
    RETURN NEW(ColorMapOracle).init(scrn)
  END NewOracle;

TYPE
  Prim = ScrnColorMap.Primary;
  NTColorMap = ScrnColorMap.T OBJECT
                st    : NTScreenType.T;
                direct: BOOLEAN;
                hpal   : WinDef.HPALETTE;
              OVERRIDES
                fromRGB := ColorMapFromRGB;
                new     := ColorMapCube;
                read    := ColorMapRead;
                write   := ColorMapWrite;
                free    := ColorMapFreeCube;
              END;
(* For all v: VBT.T, all cm: NTColorMap, cm < v *)

PROCEDURE ColorMapID (cm: ScrnColorMap.T): WinDef.HPALETTE =
  BEGIN
    TYPECASE cm OF
      NULL => RETURN NT.CNULL
    | NTColorMap (cm) => RETURN cm.hpal
    ELSE
      RETURN NT.CNULL
    END
  END ColorMapID;

PROCEDURE ColorMapFromRGB (cm  : NTColorMap;
                           rgb : ScrnColorMap.RGB;
                           mode: ScrnColorMap.Mode ): ScrnColorMap.Pixel
  RAISES {ScrnColorMap.Failure, TrestleComm.Failure} =
  BEGIN 
    NT.Assert(0); (* NYI *)
 END ColorMapFromRGB;

PROCEDURE ColorMapRead (cm: NTColorMap; VAR res: ARRAY OF ScrnColorMap.Entry)
  RAISES {TrestleComm.Failure} =
  BEGIN
    NT.Assert(0); (* NYI *)
  END ColorMapRead;

PROCEDURE ColorMapWrite (         cm : NTColorMap;
                         READONLY new: ARRAY OF ScrnColorMap.Entry)
  RAISES {ScrnColorMap.Failure, TrestleComm.Failure} =
  BEGIN
    NT.Assert(0); (* NYI *)
  END ColorMapWrite;

PROCEDURE ColorMapCube (cm: NTColorMap; d: CARDINAL): ScrnColorMap.Cube
  RAISES {ScrnColorMap.Failure, TrestleComm.Failure} =
  BEGIN
    NT.Assert(0); (* NYI *)
  END ColorMapCube;

PROCEDURE ColorMapFreeCube (cm: NTColorMap; READONLY cb: ScrnColorMap.Cube)
  RAISES {TrestleComm.Failure} =
  BEGIN
    NT.Assert(0); (* NYI *)
  END ColorMapFreeCube;

TYPE Card16 = BITS 16 FOR [0 .. 16_ffff];

PROCEDURE InitColorMapOracle (orc: ColorMapOracle; st: NTScreenType.T):
  ColorMapOracle RAISES {TrestleComm.Failure}
  <* LL.sup = st.trsl *> =
  VAR
    hpal := WinGDI.GetCurrentObject(
              WinUser.GetDC(NTMsgs.NullWindow(st.trsl)), WinGDI.OBJ_PAL);
  BEGIN
    orc.st := st;
    orc.defaultCM := InnerColorMapNew(orc, hpal, TRUE (* ??? *));
    RETURN orc
  END InitColorMapOracle;

PROCEDURE ColorMapDefault (orc: ColorMapOracle): ScrnColorMap.T RAISES {} =
  BEGIN
    RETURN orc.defaultCM
  END ColorMapDefault;

PROCEDURE ColorMapList (<*UNUSED*> orc       : ColorMapOracle;
                        <*UNUSED*> pat       : TEXT;
                        <*UNUSED*> maxResults: CARDINAL        ):
  REF ARRAY OF TEXT RAISES {} =
  BEGIN
    RETURN NIL
  END ColorMapList;

PROCEDURE ColorMapLookup (<*UNUSED*> orc: ColorMapOracle;
                          <*UNUSED*> pat: TEXT            ): ScrnColorMap.T
  RAISES {} =
  BEGIN
    RETURN NIL
  END ColorMapLookup;

PROCEDURE ColorMapNew (           orc      : ColorMapOracle;
                                  nm       : TEXT             := NIL;
                       <*UNUSED*> preLoaded                   := TRUE ):
  ScrnColorMap.T RAISES {TrestleComm.Failure} =
  VAR
    res : ScrnColorMap.T;
  BEGIN
    IF orc.defaultCM.readOnly THEN RETURN orc.defaultCM END;
    TrestleOnNT.Enter(orc.st.trsl);
    TRY
      NT.Assert(0); (* NYI *)
      RETURN res
    FINALLY
      TrestleOnNT.Exit(orc.st.trsl)
    END
  END ColorMapNew;

PROCEDURE InnerColorMapNew (orc     : ColorMapOracle;
                            hpal    : WinDef.HPALETTE;
                            readOnly: BOOLEAN          ): NTColorMap =
  BEGIN
    RETURN
      NEW(NTColorMap, st := orc.st, hpal := hpal, readOnly := readOnly)
  END InnerColorMapNew;

BEGIN
END NTScrnCmap.

