(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* by Steve Glassman, Mark Manasse and Greg Nelson *)
(* Last modified on Thu Apr 22 10:19:16 PDT 1993 by steveg *)
(*      modified on Fri Nov  6 19:55:56 PST 1992 by msm    *)
(*      modified on Mon Feb 24 13:59:53 PST 1992 by muller *)
<*PRAGMA LL*>

UNSAFE MODULE NTScrnCrsr;

IMPORT Cursor, NT, NTScreenType, ScrnCursor, ScreenType, TrestleComm,
       TrestleOnNT, WinDef, WinNT, WinUser;

REVEAL T = T_Pub BRANDED OBJECT  END;

TYPE
  CursorOracle = ScrnCursor.Oracle OBJECT
                   st: NTScreenType.T;
                 OVERRIDES
                   load    := CursorRegister;
                   list    := CursorList;
                   lookup  := CursorLookup;
                   builtIn := CursorBuiltIn
                 END;

  NTCursor = ScrnCursor.T OBJECT
            OVERRIDES
              unload   := CursorUnregister;
              localize := CursorLocalize
            END;

PROCEDURE NewOracle (scrn: NTScreenType.T): ScrnCursor.Oracle
  RAISES {TrestleComm.Failure} =
  BEGIN
    RETURN NEW(CursorOracle, st := scrn)
  END NewOracle;

PROCEDURE NullCursor (): WinDef.HCURSOR
  RAISES {TrestleComm.Failure} <* LL.sup = trsl, such that trsl.dpy = dpy *> =
  BEGIN
    RETURN WinUser.LoadCursor(
             NT.CNULL, LOOPHOLE(WinUser.IDC_ARROW, WinNT.LPCTSTR));
  END NullCursor;

PROCEDURE CursorRegister (                    orc: CursorOracle;
                                     READONLY c  : ScrnCursor.Raw;
                          <*UNUSED*>          nm : TEXT             := NIL):
  ScrnCursor.T RAISES {TrestleComm.Failure} =
  BEGIN 
    NT.Assert(0); (* NYI *)
 END CursorRegister;

PROCEDURE CursorList (<*UNUSED*> orc       : CursorOracle;
                      <*UNUSED*> pat       : TEXT;
                      <*UNUSED*> maxResults: CARDINAL       := 1):
  REF ARRAY OF TEXT RAISES {TrestleComm.Failure} =
  BEGIN
    RETURN NIL
  END CursorList;

PROCEDURE CursorLookup (orc: CursorOracle; name: TEXT): ScrnCursor.T
  RAISES {TrestleComm.Failure} =
  BEGIN
    NT.Assert(0); (* NYI *)
    RETURN NIL
  END CursorLookup;

PROCEDURE CursorBuiltIn (orc: CursorOracle; cs: Cursor.Predefined):
  ScrnCursor.T =
  VAR hc: WinDef.HCURSOR;
      trsl := orc.st.trsl;
  BEGIN
    TRY
      TrestleOnNT.Enter(trsl);
      TRY
        CASE cs OF
          Cursor.DontCare.cs => RETURN ScrnCursor.DontCare
        | Cursor.TextPointer.cs =>
            hc := WinUser.LoadCursor(NT.CNULL, WinUser.IDC_IBEAM);
        | Cursor.NotReady.cs =>
            hc := WinUser.LoadCursor(NT.CNULL, WinUser.IDC_WAIT);
        ELSE
          hc := NT.CNULL;
        END
      FINALLY
        TrestleOnNT.Exit(trsl)
      END
    EXCEPT
      TrestleComm.Failure => RETURN ScrnCursor.DontCare
    END;
    RETURN NEW(NTCursor, id := LOOPHOLE(hc, INTEGER))
  END CursorBuiltIn;

PROCEDURE CursorLocalize (<*UNUSED*> cs: NTCursor): ScrnCursor.Raw
  RAISES {TrestleComm.Failure, ScrnCursor.Failure} =
  BEGIN
    RAISE ScrnCursor.Failure
  END CursorLocalize;

PROCEDURE CursorUnregister (<*UNUSED*> cs: NTCursor)
  RAISES {TrestleComm.Failure} =
  BEGIN
  END CursorUnregister;

BEGIN
END NTScrnCrsr.

