(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* by Steve Glassman, Mark Manasse and Greg Nelson *)
(* Last modified on Tue Apr 13 15:53:21 PDT 1993 by steveg *)
(*      modified on Fri Nov  6 17:50:55 PST 1992 by msm    *)
(*      modified on Mon Feb 24 13:59:53 PST 1992 by muller *)
<*PRAGMA LL*>

UNSAFE INTERFACE NTScrnPxmp;

IMPORT NTScreenType, NTScrnTpRep, Rect, ScrnPixmap, TrestleComm, WinDef;

REVEAL NTScreenType.T <: T;

TYPE
  T_Pub = NTScrnTpRep.Public OBJECT END;
  T <: T_Pub;

PROCEDURE NewOracle (st: NTScreenType.T): ScrnPixmap.Oracle RAISES {};

PROCEDURE FromNTPixmap (         st    : NTScreenType.T;
                                hbm   : WinDef.HBITMAP;
                       READONLY bounds: Rect.T;
                                depth : INTEGER        ): ScrnPixmap.T;
<* LL.sup = st.trsl *>
(* Construct and return the screen pixmap of type st whose contents are
   those of xpm, which has the given bounds and depth. *)

PROCEDURE PixmapDomain (st: NTScreenType.T; pmId: INTEGER): Rect.T;
(* return the domain of the ScrnPixmap.T whose id is pmID. LL.sup =
   st.trsl. *)

PROCEDURE PixmapFromRaw (st: NTScreenType.T; pm: ScrnPixmap.Raw): WinDef.HBITMAP
  RAISES {TrestleComm.Failure}; <* LL.sup = st.trsl *>

END NTScrnPxmp.
