(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* by Steve Glassman, Mark Manasse and Greg Nelson *)
(* Last modified on Tue Jan 31 09:32:44 PST 1995 by kalsow *)
(*      modified on Thu Apr 22 10:18:29 PDT 1993 by steveg *)
(*      modified on Fri Nov  6 19:56:00 PST 1992 by msm    *)
(*      modified on Mon Feb 24 13:59:53 PST 1992 by muller *)
<*PRAGMA LL*>

UNSAFE MODULE NTScrnPxmp;

IMPORT Ctypes, NT, NTScreenType, PaintPrivate, Palette, Pixmap, Point,
       Rect, ScrnPixmap, ScreenType, TrestleComm, WinDef, Word;

REVEAL
  T = T_Pub BRANDED OBJECT
      END;

TYPE
  NTPixmap = ScrnPixmap.T OBJECT
              st: NTScreenType.T;
            OVERRIDES
              unload   := PixmapUnregister;
              localize := PixmapLocalize;
              free     := PixmapFree
            END;

  PixmapOracle = ScrnPixmap.Oracle OBJECT
                   st: NTScreenType.T;
                 OVERRIDES
                   load    := PixmapRegister;
                   list    := PixmapList;
                   lookup  := PixmapLookup;
                   builtIn := PixmapBuiltIn
                 END;

PROCEDURE NewOracle (st: NTScreenType.T): ScrnPixmap.Oracle =
  BEGIN
    RETURN NEW(PixmapOracle, st := st)
  END NewOracle;

PROCEDURE PixmapDomain (st: NTScreenType.T; pmId: INTEGER): Rect.T =
  BEGIN
    NT.Assert(0); (* NYI *)
  END PixmapDomain;

(* PixmapRegister, List, and Lookup must be changed to use the names. *)

PROCEDURE PixmapRegister (                    orc: PixmapOracle;
                                     READONLY pm : ScrnPixmap.Raw;
                          <*UNUSED*>          nm : TEXT             := NIL):
  ScrnPixmap.T RAISES {TrestleComm.Failure} =
  BEGIN
    NT.Assert(0); (* NYI *)
  END PixmapRegister;

PROCEDURE PixmapList (<*UNUSED*> orc       : PixmapOracle;
                      <*UNUSED*> pat       : TEXT;
                      <*UNUSED*> maxResults: CARDINAL       := 1):
  REF ARRAY OF TEXT RAISES {TrestleComm.Failure} =
  BEGIN
    RETURN NIL
  END PixmapList;

PROCEDURE PixmapLookup (<*UNUSED*> orc: PixmapOracle; <*UNUSED*> name: TEXT):
  ScrnPixmap.T RAISES {TrestleComm.Failure} =
  BEGIN
    RETURN NIL
  END PixmapLookup;

PROCEDURE PixmapBuiltIn (orc: PixmapOracle; pm: Pixmap.Predefined):
  ScrnPixmap.T =
  VAR res: ScrnPixmap.T;
  BEGIN
    IF orc.st.bits # orc.st THEN
      res := Palette.ResolvePixmap(orc.st.bits, Pixmap.T{pm});
      IF pm = Pixmap.Empty.pm THEN orc.st.empty := res.id END;
      RETURN res
    END;
    RETURN NEW(NTPixmap, id := 0, depth := 1, bounds := Rect.Empty)
  END PixmapBuiltIn;

PROCEDURE PixmapLocalize (pm: NTPixmap; READONLY rect: Rect.T):
  ScrnPixmap.Raw RAISES {TrestleComm.Failure} =
  BEGIN
    NT.Assert(0); (* NYI *)
  END PixmapLocalize;

PROCEDURE PixmapUnregister (<*UNUSED*> pm: ScrnPixmap.T)
  RAISES {TrestleComm.Failure} =
  BEGIN
  END PixmapUnregister;

PROCEDURE PixmapFree (pm: NTPixmap) RAISES {TrestleComm.Failure} =
  BEGIN
   NT.Assert(0); (* NYI *)
  END PixmapFree;

PROCEDURE FromNTPixmap (         st    : NTScreenType.T;
                                 hbm   : WinDef.HBITMAP;
                        READONLY bounds: Rect.T;
                                 depth : INTEGER         ): ScrnPixmap.T =
  BEGIN
    NT.Assert(0);                (* NYI *)
  END FromNTPixmap;

PROCEDURE PixmapFromRaw (st: NTScreenType.T; pm: ScrnPixmap.Raw): WinDef.HBITMAP
  RAISES {TrestleComm.Failure} =
  BEGIN
    NT.Assert(0);                (* NYI *)
  END PixmapFromRaw;

BEGIN 
END NTScrnPxmp.
