(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* by Steve Glassman, Mark Manasse and Greg Nelson *)
(* Last modified on Tue Apr 13 14:53:10 PDT 1993 by steveg *)
(*      modified on Tue Oct 27 02:13:53 PST 1992 by msm *)
(* modified on Mon Feb 24 13:59:41 PST 1992 by muller *)
(* modified on Wed Nov 20 16:41:02 PST 1991 by gnelson *)
<*PRAGMA LL*>

UNSAFE INTERFACE TrestleOnNT;

IMPORT Trestle, TrestleComm, VBT, WinDef;

TYPE Display <: Trestle.T;

PROCEDURE HWND (v: VBT.T): WinDef.HWND; <* LL.sup = VBT.mu *>
(* Return the window handle associated with a VBT (or NT.CNULL) *)

<*INLINE*> PROCEDURE Enter (t: Display) RAISES {TrestleComm.Failure};
(* Lock t.  The exception is raised when the NT connection is closed.*)

<*INLINE*> PROCEDURE Exit (t: Display; deltaCoverage: [-1 .. 1] := 0)
  RAISES {TrestleComm.Failure};
(* Release the lock on t, after possibly flushing the queue of pending
   operations.

   Each t: T contains a cardinal t.coverage, which is incremented by
   deltaCoverage as the Exit happens.  If the result is zero, the NT
   connection is flushed.  A thread making a sequence of calls to
   Enter/Exit can minimize unnecessary flushing by setting deltaCoverage to
   +1 on the first exit, to -1 on the last exit, and to 0 on the other
   exits.

   LL = t. *)

END TrestleOnNT.
