(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* by Steve Glassman, Mark Manasse and Greg Nelson *)
(* Last modified on Thu Apr 15 17:25:35 PDT 1993 by steveg *)
(*      modified on Tue Oct 27 02:25:09 PST 1992 by msm *)
(* modified on Mon Feb 24 13:59:41 PST 1992 by muller *)
(* modified on Wed Nov 20 16:41:02 PST 1991 by gnelson *)
<*PRAGMA LL*>

UNSAFE MODULE TrestleOnNT;

IMPORT NT, NTClientF, Thread, TrestleClass, TrestleComm, VBT, VBTClass, WinDef;

PROCEDURE HWND (v: VBT.T): WinDef.HWND =
  BEGIN
    LOOP
      IF v = NIL THEN RETURN NT.CNULL END;
      TYPECASE v.upRef OF
        NTClientF.Child (ch) => IF ch # NIL THEN RETURN ch.hwnd END
      ELSE                      (* skip *)
      END;
      v := v.parent
    END
  END HWND;

<*INLINE*> PROCEDURE Enter (t: Display) RAISES {TrestleComm.Failure} =
  BEGIN
    Thread.Acquire(t);
    IF t.dead THEN Thread.Release(t); RAISE TrestleComm.Failure END
  END Enter;

<*INLINE*> PROCEDURE Exit (t: Display; deltaCoverage: [-1 .. 1] := 0)
  RAISES {TrestleComm.Failure} =
  BEGIN
    TRY
      IF t.dead THEN RAISE TrestleComm.Failure END;
      NTClientF.AdjustCoverage(t, deltaCoverage)
    FINALLY
      Thread.Release(t)
    END
  END Exit;

BEGIN
END TrestleOnNT.
