# This file is part of Solitaire

#
# About window
#
global exist

set exist(about)  0
set exist(congratulation) 0
set exist(lose) 0

proc about {} {
  global display
  global solitaire_author solitaire_version solitaire_date
  global exist

  if {$exist(about)} { destroy $display.about; set exist(about) 0; about; return }
  set exist(about) 1

  set color "#c3c3c3"  
  set xcolor "#8f8f8f" 
  set font "-adobe-courier-medium-o-normal--12-120-75-75-m-70-iso8859-1"

  toplevel $display.about
  wm title $display.about "about xstones"
  frame $display.about.frame1         -bg $color
  frame $display.about.frame2         -bg $color
  frame $display.about.frame3                 -bg $color
  frame $display.about.frame4 -height 40         -bg $color
  frame $display.about.frame5 -height 10         -bg $color
  pack append $display.about $display.about.frame1 {top fillx} \
                             $display.about.frame2 {top fillx} \
                             $display.about.frame3 {top fillx} \
                             $display.about.frame4 {top fillx} \
                             $display.about.frame5 {top fillx} 
  canvas $display.about.frame1.canvas \
	-confine true \
	-relief flat \
        -width 340 \
        -height 48 \
        -bg $color

# title.bit is bitmap file of Solitaire Logo
#  $display.about.frame1.canvas create bitmap 170 25 -bitmap @title.bit
  $display.about.frame1.canvas create text 170 25 -text "xstones (solitaire)"
  pack $display.about.frame1.canvas 
  message $display.about.frame2.message  -width 340 \
	-text "version $solitaire_version $solitaire_date" -font $font -bg $color
  pack $display.about.frame2.message
  message $display.about.frame3.message -width 340 \
        -text "created by $solitaire_author"  -font $font  -bg $color
  pack $display.about.frame3.message
  button $display.about.frame4.button -text "  ok  " \
                                      -command "destroy $display.about; set exist(about) 0" \
                                      -bg $color \
                                      -activebackground $xcolor \
                                      -activeforeground $color
  pack $display.about.frame4.button
}

#
# Congratulation Window
# When player complete the game, This window popup
#
proc congratulation {} {
  global display
  global exist
  if {$exist(congratulation)} { 
	destroy $display.happy; 
	set exist(congratulation) 0; 
	congratulation; 
	return 
  }
  set exist(congratulation) 1

  set color "#c3c3c3"
  set xcolor "#8f8f8f"
  set bigfont "-adobe-helvetica-bold-o-normal--25-180-100-100-p-138-iso8859-1"
  set font "-adobe-courier-medium-o-normal--12-120-75-75-m-70-iso8859-1"
  toplevel $display.happy
  wm title $display.happy "xstones congratulation"
  frame $display.happy.frame1         -bg $color
  frame $display.happy.frame2         -bg $color
  frame $display.happy.frame3         -bg $color
  pack append $display.happy $display.happy.frame1 {top fillx} \
                             $display.happy.frame2 {top fillx} \
                             $display.happy.frame3 {top fillx} 
  message $display.happy.frame1.message  -width 340 \
	-text "Congratulation" -font $bigfont  -bg $color -fg "#474747"
  pack $display.happy.frame1.message

  set resultcolor red

  global solitaire_stones solitaire_misc 
  set i 0
  while {$i < 49 } {
	if {$solitaire_stones(pos:$i) != -1} {
		break;
        }
	incr i
  }
  set result "good"
  if {$solitaire_misc(n_count) < [expr $solitaire_misc(max_stone)-2]} {
    set result "very good"
  }
  if {$solitaire_misc(n_count) < [expr $solitaire_misc(max_stone)-5]} {
    set result "excellent"
  }
  if {$solitaire_misc(n_count) < [expr $solitaire_misc(max_stone)-8]} {
    set result "very excellent"
  }
  if {$solitaire_stones(pos:$i) == 24} {
    set result "extraordinary excellent"
    if {$solitaire_misc(n_count) < [expr $solitaire_misc(max_stone)-5]} {
      set result "crazy"
    }
    if {$solitaire_misc(n_count) < [expr $solitaire_misc(max_stone)-10]} {
      set result "mad"
    }
  }

  global solitaire_pattern_name
  message $display.happy.frame2.message1 -width 340 \
        -text "You complete \"$solitaire_pattern_name\"" -fg white -bg $color
  pack $display.happy.frame2.message1
  message $display.happy.frame2.message2 -width 340 \
        -text $result -fg $resultcolor -bg $color
  pack $display.happy.frame2.message2

  button $display.happy.frame3.button -text "  ok  " \
                                      -command "destroy $display.happy; set exist(congratulation) 0; restart" \
                                      -bg $color \
                                      -activebackground $xcolor \
                                      -activeforeground $color
  pack $display.happy.frame3.button
}

#
# Lose Window
# When player has no effective move, This window popup
#
proc lose {} {
  global display
  global exist

  if {$exist(lose)} { 
	destroy $display.lose
	set exist(lose) 0
	lose
	return 
  }
  set exist(lose) 1
	
  set color "#c3c3c3"
  set xcolor "#8f8f8f"
  set bigfont "-adobe-helvetica-bold-o-normal--25-180-100-100-p-138-iso8859-1"
  set font "-adobe-courier-medium-o-normal--12-120-75-75-m-70-iso8859-1"
  toplevel $display.lose
  wm title $display.lose "xstones"
  frame $display.lose.frame1         -bg $color
  frame $display.lose.frame2         -bg $color
  frame $display.lose.frame3         -bg $color
  pack append $display.lose $display.lose.frame1 {top fillx} \
                             $display.lose.frame2 {top fillx} \
                             $display.lose.frame3 {top fillx} 
  message $display.lose.frame1.message  -width 340 \
	-text "You lose" -font $bigfont  -bg $color -fg "#474747"
  pack $display.lose.frame1.message

  set resultcolor red

  message $display.lose.frame2.message -width 340 \
        -text "How about coffee?" -fg $resultcolor -bg $color
  pack $display.lose.frame2.message

  button $display.lose.frame3.button -text "  ok  " \
                                      -command "destroy $display.lose; set exist(lose) 0" \
                                      -bg $color \
                                      -activebackground $xcolor \
                                      -activeforeground $color
  pack $display.lose.frame3.button
}
# end of file
