# This file is part of Solitaire

#
# display: graphical interface
#

# main:
# This is entry point of this program

solitaire_init
solitaire_board_clear
solitaire_put_stones_on_board

#
# design of toplevel window
#

# bitmap file directory
set bitmapdir $solitaire_directory

# window manager

wm title .  "xstones"
# wm iconbitmap . "$bitmapdir/icon.bmp"

set display ""


#
# menu
#

frame $display.menubar -relief raised
menubutton $display.menubar.menu1 -text "Game" -relief groove  \
				  -menu "$display.menubar.menu1.m"
menubutton $display.menubar.menu2 -text "Pattern" -relief groove  \
				  -menu "$display.menubar.menu2.m"
button $display.menubar.menu3 -text "About" -relief groove \
				  -command "about"
pack $display.menubar -fill x -side top
pack append $display.menubar $display.menubar.menu1 {left} \
                             $display.menubar.menu2 {left} \
                             $display.menubar.menu3 {left}

menu $display.menubar.menu1.m
menu $display.menubar.menu2.m

pack $display.menubar.menu1
pack $display.menubar.menu2

$display.menubar.menu1.m add command -label restart -command "restart"
$display.menubar.menu1.m add command -label quit -command "exit"
$display.menubar.menu2.m add command -label solitaire \
				     -command "set_pattern solitaire"
$display.menubar.menu2.m add command -label diamond \
			     -command "set_pattern diamond"
$display.menubar.menu2.m add command -label "greece cross" \
			     -command "set_pattern greececross"
$display.menubar.menu2.m add command -label "latain cross" \
			     -command "set_pattern lataincross"
$display.menubar.menu2.m add command -label "stove" \
			     -command "set_pattern stove"
$display.menubar.menu2.m add command -label "lamp" \
			     -command "set_pattern lamp"
$display.menubar.menu2.m add command -label "pyramid" \
			     -command "set_pattern pyramid"
$display.menubar.menu2.m add command -label "beginner" \
			     -command "set_pattern beginner"

#
# message counts:
#
set messagecolor "#5d5d5d"
frame $display.nframe -relief groove
message $display.nframe.message -text "counts:   " -width 240 -fg $messagecolor
pack $display.nframe -side top -fill x
pack $display.nframe.message -side left -fill x
message $display.nframe.nmessage -text " $solitaire_misc(n_count) " -width 40 \
	-fg $messagecolor
pack $display.nframe.nmessage -side left -fill x

frame $display.nframe2 -relief groove
message $display.nframe2.message -text "stones:   " -width 240 -fg $messagecolor
pack $display.nframe2 -side top -fill x
pack $display.nframe2.message -side left -fill x
message $display.nframe2.rmessage -text " $solitaire_misc(remain) " -width 40 \
	-fg $messagecolor
pack $display.nframe2.rmessage -side left -fill x

#
# message error:
#

frame $display.mframe -relief groove
message $display.mframe.message -text "" -width 240
pack $display.mframe -side top -fill x
pack $display.mframe.message -side top -fill x

#
# game pattern:
#

for {set i 0} { $i < 7 } {incr i} {
  frame $display.frame:$i -relief flat
  pack $display.frame:$i -side top 
}

#
# initialize display
#   create displan with buttons
# 
global xbutton

proc display_init {} {
  global solitaire_board bitmapdir display xbutton
  for {set i 0} { $i < 49 } {incr i} {
    set n_frame [expr $i/7]
    if {[range $i]} {
       button $display.frame:$n_frame.button:$i -bitmap @$bitmapdir/null.bmp  \
 	     -relief flat -command "selected $i"
       pack $display.frame:$n_frame.button:$i -side left

       set xbutton($i) $display.frame:$n_frame.button:$i
    } else {
       label $display.frame:$n_frame.label:$i -bitmap @$bitmapdir/null.bmp -bg "#dddddd"
       pack $display.frame:$n_frame.label:$i -side left
    }
  }
}

#
# According to stones pattern on board,
#   modify entry buttons form of boards
#

proc put_stone_on_display {} {
  global solitaire_board display xbutton

  for {set i 0} { $i < 49 } {incr i} {
    if {[range $i]} {
      if {$solitaire_board(stone:$i) == -1} {
        $xbutton($i) config -relief flat -command "selected $i"
      } else {
        $xbutton($i) config -relief raised -command "selected $i"
      }
    }
  }
}

display_init
put_stone_on_display

#
# remove action 
# when remove button, this proc is called
#
proc nofunction {} {
}
proc remove_stone_from_display {} {
        global solitaire_board display xbutton

        for {set i 0} { $i < 49 } {incr i} {
          if {[range $i]} {
            set $solitaire_board(stone:$i) -1
              $xbutton($i) config -relief flat -command "nofunction"
            }
        }
}


#
# buttons:  undo cancel button
#

frame $display.yframe -relief groove
pack $display.yframe -side top  -side left
#button $display.yframe.button_quit -text quit -command "exit" -relief groove
#pack $display.yframe.button_quit -side left
button $display.yframe.button_undo -text undo -command "undo"  -relief groove
pack $display.yframe.button_undo -side left
button $display.yframe.button_cancel -text cancel -command "cancel"  -relief groove
pack $display.yframe.button_cancel -side left
# end of definition of toplevel window


#
# select action 
# When button is selected, this proc is called
#
set state_none     0
set state_selected 1
set state_end      2
set state          $state_none
set state_selected_pos 0

proc xwait {} {
  for {set i 0} {$i < 500} {incr i} {}
}

set colorarray(0)  "#e41cc4"
set colorarray(1)  "#c41cd0"
set colorarray(2)  "#1ce4c4"
set colorarray(3)  red
set colorarray(4)  white
set colorarray(5)  "#b1f131"
set colorarray(6)  "#f1b131"
set colorarray(7)  "#31b1f1"
set colorarray(8)  "#c4e41c"
set colorarray(9)  "#21918f"
set colorarray(10) "#912271"
set colorarray(11) "#4fb261"
set colorarray(12) "#b142fe"
set colorarray(13) "#42b152"
set colorarray(14) "#3142d0"
set colorarray(15) "#c42cd4"
set colorarray(16) "#910281"

proc removedstonecolor {} {
  global solitaire_misc colorarray
  set i [expr $solitaire_misc(remain) % 17]
  return $colorarray($i)
}

proc selected {i} {
  global state state_none state_selected state_end state_selected_pos display \
         solitaire_misc solitaire_board xbutton

  set selectedbutton $xbutton($i)

  if {$state == $state_none} {  
    if {$solitaire_board(stone:$i) == -1} {
      return ;
    }
    $selectedbutton config -relief groove -bg HotPink
    set state $state_selected
    set state_selected_pos $i
    return
  }
  if {$state == $state_selected} {  
    set frombutton $xbutton($state_selected_pos)

    set result [solitaire_stone_move $state_selected_pos $i]
    if {$result == 0} {
#       error "cannot move"
    } else {
      $selectedbutton config -relief raised 
      $xbutton($solitaire_misc(removed)) config -bg [removedstonecolor]

      update
      xwait

      $selectedbutton config -relief raised
      $frombutton   config -relief flat -bg {#ffe4c4}
      $xbutton($solitaire_misc(removed)) config -relief flat -bg {#ffe4c4}

      update_info

      set solitaire_misc(removed)   -1
      set state $state_none
      set state_selected_pos  0
    }
    if {$solitaire_misc(remain) == 1} {
      set state $state_end
      congratulation
#      save_game
    } else {
      if {[solitaire_lose_p]} {
        lose
      }
    }
    return
  }
  if {$state == $state_end} {
   return
  }
}

#
# cancel:
# When cancell button pushed, This function is called
# clear selected button 
# clear state of game 
#
proc cancel {} {
  global state state_selected_pos state_none display xbutton
  if {$state_selected_pos == 0} { return }
  $xbutton($state_selected_pos) config -relief raised -bg {#ffe4c4}
  set state $state_none
  set state_selected_pos 0
}


#
# set pattern
# When pattern selected from pattern menu, this proc is called 
#

proc set_pattern patternname {
  global solitaire_stone_pattern solitaire_pattern display solitaire_pattern_name

  cancel
  solitaire_var_clear
  solitaire_board_clear
  set solitaire_pattern_name $patternname
  set solitaire_stone_pattern $solitaire_pattern($patternname)
  solitaire_put_stones_on_board
  
  remove_stone_from_display
  put_stone_on_display 

  update_info
}

#
# undo:
# When undo button pushed, This function is called
#

proc undo {} {
  global solitaire_history solitaire_misc display xbutton

  cancel
  if {$solitaire_misc(n_action) == 0} {
    return 
  }
  set i [expr $solitaire_misc(n_action)-1]
  set stone $solitaire_history(stone:$i)  
  set from $solitaire_history(from:$i)   
  set to $solitaire_history(to:$i)     
  set removedpos $solitaire_history(removedpos:$i)      
  set removedstone $solitaire_history(removedstone:$i)    

  if {![solitaire_undo]} {
    return 
  }

  $xbutton($from) config -relief raised
  $xbutton($to) config -relief flat
  $xbutton($removedpos) config -relief raised

  update_info

}

#
# update counts and stons information on top window
#
proc update_info {} {
  global solitaire_misc display
  $display.nframe.nmessage config -text " $solitaire_misc(n_count)  "
  $display.nframe2.rmessage config -text " $solitaire_misc(remain)  "
}


#
# restart:
# When restart button selected, This function is called
#

proc restart {} {
  global state state_none state_selected_pos
  cancel
  set state $state_none
  set state_selected_pos 0

  solitaire_var_clear
  solitaire_board_clear
  solitaire_put_stones_on_board
  remove_stone_from_display
  put_stone_on_display 
  update_info  
}
# end of file
