# This file is part of Solitaire

#
# solitaire game engine
# definition of board and stones
#

global solitaire_board
global solitaire_stones 
global solitaire_misc
global solitaire_history


set solitaire_board(0)  0
set solitaire_stones(0) 0
set solitaire_misc(removed)  -1
set solitaire_misc(n_count)   0
set solitaire_misc(last_moved_stone) -1
set solitaire_misc(n_action) 0
set solitaire_misc(remain)   0

#
# definition of stone patterns
#
global solitaire_pattern
set solitaire_pattern(solitaire) \
 [list 2 3 4 9 10 11 14 15 16 17 18 19 20 21 22 23 25 26 27 28 29 30 31 32 33 34 37 38 39 44 45 46]
set solitaire_pattern(diamond) \
 [list 3 9 10 11 15 16 17 18 19 21 22 23 25 26 27 29 30 31 32 33 37 38 39 45]
set solitaire_pattern(greececross) \
 [list 10 16 17 18 24 31]
set solitaire_pattern(lataincross) \
 [list 10 17 22 23 24 25 26 31 38]
set solitaire_pattern(stove) \
 [list 2 3 4 9 10 11 16 17 18 23 25]
set solitaire_pattern(lamp) \
 [list 3 9 10 11 15 16 17 18 19 24 31 37 38 39 44 45 46 ]
set solitaire_pattern(pyramid) \
 [list 10 16 17 18 22 23 24 25 26 28 29 30 31 32 33 34]
set solitaire_pattern(beginner) \
 [list 3 10]

global solitaire_pattern_name
global solitaire_stone_pattern

set solitaire_pattern_name solitaire
set solitaire_stone_pattern $solitaire_pattern(solitaire)
set solitaire_misc(max_stone)   0

proc solitaire_var_clear {} {
  global solitaire_history
  global solitaire_misc

  set solitaire_misc(removed)  -1
  set solitaire_misc(n_count)   0
  set solitaire_misc(last_moved_stone) -1
  set solitaire_misc(n_action) 0
  for {set i 0} { $i < 49 } {incr i} {
    set solitaire_history(stone:$i)   0
    set solitaire_history(from:$i)    0
    set solitaire_history(to:$i)      0
    set solitaire_history(removedpos:$i)        0
    set solitaire_history(removedstone:$i)      0  
    set solitaire_history(before_n_count:$i)    0     
    set solitaire_history(before_last_moved_stone:$i)  0
    set solitaire_history(remain:$i)                   0
  }
}

proc solitaire_board_clear {} {
  global solitaire_board
  global solitaire_stones 
  for {set i 0} { $i < 49 } {incr i} {
        set solitaire_board(stone:$i) -1;
        set solitaire_stones(pos:$i)  -1;
  }

}

proc solitaire_init {} {
  global solitaire_board solitaire_stones solitaire_history

  solitaire_var_clear
  for {set i 0} { $i < 49 } {incr i} {
        set solitaire_board(pos:$i)   $i;
        set solitaire_board(avail:$i)  1;
        set solitaire_board(stone:$i) -1;
        set solitaire_stones(pos:$i)  -1;
  }
  set notavail [list 0 1 5 6 7 8 12 13 35 36 40 41 42 43 47 48]
  foreach n $notavail {
        set solitaire_board(avail:$n) 0;
  }
}

proc solitaire_put_stones_on_board {} {
        global solitaire_stone_pattern solitaire_board solitaire_stones solitaire_misc
        set n_stone 0
        foreach n $solitaire_stone_pattern {
                set solitaire_stones(pos:$n_stone) $n;
                set solitaire_board(stone:$n) $n_stone;
                incr n_stone
        }
        set solitaire_misc(max_stone) $n_stone
        set solitaire_misc(remain)    $n_stone
}

#
# range:
# whether pos is on-board or outof-board
# if ok return 1 if outof range return 0
#
proc range {pos} {
        global solitaire_board
        if { $pos < 0 } {
            return 0;
        }
        if { $pos > 48 } {
            return 0;
        }
#        puts stdout $pos
        if {$solitaire_board(avail:$pos) == 0} {
            return 0
        }
        return 1;
}


#
#  reachable
#  return reachable list   {to1 removed1 to2 removed2 ..}
#
proc stone_reachable {from} {
  global solitaire_board solitaire_stones 
  set poses ""
  if {![range $from]} {
        return ""
  }
# north
  set to [expr $from-14]
  if {![range $to]} {
        
  } else {
  if {$poses == ""} {
        set poses $to
  } else {
        lappend poses $to
  }
        lappend poses [expr $from-7]
  }
# west
  set to [expr $from-2]
  if {![range $to]} {

  } else {
    set flag 1
    foreach n [list 14 15 21 22 28 29] {
        if {$n == $from} {
          set flag 0
        }
    }
    if {$flag == 1} {
      if {$poses == ""} {
        set poses $to
      } else {
        lappend poses $to
      }
      lappend poses [expr $from-1]
    }
  }
# east
  set to [expr $from+2]
  if {![range $to]} {

  } else {
    set flag 1
    foreach n [list 19 20 26 27 33 34] {
        if {$n == $from} {
          set flag 0
        }
    }
   if {$flag == 1} {
   if {$poses == ""} {
        set poses $to
    } else {
        lappend poses $to
    }
    lappend poses [expr $from+1]
  }
  }
# south
  set to [expr $from+14]
  if {![range $to]} {

  } else {
  if {$poses == ""} {
        set poses $to
  } else {
        lappend poses $to
  }
        lappend poses [expr $from+7]
  }
  return $poses
}

#
# To check lose-p?, this function is called every stone.
#

proc stone_movable_p {from} {
        global solitaire_board solitaire_stones 

        set reachable [stone_reachable $from]
        set counter 0
        set xlength [llength $reachable]

        if {$xlength == 0} {
                return 0
         }
        while {$counter < $xlength} {
          set n [lindex $reachable $counter]
          incr counter
          set m [lindex $reachable $counter]
# n: to pos  m: between pos
            if {$solitaire_board(stone:$n) == -1} {
              if {$solitaire_board(stone:$m) != -1} {
                return 1
            }
          }
          incr counter
        }
        return 0
}

#
# To check whether be able to move 'from' to 'to' or not.
# if fail return -1
# if success return "between position".
#
proc stone_movable {from to} {
        global solitaire_board solitaire_stones 
        if {$from == $to} {
          return -1;
        }
        if {$solitaire_board(stone:$to) != -1} {
          return -1;
        }
        set found 0
        set reachable [stone_reachable $from]
        set counter 0
        set xlength [llength $reachable]
        if {$xlength == 0} {
                return -1
         }
        while {$counter < $xlength} {
          set n [lindex $reachable $counter]
          incr counter
          set m [lindex $reachable $counter]
          if {$n == $to} {
            set found 1                
            break;
          }
          incr counter
        }
        if {!$found} {
                return -1
        }
        if {$solitaire_board(stone:$m) == -1} {
                return -1
        }
        return $m
}

#
# solitaire_stone_move:
# This function is main action routine of engine
# move stone 'from' to 'to'
#  update board information
#  update history information
#
proc solitaire_stone_move {from to {actionp 1}} {
        global solitaire_board solitaire_stones solitaire_misc
# check movable
        if {![range $from]} {
                return 0;
        }
        if {![range $to]} {
                return 0;
        }
        if {$solitaire_board(stone:$from) == -1} {
          return 0;
        }
# get reachable list
        set removed [stone_movable $from $to]
        if {$removed == -1} {
          return 0
        }
       
        set before_n_count           $solitaire_misc(n_count)
        set before_last_moved_stone  $solitaire_misc(last_moved_stone)

        if {$actionp} {
# move stone from to
          set stone $solitaire_board(stone:$from)
          set solitaire_board(stone:$to) $stone
          set solitaire_board(stone:$from) -1
          set solitaire_stones(pos:$stone) $to
# remove stone from solitaire_board
          set rmstone $solitaire_board(stone:$removed)
          set solitaire_board(stone:$removed) -1        
          set solitaire_stones(pos:$rmstone) -1

          if {$stone != $solitaire_misc(last_moved_stone)} {
            incr solitaire_misc(n_count)
          }
          set solitaire_misc(last_moved_stone) $stone
          set solitaire_misc(remain) [expr $solitaire_misc(remain)-1]

# save history {stone from to removedpos removedstone before_count before_last_moved_stone}
          global solitaire_history
           set i $solitaire_misc(n_action)
          set solitaire_history(stone:$i)  $solitaire_misc(last_moved_stone)
          set solitaire_history(from:$i)   $from
          set solitaire_history(to:$i)     $to
          set solitaire_history(removedpos:$i)       $removed  
          set solitaire_history(removedstone:$i)     $rmstone
          set solitaire_history(before_n_count:$i)          $before_n_count
          set solitaire_history(before_last_moved_stone:$i) $before_last_moved_stone
          set solitaire_history(remain:$i) [expr $solitaire_misc(remain)+1]

          incr solitaire_misc(n_action)

	  global solitaire_debug
	  if {$solitaire_debug} {  solitaire_debug_history $i }
           
        }
        set solitaire_misc(removed) $removed
        return 1
}

#
# undo:
#  update all global variable to backward state
# 
proc solitaire_undo {} {
  global solitaire_board solitaire_stones solitaire_misc solitaire_history state_none
  
  set state $state_none
  if {$solitaire_misc(n_action) == 0} {
        return 0
  }
  set solitaire_misc(n_action) [expr $solitaire_misc(n_action)-1]
  set i $solitaire_misc(n_action)

  set stone $solitaire_history(stone:$i)  
  set from $solitaire_history(from:$i)   
  set to $solitaire_history(to:$i)     
  set removedpos $solitaire_history(removedpos:$i)      
  set removedstone $solitaire_history(removedstone:$i)    

  set solitaire_board(stone:$to)    -1
  set solitaire_board(stone:$from)  $stone
  set solitaire_stones(pos:$stone)  $from

  set solitaire_board(stone:$removedpos)  $removedstone
  set solitaire_stones(pos:$removedstone) $removedpos

  set solitaire_misc(removed)          -1
  set solitaire_misc(n_count)          $solitaire_history(before_n_count:$i)          
  set solitaire_misc(last_moved_stone) $solitaire_history(before_last_moved_stone:$i) 
  set solitaire_misc(remain)           $solitaire_history(remain:$i)

  global solitaire_debug
  if {$solitaire_debug} { solitaire_assert }
  return 1
}

#
# lose-p?
#   check whether player lose game or not.
#
proc solitaire_lose_p {} {
  global solitaire_board solitaire_stones solitaire_misc
  for {set i 0} { $i < $solitaire_misc(max_stone) } {incr i} {
    if {$solitaire_stones(pos:$i) != -1} {
      set flag [stone_movable_p $solitaire_stones(pos:$i)]
      if {$flag} { return 0 }
    }
  }
  return 1
}


#
# Debugging, Helper, Misc
#
proc solitaire_assert {} {
  global solitaire_board solitaire_stones
  for {set i 0} { $i < 49 } {incr i} {
        if {$solitaire_board(stone:$i) != -1} {
          set stone $solitaire_board(stone:$i)
            if {$solitaire_stones(pos:$stone) != -1} {
                if {$i == $solitaire_stones(pos:$stone)} {

                } else {
                   error "internal error $i $stone $solitaire_stones(pos:$stone)"
                }
          }
        }
  }
}

proc solitaire_debug_globals {} {
  global solitaire_history
  global solitaire_misc
  
  puts stdout "removed $solitaire_misc(removed)"
  puts stdout "n_count $solitaire_misc(n_count)"
  puts stdout "last_moved_stone $solitaire_misc(last_moved_stone)"
  puts stdout "n_action $solitaire_misc(n_action)"
}

proc solitaire_debug_board {} {
        global solitaire_board
        for {set n 0} { $n < 49 } {incr n} {
                if {[expr [expr $n%7] == 0]} {
                        puts stdout ""
                }
                if {$solitaire_board(avail:$n) == -1} {
                        puts stdout "- " nonewline
                }
                puts stdout $solitaire_board(stone:$n) nonewline
                puts stdout " " nonewline
                incr n
        }
}

proc solitaire_print_pos {} {
        for {set n 0} { $n < 49 } {incr n} {
                if {[expr [expr $n%7] == 0]} {
                        puts stdout ""
                }
                puts stdout $n nonewline
                puts stdout " " nonewline
        }
}

proc xstone_move {from to} {
        if {[solitaire_stone_move $from $to] == 0} {
                error ":not move"
        }
}


proc solitaire_debug_history {i} {
          global solitaire_history
          puts stdout "$solitaire_history(stone:$i) " nonewline 
          puts stdout "$solitaire_history(from:$i) " nonewline  
          puts stdout "$solitaire_history(to:$i) " nonewline    
          puts stdout "$solitaire_history(removedpos:$i) " nonewline 
          puts stdout "$solitaire_history(removedstone:$i) " nonewline 
          puts stdout "$solitaire_history(before_n_count:$i) " nonewline
          puts stdout "$solitaire_history(before_last_moved_stone:$i)"
}

# end of file
