#ifndef _GDEV_H
#define _GDEV_H

#include "include/deftype.h"
#if X11
#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/xpm.h>
#endif

typedef struct gscreen
  {
#if X11
    Display *display;		/* display */
    Window window;
    integer_t height, width;
#endif
  }
 *gscreen_t;

#if X11
typedef Pixmap gpixmap_t;
#endif

typedef struct gdev
  {
#if X11
    struct
      {
	struct gscreen g;
	gpixmap_t hidden;
	GC gc;
	GC fg, bg;
	GC textgc;
	GC cursorgc;
	XFontStruct *normalfont;
	int screen;
	int depth;
	Colormap colormap;
	XFontStruct *fontstruct;
#define _GDEV_N_FONTS 7
	XFontStruct *fonts[_GDEV_N_FONTS];
      }
    x11;
#endif
  }
 *gdev_t;

#include "spr.h"
#include "gdevdecl.h"

#endif
