#include "dev/gdev.h"

void
gdev_render_pixmap(gdev, p, pM, dest,  src_x, src_y,  w, h, x, y)
     gdev_t gdev;
     integer_t x, y;
     gpixmap_t p, pM;
{
  Display *display = gdev->x11.g.display;
  Pixmap pixmap = p;
  Pixmap mask = pM;
  GC gc = gdev->x11.gc;

  /* Set to dest x and y clip origin */
  XSetClipOrigin (display, gc, x, y);

  /* Set the clipping mask */
  XSetClipMask (display, gc, mask);

  XCopyArea (display, pixmap, dest, gc, src_x, src_y, w, h, x, y);

  /* Unset clip (or add a clip gc) */
  XSetClipMask (display, gc, None);
}


void
gdev_draw_render (gdev, p, pM, src_x, src_y,  w, h, x, y)
     gdev_t gdev;
     integer_t x, y;
     gpixmap_t p, pM;
{
  Display *display = gdev->x11.g.display;
  Pixmap window = gdev->x11.hidden;
  Pixmap pixmap = p;
  Pixmap mask = pM;
  GC gc = gdev->x11.gc;

  /* Set to dest x and y clip origin */
  XSetClipOrigin (display, gc, x, y);

  /* Set the clipping mask */
  XSetClipMask (display, gc, mask);

  XCopyArea (display, pixmap, window, gc, src_x, src_y, w, h, x, y);

  /* Unset clip (or add a clip gc) */
  XSetClipMask (display, gc, None);
}
