#include "dev/gdev.h"

extern GC gc;

void
gdev_draw_sprite (gdev, x, y, sprite)
     gdev_t gdev;
     integer_t x, y;
     gsprite_t sprite;
{
  Display *display = gdev->x11.g.display;
  Window window = gdev->x11.g.window;
  Pixmap pixmap = sprite->p;
  Pixmap mask = sprite->pM;
  int w = sprite->width;
  int h = sprite->height;

  /* Set to dest x and y clip origin */
  XSetClipOrigin (display, gc, x, y);

  /* Set the clipping mask */
  XSetClipMask (display, gc, mask);

  XCopyArea (display, pixmap, window, gc, 0, 0, w, h, x, y);

  /* Unset clip (or add a clip gc) */
  XSetClipMask (display, gc, None);

  sprite->x = x;
  sprite->y = y;
}
