#include "widget/widget.h"


void
_3D_XDraw3DRectangle (display,
		      drawable,
		      x, y,
		      width,
		      height,
		      border_width,
		      topGC,
		      bottomGC)
     Display *display;
     Drawable drawable;
     GC topGC, bottomGC;
{
  XPoint points[7];
  XFillRectangle (display, drawable, bottomGC, x, y + height - border_width,
		  (unsigned int) width, (unsigned int) border_width);
  XFillRectangle (display, drawable, bottomGC, x + width - border_width, y,
		  (unsigned int) border_width, (unsigned int) height);

  points[0].x = points[1].x = points[6].x = x;
  points[0].y = points[6].y = y + height;
  points[1].y = points[2].y = y;
  points[2].x = x + width;
  points[3].x = x + width - border_width;
  points[3].y = points[4].y = y + border_width;
  points[4].x = points[5].x = x + border_width;
  points[5].y = y + height - border_width;
  XFillPolygon (display, drawable, topGC, points, 7, Nonconvex,
		CoordModeOrigin);
}

void
_3D_XDraw3DFrame (display,
		  drawable,
		  x, y,
		  width,
		  height,
		  border_width,
		  topGC,
		  bottomGC)
     Display *display;
     Drawable drawable;
     GC topGC, bottomGC;
{
  XFillRectangle (display, drawable, bottomGC, x, y + height - border_width,
		  (unsigned int) width, (unsigned int) border_width);
  XFillRectangle (display, drawable, bottomGC, x + width - border_width, y,
		  (unsigned int) border_width, (unsigned int) height);
  XFillRectangle (display, drawable, bottomGC, x, y,
		  (unsigned int) width, (unsigned int) border_width);
  XFillRectangle (display, drawable, bottomGC, x, y,
		  (unsigned int) border_width, (unsigned int) height);

  XFillRectangle (display, drawable, topGC, x, y + height - border_width/2,
		  (unsigned int) width, (unsigned int) border_width / 2);
  XFillRectangle (display, drawable, topGC, x + width - border_width / 2, y,
		  (unsigned int) border_width / 2, (unsigned int) height);
  XFillRectangle (display, drawable, topGC, x, y,
		  (unsigned int) width, (unsigned int) border_width / 2);
  XFillRectangle (display, drawable, topGC, x, y,
		  (unsigned int) border_width / 2, (unsigned int) height);
}

void
_3D_XDrawFrame (display,
		  drawable,
		  x, y,
		  width,
		  height,
		  border_width,
		  topGC,
		  bottomGC)
     Display *display;
     Drawable drawable;
     GC topGC, bottomGC;
{
#if 1
  XFillRectangle (display, drawable, bottomGC, x, y + height - border_width,
		  (unsigned int) width, (unsigned int) border_width);
  XFillRectangle (display, drawable, bottomGC, x + width - border_width, y,
		  (unsigned int) border_width, (unsigned int) height);
  XFillRectangle (display, drawable, bottomGC, x, y,
		  (unsigned int) width, (unsigned int) border_width);
  XFillRectangle (display, drawable, bottomGC, x, y,
		  (unsigned int) border_width, (unsigned int) height);
#else
  XFillRectangle (display, drawable, topGC, x - border_width, y - border_width,
		  (unsigned int)width - border_width*2, 
		  (unsigned int) height - border_width*2);
  XFillRectangle (display, drawable, topGC, x, y,
		  (unsigned int)width,
		  (unsigned int) height);
#endif
}
