#include "widget/widget.h"
#include "widget/local.h"
#include "widget/button.h"

#define button_text(p)        ((struct widget_button *)p)->text
#define button_textcolor(p)   ((struct widget_button *)p)->textcolor
#define button_textfont(p)    ((struct widget_button *)p)->textfont
#define button_pixmap(p)      ((struct widget_button *)p)->pixmap
#define button_pixmap_mask(p) ((struct widget_button *)p)->pixmap_mask

widget_t
button_create (p)
     widget_t p;
{
  widget_set_geometry (p, 32, 50);
  widget_configure (p, resource_border_width, 2);
  return p;
}
void
button_destroy (o)
     widget_t o;
{
}

#define xofs(t)   (_offsetof(struct widget_button, t))

static struct configure button_configspec[] =
{
  {resource_textcolor, datatype_int, xofs (textcolor), 0},
  {resource_textfont, datatype_int, xofs (textfont), 0},
  {resource_pixmap, datatype_pixmap, xofs (pixmap), 0},
  {resource_pixmap_mask, datatype_pixmap, xofs (pixmap_mask), 0},
  {0,},
};
void
button_configure (item, resourceid, value)
     widget_t item;
     integer_t resourceid;
     void *value;
{
  int len;
  if (resourceid == resource_text)
    {
      if (button_text (item))
	{
	  xfree ((void *) button_text (item));
	}
      len = strlen (value) + 1;
      button_text (item) = memcpy (xmalloc (len), value, len);
    }
  configure_proc (item, button_configspec, resourceid, value);
}

static void
_button_display (o, relief)
     widget_t o;
     integer_t relief;
{
#if X11
  Pixmap pixmap;
  integer_t border_width;
  GC gc1, gc4;
  integer_t left, top;

  if (relief == relief_raised)
    {
      gc4 = widget_active_darkGC (o),
	gc1 = widget_active_lightGC (o);
    }
  else if (relief == relief_sunken)
    {
      gc1 = widget_active_darkGC (o),
	gc4 = widget_active_lightGC (o);
    }
  widget_abs_xy (o, 0, 0, &left, &top);

  pixmap = XCreatePixmap (widget_xdisplay (o),
			  widget_drawable (o),
			  widget_width (o),
			  widget_height (o),
			  widget_xdepth (o));
  _3D_XDraw3DRectangle (widget_xdisplay (o),
			pixmap,
			0, 0,
			widget_width (o),
			widget_height (o),
			widget_border_width (o),
			gc1,
			gc4);
  border_width = widget_border_width (o);
  XFillRectangle (widget_xdisplay (o),
		  pixmap,
		  widget_active_GC (o),
		  border_width,
		  border_width,
		  widget_width (o) - border_width * 2,
		  widget_height (o) - border_width * 2);

  if (button_pixmap (o))
    {
      integer_t width, height;

      gdev_drawable_get_geometry (o->dev,
				  button_pixmap (o),
				  &width, &height);
      if (button_pixmap_mask (o))
	{
	  gdev_render_pixmap (o->dev,
			      button_pixmap (o),
			      button_pixmap_mask (o),
			      pixmap,
			      0, 0,
			      width, height,
			      border_width, border_width);
	}
      else
	{
	  XCopyArea (widget_xdisplay (o),
		     button_pixmap (o),
		     pixmap,
		     widget_active_GC (o),
		     0, 0,
		     width, height,
		     border_width, border_width);
	}
    }
  if (button_text (o))
    {
#if 0
      XDrawImageString (widget_xdisplay (o),
			pixmap,
			widget_active_subGC (o),
			border_width,	/* border_width,   */
			border_width + 12,	/*border_width+20, */
			button_text (o), strlen (button_text (o)));
#else
	  gdev_drawtext (o->dev,
			 pixmap,
			 border_width,	/* border_width,   */
			 border_width,	/*border_width+20, */
			 button_textcolor (o), button_textfont(o), 
			 button_text (o));
#endif
    }

  XCopyArea (widget_xdisplay (o),
	     pixmap,
	     widget_drawable (o),
	     widget_active_GC (o),
	     0, 0,
	     widget_width (o),
	     widget_height (o), left, top);

  XFreePixmap (widget_xdisplay (o), pixmap);
#endif

}
void
button_display (o)
     widget_t o;
{
  _button_display (o, relief_raised);
}
void
button_action (o)
     void *o;
{






}
void
button_invoke (o, arg)
     widget_t o;
     struct callbackarg *arg;
{
  _button_display (o, relief_sunken);
  widget_sync (o);

  widget_call_callback (o, resource_buttonpress_callback, arg);

  _button_display (o, relief_raised);
  widget_sync (o);
}



struct item_type item_type_button =
{
  "button",
  widget_type_button,
  sizeof (struct widget_button),
  (void *) button_create,
  (void *) button_destroy,
  (void *) button_configure,
  (void *) button_display,
  (void *) button_action,
  (void *) button_invoke,
  0,
};
