#include "widget/widget.h"
#include "widget/local.h"

#define xofs(t)   (_offsetof(struct widget, t))
static struct configure widget_configspec[] =
{
  {resource_left, datatype_int, xofs (left), 0},
  {resource_top, datatype_int, xofs (top), 0},
  {resource_height, datatype_int, xofs (height), 0},
  {resource_width, datatype_int, xofs (width), 0},
  {resource_packed, datatype_char, xofs (packed), 0},
  {resource_border_width, datatype_char, xofs (active.border_width), 0},
  {resource_relief, datatype_char, xofs (inactive.relief), 0},
  {resource_wrap, datatype_char, xofs (wrap), 0},
  {resource_transparent, datatype_char, xofs (transparent), 0},
  {resource_fix, datatype_char, xofs (abs.fixed), 0},
  {resource_name, datatype_pointer, xofs (name), 0},
  0
};

boolean
configure_proc (item, config, resourceid, arg)
     widget_t item;
     configure_t config;
     integer_t resourceid;
     void *arg;
{
  configure_t p = config;
  char *object = (char *) item;
  integer_t ofs;

  for (; p->resourceid; p++)
    {
      if (p->resourceid != resourceid)
	{
	  continue;
	}
      ofs = p->offset;
      switch (p->datatype)
	{
	case datatype_string2int:
	  *(integer_t *) (object + ofs) = atoi ((char *) arg);
	  break;
	case datatype_int:
	  *(integer_t *) (object + ofs) = (integer_t) (arg);
	  break;
	case datatype_char:
	  *(char *) (object + ofs) = (char) (long) (arg);
	  break;
	case datatype_string:
	  *(char **) (object + ofs) = (char *) arg;
	  break;
	case datatype_pointer:
	  *(void **) (object + ofs) = (void *) arg;
	  break;
	case datatype_pixmap:
	  *(gpixmap_t *) (object + ofs) = (gpixmap_t) arg;
	  break;
	default:
	  break;
	}
      return 1;
    }
  if (config == widget_configspec)
    {
      return 0;
    }
  configure_proc (item, widget_configspec, resourceid, arg);
  return 0;
}
