/*  -*- Mode: C -*- 
 * This file is part of my project
 * 
 * frame.c -- 
 * 
 * $Id$
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Mon Apr 17 12:28:40 1995
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Fri Apr 21 10:16:04 1995
 * description:
 * 
 * history:
 *   programming by NBC02365@niftyserve.or.jp
 */

#include "widget/widget.h"
#include "widget/local.h"
#include "widget/frame.h"


widget_t
frame_create (p)
     widget_t p;
{
  frame_packed (p) = resource_virtical;
  frame_align (p) = resource_align_begin;
  p->wrap = 1;
  return p;
}

void
frame_destroy (p)
     widget_t p;
{
}

#define xofs(t)   (_offsetof(struct widget_frame, t))

static struct configure frame_configspec[] =
{
  {resource_packed, datatype_char, xofs (packed), 0},
  {resource_align, datatype_char, xofs (align), 0},
  {0,},
};

void
frame_configure (item, resourceid, value)
     widget_t item;
     integer_t resourceid;
     void *value;
{
  configure_proc (item, frame_configspec, resourceid, value);
}

void
widget_3D (o)
     widget_t o;
{
#if X11
  GC gc1, gc4;
  switch (widget_relief (o))
    {
    case relief_sunken:
      break;
    case relief_flat:


      break;
    case relief_raised:
      break;
    case relief_none:
      break;
    }
#endif
}

void
frame_outline_draw (o)
     widget_t o;
{
  GC gc1, gc4;
  integer_t left, top;
  if (widget_border_width (o))
    {
      widget_abs_xy (o, 0, 0, &left, &top);
      gc1 = widget_active_darkGC (o),
	gc4 = widget_active_lightGC (o);

      _3D_XDraw3DFrame (widget_xdisplay (o),
			widget_drawable (o),
			left, top,
			widget_width (o),
			widget_height (o),
			widget_border_width (o),
			gc1,
			gc4);
    }
}

void
frame_display (o)
     widget_t o;
{
  integer_t left, top;
  GC gc1, gc4;

  widget_abs_xy (o, 0, 0, &left, &top);

  XFillRectangle (widget_xdisplay (o),
		  widget_drawable (o),
		  widget_active_GC (o),
		  left, top, widget_width (o), widget_height (o));

  if (widget_border_width (o))
    {
      gc1 = widget_active_darkGC (o),
      gc4 = widget_active_lightGC (o);

        _3D_XDraw3DFrame (widget_xdisplay (o),
			widget_drawable (o),
			left, top,
			widget_width (o),
			widget_height (o),
			widget_border_width (o),
			gc1,
			gc4);

#if 0
      if (widget_relief(o) == relief_frame) {
        _3D_XDraw3DFrame (widget_xdisplay (o),
			widget_drawable (o),
			left, top,
			widget_width (o),
			widget_height (o),
			widget_border_width (o),
			gc1,
			gc4);
      } else {
        _3D_XDrawFrame (widget_xdisplay (o),
			widget_drawable (o),
			left, top,
			widget_width (o),
			widget_height (o),
			widget_border_width (o),
			gc1,
			gc4);
      }
#endif
    }
/*  widget_3D(o); */
}

void
frame_action (p)
     widget_t p;
{
}

void
frame_invoke (p)
     widget_t p;
{
}




struct item_type item_type_frame =
{
  "frame",
  widget_type_frame,
  sizeof (struct widget_frame),
  frame_create,
  frame_destroy,
  frame_configure,
  frame_display,
  frame_action,
  frame_invoke,
  0,
};


void
widget_pack (o)
     widget_t o;
{
  integer_t height;
  integer_t width;
  widget_t child;
  frame_t w = (frame_t) o;
  widget_t np;
  integer_t border_width;
  if (!w)
    {
      return;
    }
  if (!w->packed)
    {
      return;
    }
  for (np = w->child; np; np = np->next)
    {
      widget_pack (np);
    }
  border_width = widget_border_width (o);
  height = border_width;
  width = border_width;
  switch (w->packed)
    {
    case resource_virtical:
      for (child = w->child; child; child = child->next)
	{
	  child->left = border_width;
	  child->top = height;
	  height += child->height;
	  if (width < (child->width + border_width))
	    {
	      width = (child->width + border_width);
	    }
	}
      break;
    case resource_horizontal:
      for (child = w->child; child; child = child->next)
	{
	  child->left = width;
	  child->top = border_width;
	  width += child->width;
	  if (height < (child->height + border_width))
	    {
	      height = (child->height + border_width);
	    }
	}
      break;
    default:
      abort ();
    }
  height += border_width;
  width += border_width;
  if (w->wrap)
    {
      w->height = height;
      w->width = width;
    }
}


void
widget_fix (o)
     widget_t o;
{
  widget_t np;
  integer_t l, t;

  widget_abs_xy (o, 0, 0, &l, &t);
  widget_abs_x (o) = l;
  widget_abs_y (o) = t;
  for (np = o->child; np; np = np->next)
    {
      widget_fix (np);
    }
  widget_fixed (o) = 1;
}


#include <stdio.h>

void
widget_print_geometry (o, indent)
     widget_t o;
     int indent;
{
  widget_t child;
  int i;

  for (i = 0; i < indent; i++)
    {
      fprintf (stdout, "  ");
    }
  fprintf (stdout, "#%x #%x %d %d %d %d %d %s\n", o, o->parent, o->left, o->top, o->width, o->height, o->packed, widget_type_string (o));

  for (child = o->child; child; child = child->next)
    {
      widget_print_geometry (child, indent + 1);
    }
  fflush (stdout);
}

void
pixmapframe_clear (p)
     widget_t p;
{
  ;
}

void
pixmapframe_free (p)
     widget_t p;
{
  ;
}
