#include "widget/widget.h"
#include "widget/local.h"
#include "widget/core.h"
#include "widget/button.h"
#include "widget/frame.h"
#include "widget/pixmapframe.h"
#include "widget/menu.h"
#include "widget/toplevel.h"
#include "widget/text.h"
#include "widget/pixmapcont.h"

#include "dev/gdev.h"

static item_type_t item_types;

static item_type_t
item_type_search_from_name (s)
     char *s;
{
  item_type_t t = item_types;

  for (; t; t = t->next)
    {
      if (!strcmp (t->name, s))
	{
	  break;
	}
    }
  if (!t)
    {
      abort ();
    }

  return t;
}

widget_t
widget_add_child (parent, child)
     widget_t parent, child;
{
  widget_t ch = parent->child;

  child->parent = parent;
  if (!ch)
    {
      parent->child = child;
      return 0;
    }
  while (ch->next)
    {
      ch = ch->next;
    }
  ch->next = child;
  return ch;
}



widget_t
widget_create (s, parent)
     char *s;
     widget_t parent;
{
  item_type_t t = item_type_search_from_name (s);
  widget_t w = (void *) xcalloc (t->size);
  extern gdev_t main_gdev;
  extern int white, black;

  w->dev = main_gdev;
  if (parent)
    {
      widget_add_child (parent, w);
    }
  {
    extern int darkgreen, yellowgreen, forestgreen, green;
    model_init (main_gdev, &w->active, darkgreen, forestgreen);
    model_init (main_gdev, &w->inactive, forestgreen, black);
  }
  w->type = t;
  (*(t->proc.create)) (w);
  return w;
}

void
_widget_configure (s, ac, av)
     widget_t s;
     int ac;
     char *av;
{
  (*(s->type->proc.configure)) (s, ac, av);
}


void
widget_invoke (s, arg)
     widget_t s;
     struct callbackarg *arg;
{
  (*(s->type->proc.invoke)) (s, arg);
}

void
widget_delete (w)
     widget_t w;
{
  widget_t parent;
  parent = w->parent;
  if (!w)
    return;

  if (parent->child == w)
    {
      parent->child = w->next;
    }
  else
    {
      widget_t ch;
      ch = parent->child;
      while (ch->next != w && ch)
	{
	  ch = ch->next;
	}
      if (ch == 0)
	{
	  return;
	}
      ch->next = w->next;
    }
}

void
widget_destory (o)
     widget_t o;
{
  widget_t q;
  for (q = o->child; q; q = q->next)
    {
      widget_destory (q);
    }
  (*(o->type->proc.destroy)) (o);
  widget_delete (o);
}


static void
item_type_init ()
{
  item_types = &item_type_button;
  item_type_button.next = &item_type_frame;
  item_type_frame.next = &item_type_toplevel;
  item_type_toplevel.next = &item_type_pixmapframe;
  item_type_pixmapframe.next = &item_type_text;
  item_type_text.next = &item_type_pmcontainer;
  item_type_pmcontainer.next = &item_type_core;
}

void
install_widget (p)
     struct item_type *p;
{
  p->next = item_types;
  item_types = p;
}

void
item_init ()
{
  item_type_init ();
}
