#include "widget/widget.h"
#include "widget/local.h"

#define MAX_INTENSITY 0xffff

static integer_t
rgb_trunc (i)
     integer_t i;
{
  if (i > MAX_INTENSITY)
    return MAX_INTENSITY;
  return i;
}

static void
_model_init (dev, m, mainfg, mainbg)
     gdev_t dev;
     model_t m;
     integer_t mainfg, mainbg;	/* pixel */
{
#if X11
  Display *display = dev->x11.g.display;
  Window win = dev->x11.g.window;
  Colormap colormap = dev->x11.colormap;
  int screen = dev->x11.screen;

  m->main.fg = mainfg;
  m->main.fgcolor.pixel = mainfg;
  XQueryColor (display, colormap, &m->main.fgcolor);

  m->main.bg = mainbg;
  m->main.bgcolor.pixel = mainbg;
  XQueryColor (display, colormap, &m->main.bgcolor);

  XSetBackground (display, m->main.gc, mainbg);
  XSetForeground (display, m->main.gc, mainfg);

  XSetBackground (display, m->sub.gc, mainbg);
  XSetForeground (display, m->sub.gc, BlackPixel (display, screen));

  m->light.fgcolor.red = rgb_trunc (14 * (int) m->main.fgcolor.red / 10);
  m->light.fgcolor.green = rgb_trunc (14 * (int) m->main.fgcolor.green / 10);
  m->light.fgcolor.blue = rgb_trunc (14 * (int) m->main.fgcolor.blue / 10);
  XAllocColor (display, colormap, &m->light.fgcolor);

  XSetBackground (display, m->light.gc, m->light.fgcolor.pixel);
  XSetForeground (display, m->light.gc, m->light.fgcolor.pixel);

  m->dark.fgcolor.red = 60 * (int) m->main.fgcolor.red / 100;
  m->dark.fgcolor.green = 60 * (int) m->main.fgcolor.green / 100;
  m->dark.fgcolor.blue = 60 * (int) m->main.fgcolor.blue / 100;
  XAllocColor (display, colormap, &m->dark.fgcolor);

  XSetBackground (display, m->dark.gc, m->dark.fgcolor.pixel);
  XSetForeground (display, m->dark.gc, m->dark.fgcolor.pixel);
#endif
}

void 
model_init (dev, m, mainfg, mainbg)
     gdev_t dev;
     model_t m;
     int mainfg;		/* pixel */
     int mainbg;		/* pixel */
{
#if X11
  Display *display = dev->x11.g.display;
  Window win = dev->x11.g.window;

  m->main.gc = XCreateGC (display, win, 0, 0);
  m->sub.gc = XCreateGC (display, win, 0, 0);
  m->light.gc = XCreateGC (display, win, 0, 0);
  m->dark.gc = XCreateGC (display, win, 0, 0);
  m->border_width = 0;
  m->relief = relief_raised;
#endif

  _model_init (dev, m, mainfg, mainbg);
}

void
model_change (gdev, m, mainfg, mainbg)
     gdev_t gdev;
     model_t m;
     int mainfg;
     int mainbg;
{
  _model_init (gdev, m, mainfg, mainbg);
}
