/*
 item type
 */
typedef struct item_type {
  char *name;
  integer_t type;
  integer_t size;
  struct {
    widget_t (*create)();
    void (*destroy)();
    void (*configure)();
    void (*display)();
    void (*action)();
    void (*invoke)();
  } proc;
  struct item_type *next;
  struct item_type *based;
} *item_type_t;

/*
 model
*/
enum relief_type {relief_none, relief_sunken, relief_raised, relief_flat, relief_frame };

typedef struct model {
#if X11
  struct {
    XColor fgcolor, bgcolor;
    int fg, bg;
    GC gc;
  } main, sub, dark, light;
#endif
  byte_t border_width;
  byte_t relief ;
} *model_t;

#define _offsetof(s, t)   (unsigned long)(&(((s *)0)->t))


typedef struct configure {
  integer_t resourceid;
  integer_t datatype;
  integer_t offset;
#if 0
  union {
    void *value;
    integer_t (*proc)();
  } u;
#endif
    void *value;
} * configure_t;

#define widget_type_menu        1
#define widget_type_frame       2
#define widget_type_menuitem    3
#define widget_type_button      4
#define widget_type_toplevel    5
#define widget_type_pixmapframe 6
#define widget_type_text        7
#define widget_type_pmcontainer 8
#define widget_type_core        100

#define widget_configure(a, b, c)  _widget_configure(a, b, (void *)(c))
