/*  -*- Mode: C -*- 
 * This file is part of my project
 * 
 * pixmapcont.c -- 
 * 
 * $Id$
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Thu Apr 13 19:48:50 1995
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Tue May  9 16:02:21 1995
 * description:
 *   pixmap container widget
 *   widget keeps several pixmaps to arrange and draw.
 * history:
 *   programming by NBC02365@niftyserve.or.jp
 */

#include "widget/widget.h"
#include "widget/local.h"
#include "widget/pixmapcont.h"

#define D(a)

widget_t
pmcontainer_create (p)
     widget_t p;
{
  pmcontainer_packdirect (p) = resource_horizontal;
  pmcontainer_content(p) = 0;
  pmcontainer_n_contents(p) = 0;
  widget_configure (p, resource_max_contents, 2);
  p->wrap = 0;
  return p;
}
void
pmcontainer_destroy (p)
     widget_t p;
{
}

#define xofs(t)   (_offsetof(struct widget_pmcontainer, t))

static struct configure pmcontainer_configspec[] =
{
  {resource_packdirect, datatype_char, xofs (packdirect), 0},
  {resource_margin, datatype_int, xofs (margin), 0},
  {resource_max_contents, datatype_int, xofs (max_contents), 0},
  {resource_pixmapstart, datatype_int, xofs (pixmapstart), 0},
  {0},
};

typedef struct content
  {
    integer_t width;
    integer_t height;
    integer_t ofs;
    integer_t color;
    gpixmap_t content;
    gpixmap_t mask;
    integer_t margin;
  }
 *content_t;

void
pmcontainer_configure (item, resourceid, value)
     widget_t item;
     integer_t resourceid;
     void *value;
{
  if (resourceid == resource_max_contents)
    {
      pmcontainer_t cp = (pmcontainer_t) item;
      integer_t size = ((integer_t) value) * sizeof (struct content);

      if (cp->content)
	{
	  cp->content = xrealloc (cp->content, size);
	}
      else
	{
	  cp->content = xcalloc (size);
	}
    }
  configure_proc (item, pmcontainer_configspec, resourceid, value);
}


void
pmcontainer_add_withofs (w, content, mask, color, paramofs)
     widget_t w;
     gpixmap_t content;
     gpixmap_t mask;
     integer_t paramofs;
{
  pmcontainer_t p;
  content_t val;
  integer_t width;
  integer_t height;
  integer_t ofs;

retry:
  p = (pmcontainer_t) w;
  val = p->content;
  if (!widget_pmcontainer_p (w))
    {
      abort ();
    }
  if (p->max_contents <= p->n_contents + 1)
    {
      widget_configure (w, resource_max_contents, p->max_contents * 2);
      goto retry;
    }
  if (!val)
    {
      widget_configure (w, resource_max_contents, 2);
    }

  gdev_drawable_get_geometry (w->dev, content, &width, &height);
  if (paramofs == -1)
    {
      if (p->n_contents == 0)
	{
	  ofs = pmcontainer_pixmapstart (w);
	}
      else
	{
	  integer_t margin = val[p->n_contents - 1].margin;
	  val = p->content;
	  if (pmcontainer_packdirect (p) == resource_horizontal)
	    {
	      ofs = val[p->n_contents - 1].ofs + val[p->n_contents - 1].width + margin;
	    }
	  else
	    {
	      ofs = val[p->n_contents - 1].ofs + val[p->n_contents - 1].height + margin;
	    }
	}
    }
  else
    {
      ofs = paramofs;
    }
  val = p->content;
  val[p->n_contents].content = content;
  val[p->n_contents].ofs = ofs;
  val[p->n_contents].width = width;
  val[p->n_contents].height = height;
  val[p->n_contents].color = color;
  val[p->n_contents].mask = mask;
  val[p->n_contents].margin = 0;
  p->n_contents++;
}

void
pmcontainer_add (w, content, mask, color)
     widget_t w;
     gpixmap_t content;
     gpixmap_t mask;
{
  pmcontainer_add_withofs (w, content, mask, color, -1);
}

void
pmcontainer_add_withmargin (w, content, mask, color, margin)
     widget_t w;
     gpixmap_t content;
     gpixmap_t mask;
     integer_t margin;
{
  integer_t ofs;
  pmcontainer_t p;
  content_t val;

  p = (pmcontainer_t) w;
  val = p->content;

  if (p->n_contents == 0) {
    ofs = 0;
  } else {
    ofs = val[p->n_contents - 1].ofs + val[p->n_contents - 1].width + margin;
  }
  pmcontainer_add_withofs (w, content, mask, color, ofs);
}

void
pmcontainer_set_margin (w, margin)
     widget_t w;
     integer_t margin;
{
  pmcontainer_t p;
  content_t val;

  p = (pmcontainer_t) w;
  val = p->content;
  if (p->n_contents == 0) { return; }
  val[p->n_contents - 1].margin = margin;
}


void
pmcontainer_clear (w)
     widget_t w;
{
  integer_t i;
  pmcontainer_t p;
  content_t val;

  p = (pmcontainer_t) w;
  val = p->content;
  if (!widget_pmcontainer_p (w))
    {
      abort ();
    }
#if 0
  for (i = 0; i < p->max_contents; i++)
    {
      val[i].content = 0;
      val[i].ofs = 0;
      val[i].width = 0;
      val[i].height = 0;
      val[i].color = 0;
      val[i].mask = 0;
      val[i].margin = 0;
    }
#else
  memset ((void *) val, 0, sizeof (struct content) * p->max_contents);
#endif
  p->n_contents = 0;
}

void
pmcontainer_clear_frame (o)
     widget_t o;
{
  integer_t left, top;
  pmcontainer_t p = (pmcontainer_t) o;

  pmcontainer_clear (o);

  widget_abs_xy (o, 0, 0, &left, &top);
  XFillRectangle (widget_xdisplay (o),
		  widget_drawable (o),
		  widget_active_GC (o),
		  left, top, widget_width (o), widget_height (o));
}

void
pmcontainer_display (o)
     widget_t o;
{
  integer_t left, top, orgleft, orgtop;

  if (!widget_pmcontainer_p (o))
    {
      abort ();
    }
  widget_abs_xy (o, 0, 0, &left, &top);

  XFillRectangle (widget_xdisplay (o),
		  widget_drawable (o),
		  widget_active_GC (o),
		  left, top, widget_width (o), widget_height (o));
  {
    GC gc1, gc4;

    if (widget_border_width (o))
      {
	gc1 = widget_active_darkGC (o),
	  gc4 = widget_active_lightGC (o);

	_3D_XDraw3DFrame (widget_xdisplay (o),
			  widget_drawable (o),
			  left, top,
			  widget_width (o),
			  widget_height (o),
			  widget_border_width (o),
			  gc1,
			  gc4);
      }
  }

#if X11
  widget_abs_xy (o, 0, 0, &orgleft, &orgtop);
  if (pmcontainer_packdirect (o) == resource_horizontal)
    {
      orgleft += pmcontainer_margin (o);
    }
  else
    {
      orgtop += pmcontainer_margin (o);
    }
  left = orgleft, top = orgtop;

  {
    integer_t i;
    pmcontainer_t cp = (pmcontainer_t) o;
    content_t p;
    for (i = 0; i < cp->n_contents; i++)
      {
	content_t np;
	np = cp->content;
	p = &np[i];

	if (pmcontainer_packdirect (o) == resource_horizontal)
	  {
	    left = orgleft + p->ofs;
	  }
	else
	  {
	    top = orgtop + p->ofs;
	  }
	if (p->mask)
	  {
	    gdev_draw_render (o->dev, p->content, p->mask,
			      0, 0,
			      widget_width (o),
			      widget_height (o),
			      left, top);
	  }
	else
	  {
	    if (p->color)
	      {
		XCopyArea (widget_xdisplay (o),
			   p->content,
			   widget_drawable (o),
			   widget_active_GC (o),
			   0, 0,
			   widget_width (o),
			   widget_height (o), left, top);
	      }
	    else
	      {
		XCopyPlane (widget_xdisplay (o),
			    p->content,
			    widget_drawable (o),
			    widget_inactive_GC (o),
			    0, 0,
			    widget_width (o),
			    widget_height (o), left, top, 1);
	      }
	  }
      }
  }
#endif
  D (widget_sync (o));
}
void
pmcontainer_action (p)
     widget_t p;
{
}
void
pmcontainer_invoke (p, arg)
     widget_t p;
     struct callbackarg *arg;

{
  widget_call_callback (p, resource_buttonpress_callback, arg);
  widget_sync (p);
}




struct item_type item_type_pmcontainer =
{
  "pmcontainer",
  widget_type_pmcontainer,
  sizeof (struct widget_pmcontainer),
  pmcontainer_create,
  pmcontainer_destroy,
  pmcontainer_configure,
  pmcontainer_display,
  pmcontainer_action,
  pmcontainer_invoke,
  0,
};
