#include "widget/widget.h"
#include "widget/local.h"
#include "widget/pixmapframe.h"


typedef struct pixmaplist
{
  struct pixmaplist *next;
  integer_t width, height;
  integer_t ofs;
  gpixmap_t pixmap;
  integer_t color;
}
 *pixmaplist_t;

widget_t 
pixmapframe_create (p)
     widget_t p;
{
  pixmapframe_pixmappacked (p) = resource_horizontal;
  p->wrap = 1;
  return p;
}

void 
pixmapframe_destroy (p)
     widget_t p;
{
  pixmaplist_t q = (pixmaplist_t) (((pixmapframe_t)(p))->pixmaps), org;
  while (q)
    {
      org = q;
      q = q->next;
      xfree((void *)org);
    }
  xfree((void *)p);
}

#define xofs(t)   (_offsetof(struct widget_pixmapframe, t))

static struct configure pixmapframe_configspec[] =
{
  {resource_contentpacked, datatype_char, xofs (pixmappacked), 0},
  {resource_pixmapstart, datatype_int, xofs (pixmapstart), 0},
  {0},
};

void 
pixmapframe_configure (item, resourceid, value)
     widget_t item;
     integer_t resourceid;
     void *value;
{
  configure_proc (item, pixmapframe_configspec, resourceid, value);
}


static struct pixmaplist *
pixmaplist_new ()
{
  return (struct pixmaplist *) xcalloc (sizeof (struct pixmaplist));
}

static void
pixmaplist_add (w, pixmaplist)
     widget_t w;
     struct pixmaplist *pixmaplist;
{
  pixmapframe_t p = (pixmapframe_t) w;
  integer_t width = 0;
  integer_t height = 0;
  pixmaplist_t q, last = 0;

  if (!widget_pixmapframe_p ((widget_t) p))
    {
      abort ();
    }
  q = (pixmaplist_t) p->pixmaps;
  while (q)
    {
      width += q->width;
      height += q->height;
      last = q;
      q = q->next;
    }
  if (last)
    {
      last->next = pixmaplist;
      if (pixmapframe_pixmappacked (p) == resource_horizontal)
	{
	  pixmaplist->ofs = width;
	}
      else
	{
	  pixmaplist->ofs = height;
	}
    }
  else
    {
      p->pixmaps = pixmaplist;
    }
}
void
pixmapframe_add_pixmap (w, pixmap, color)
     widget_t w;
     gpixmap_t pixmap;
{
  struct pixmaplist *p = pixmaplist_new ();
  if (!widget_pixmapframe_p (w))
    {
      abort ();
    }

  gdev_drawable_get_geometry (w->dev, pixmap, &p->width, &p->height);
  p->pixmap = pixmap;
  p->color = color;
  pixmaplist_add (w, p);
}
void
pixmapframe_display (o)
     widget_t o;
{
  integer_t left, top, orgleft, orgtop;
  struct pixmaplist *p = ((struct widget_pixmapframe *) o)->pixmaps;

  {
    GC gc1, gc4;

    if (widget_border_width (o))
      {
	widget_abs_xy (o, 0, 0, &left, &top);
	gc1 = widget_active_darkGC (o),
	  gc4 = widget_active_lightGC (o);

	_3D_XDraw3DFrame (widget_xdisplay (o),
			  widget_drawable (o),
			  left, top,
			  widget_width (o),
			  widget_height (o),
			  widget_border_width (o),
			  gc1,
			  gc4);
      }
  }

#if X11
  widget_abs_xy (o, 0, 0, &orgleft, &orgtop);
  if (pixmapframe_pixmappacked (o) == resource_horizontal)
    {
      orgleft += pixmapframe_pixmapstart (o);
    }
  else
    {
      orgtop += pixmapframe_pixmapstart (o);
    }
  left = orgleft, top = orgtop;
  while (p)
    {
      if (pixmapframe_pixmappacked (o) == resource_horizontal)
	{
	  left = orgleft + p->ofs;
	}
      else
	{
	  top = orgtop + p->ofs;
	}
      if (p->color)
	{
	  XCopyArea (widget_xdisplay (o),
		     p->pixmap,
		     widget_drawable (o),
		     widget_active_GC (o),
		     0, 0,
		     widget_width (o),
		     widget_height (o), left, top);
	}
      else
	{
	  XCopyPlane (widget_xdisplay (o),
		      p->pixmap,
		      widget_drawable (o),
		      widget_active_GC (o),
		      0, 0,
		      widget_width (o),
		      widget_height (o), left, top, 1);
	}
      p = p->next;
    }
#endif
}
void
pixmapframe_action (p)
     widget_t p;
{
}
void
pixmapframe_invoke (p)
     widget_t p;
{
}




struct item_type item_type_pixmapframe =
{
  "pixmapframe",
  widget_type_pixmapframe,
  sizeof (struct widget_pixmapframe),
  pixmapframe_create,
  pixmapframe_destroy,
  pixmapframe_configure,
  pixmapframe_display,
  pixmapframe_action,
  pixmapframe_invoke,
  0,
};
