#include "widget/widget.h"
#include "widget/local.h"
#include "widget/text.h"

#define text_text(p)  ((struct widget_text *)p)->text
#define text_length(p)  ((struct widget_text *)p)->length
#define text_pixmap(p)  ((struct widget_text *)p)->pixmap
#define text_color(p)     ((struct widget_text *)p)->textcolor
#define text_font(p)     ((struct widget_text *)p)->textfont
#define text_shadow_p(p)        ((struct widget_text *)p)->textshadow

widget_t
text_create (p)
     widget_t p;
{
  widget_set_geometry (p, 32, 50);
  return p;
}
void
text_destroy (o)
     widget_t o;
{
}

#define xofs(t)   (_offsetof(struct widget_text, t))

static struct configure text_configspec[] =
{
  {resource_text, datatype_string, xofs (text), 0},
  {resource_textcolor, datatype_int, xofs (textcolor), 0},
  {resource_textfont, datatype_int, xofs (textfont), 0},
  {resource_textshadow, datatype_char, xofs (textshadow), 0},
  {0,},
};
void
text_configure (item, resourceid, value)
     widget_t item;
     integer_t resourceid;
     void *value;
{
  if (resourceid == resource_text)
    {
      char *s = value;
      if (!text_text (item))
	{
	  text_text (item) = xmalloc (strlen (s) + 1);
	  text_length (item) = strlen (s);
	}
      else
	{
	  if (text_length (item) <= strlen (s))
	    {
	      text_text (item) = xrealloc (text_text (item), strlen (s) + 1);
	      text_length (item) = strlen (s);
	    }
	}
      strcpy (text_text (item), s);
      return;
    }
  configure_proc (item, text_configspec, resourceid, value);
}

void
text_display (o)
     widget_t o;
{
#if X11
  extern gdev_t main_gdev;
  integer_t left, top;
  widget_abs_xy (o, 0, 0, &left, &top);

  XFillRectangle (widget_xdisplay (o),
		  widget_drawable (o),
		  widget_active_GC (o),
		  left, top, widget_width (o), widget_height (o));

  if (text_text (o))
    {
      integer_t borderwidth;

/*  gdev_cleararea(o->dev, left, top, widget_width(o), widget_height(o)); */

      borderwidth = widget_border_width (o);
#if 1
      if (text_shadow_p (o))
	{
	  gdev_drawshadowtext (main_gdev, 0,
			       left + borderwidth, top + borderwidth,
			       text_color (o), text_font(o), text_text (o));
	}
      else
	{
	  gdev_drawtext (main_gdev, 0, 
			 left + borderwidth, top + borderwidth,
			 text_color (o), text_font(o), text_text (o));
	}
#else
      XDrawImageString (widget_xdisplay (o),
			widget_drawable (o),
			widget_active_subGC (o),
			left + borderwidth,	/* border_width,   */
			top + borderwidth,	/*border_width+20, */
			text_text (o), strlen (text_text (o)));
#endif
    }
#endif
}
void
text_action (o)
     void *o;
{
}
void
text_invoke (o, arg)
     widget_t o;
     struct callbackarg *arg;
{
  widget_call_callback (o, resource_buttonpress_callback, arg);
}



struct item_type item_type_text =
{
  "text",
  widget_type_text,
  sizeof (struct widget_text),
  text_create,
  text_destroy,
  text_configure,
  text_display,
  text_action,
  text_invoke,
  0,
};
