/*  -*- Mode: C -*- 
 * This file is part of my project
 * 
 * widget.c -- 
 * 
 * $Id$
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Tue Apr 11 10:59:57 1995
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Wed Apr 26 10:31:08 1995
 * description:
 * 
 * history:
 */

#include "widget/widget.h"
#include "widget/local.h"


integer_t widget_call_callback ();

static widget_t root_widget;


void
widget_display (w)
     widget_t w;
{
  widget_t child;

  if (!w)
    return;
  if (!w->map)
    return;

  (*(w->type->proc.display)) (w);

  for (child = w->child; child; child = child->next)
    {
      widget_display (child);
    }
}

#include "widget.h"
static widget_t grabed;
widget_grab (w)
     widget_t w;
{
  grabed = w;
}
widget_ungrab ()
{
  grabed = 0;
}

static void (*button1_hook_f) ();
static void (*button2_hook_f) ();
static void (*button3_hook_f) ();
void 
widget_define_button_hook (number, hook)
     integer_t number;
     void (*hook) ();
{
  switch (number)
    {
    case 1:
      button1_hook_f = hook;
      break;
    case 2:
      button2_hook_f = hook;
      break;
    case 3:
      button3_hook_f = hook;
      break;
    }
}

widget_t
widget_pointed (parent, x, y, px, py)
     widget_t parent;
     integer_t *px, *py;
{
  widget_t child = parent->child;
  integer_t xx, yy, width, height;

  if (grabed)
    {
      return grabed;
    }
  for (; child; child = child->next)
    {
      if (!child->map)
	{
	  continue;
	}
      width = child->width;
      height = child->height;

      if ((child->left <= x && child->left + width >= x)
	  && (child->top <= y && child->top + height >= y))
	{
	  ;
	}
      else
	{
	  continue;
	}
      xx = x - child->left;
      yy = y - child->top;
      if (child->child)
	{
	  widget_t p;
	  integer_t ppx, ppy;

	  p = widget_pointed (child, xx, yy, &ppx, &ppy);
	  if (p)
	    {
	      *px = ppx, *py = ppy;
	      return p;
	    }
	}
      *px = xx, *py = yy;
      return child;
    }
  return 0;
}

void
widget_map (parent)
     widget_t parent;
{
  widget_t child;
  parent->map = 1;
  child = parent->child;
  while (child)
    {
      widget_map (child);
      child = child->next;
    }
}

void
widget_unmap (parent)
     widget_t parent;
{
  widget_t child;
  parent->map = 0;
  child = parent->child;
  while (child)
    {
      widget_unmap (child);
      child = child->next;
    }
}

void
widget_xunmap (parent)
     widget_t parent;
{
  widget_t child;
  widget_t pp = parent->parent;
  widget_unmap(parent);
  if (pp)
    {
      widget_display (pp);
    }
}




int green3;

static void
color_init ()
{
  green3 = colornametopixel ("green3");
}

widget_t
widget_init (w, h)
     integer_t w, h;
{
  gdev_init (w, h);
  item_init ();
  color_init ();
  root_widget = widget_create ("toplevel", 0);
  {
    widget_set_geometry (root_widget, root_widget->dev->x11.g.width, root_widget->dev->x11.g.height);
  }
  return root_widget;
}

void
_widget_handle_event ()
{
  widget_t w;
  extern gdev_t main_gdev;
  struct callbackarg carg;
  integer_t x, y;
#if X11
  XEvent xevent;

  XNextEvent (main_gdev->x11.g.display, &xevent);
  switch (xevent.type)
    {
    default:
      return;
    case Expose:
/*      widget_display (root_widget); */
      widget_flush (root_widget);
      break;
    case ButtonPress:
      switch (xevent.xbutton.button)
	{
	case 1:
	  if (button1_hook_f)
	    {
	      (*button1_hook_f) ();
	    }
	  w = widget_pointed (root_widget,
			      xevent.xbutton.x, xevent.xbutton.y,
			      &x, &y);
	  if (w)
	    {
	      carg.e.x = xevent.xbutton.x;
	      carg.e.y = xevent.xbutton.y;
	      carg.x = x;
	      carg.y = y;
	      widget_invoke (w, &carg);
	    }
	  break;
	case 2:
	  if (button2_hook_f)
	    {
	      (*button3_hook_f) ();
	    }
	  break;
	case 3:
	  if (button3_hook_f)
	    {
	      (*button3_hook_f) ();
	    } else {
	      bind_call (resource_button3press_callback);
	    }
	  break;
	default:
	  break;
	}			/* which button */
      break;
    case ButtonRelease:
      w = widget_pointed (root_widget,
			  xevent.xbutton.x, xevent.xbutton.y,
			  &x, &y);
      if (w)
	{
	  carg.e.x = xevent.xbutton.x;
	  carg.e.y = xevent.xbutton.y;
	  carg.x = x;
	  carg.y = y;
	  widget_call_callback (w, resource_buttonrelease_callback, &carg);
	}
      break;
    case KeyPress:
      w = widget_pointed (root_widget,
			  xevent.xbutton.x, xevent.xbutton.y,
			  &x, &y);
      if (w)
	{
	  char buffer[64];
	  int nkey;
	  KeySym mykey;
	  carg.e.x = xevent.xbutton.x;
	  carg.e.y = xevent.xbutton.y;
	  carg.x = x;
	  carg.y = y;
	  nkey = XLookupString ((void *) &xevent, buffer, 64, &mykey, 0);
	  if (nkey != 0)
	    {
	      carg.cchar = buffer[0];
	      widget_call_callback (w, resource_keypress_callback, &carg);
	    }
	}
      break;
    }
  XFlush (main_gdev->x11.g.display);
#endif
}

void
widget_event_discard (w)
     widget_t w;
{
  gdev_sync (w->dev, 1);
}

integer_t
widget_eventsqueued (w)
     widget_t w;
{
  return gdev_have_event (w->dev);
}

void
widget_event_loop ()
{
  for (;;)
    {
      _widget_handle_event ();
    }
}


typedef struct callbackproc
{
  struct callbackproc *next;
  integer_t type;
    integer_t (*func) ();
  void *arg;
}
 *callbackproc_t;


static callbackproc_t
create_callbackproc ()
{
  return (callbackproc_t) xcalloc (sizeof (struct callbackproc));
}

void
_widget_add_callback (widget, resource, func, arg)
     widget_t widget;
     integer_t resource;
integer_t (*func) ();
     void *arg;
{
  callbackproc_t list = widget->callbackproc;
  callbackproc_t p = create_callbackproc ();
  switch (resource)
    {
    case resource_buttonpress_callback:
    case resource_motion_callback:
    case resource_buttonrelease_callback:
    case resource_keypress_callback:
      break;
    default:
      error ("add callback: unknown resource");
    }
  p->func = func;
  p->type = resource;
  p->arg = arg;
  p->next = list;
  widget->callbackproc = p;
}


integer_t
widget_call_callback (widget, resource, callbackarg)
     widget_t widget;
     integer_t resource;
     void *callbackarg;
{
  callbackproc_t list;

next:
  list = widget->callbackproc;
  while (list)
    {
      if (list->type == resource)
	{
	  return (*(list->func)) (widget, list->arg, callbackarg);
	}
      list = list->next;
    }
  if (widget->transparent)
    {
      widget = widget->parent;
      if (!widget)
	{
	  return 0;
	}
      goto next;
    }
}

void
widget_flush (o)
     widget_t o;
{
  integer_t left, top;

  widget_abs_xy (o, 0, 0, &left, &top);
  gdev_flush_area (o->dev, left, top,
		   widget_width (o), widget_height (o));
}

void
widget_sync (o)
     widget_t o;
{
  gdev_sync (o->dev, 0);
}

void
widget_set_geometry (w, width, height)
     widget_t w;
     integer_t width, height;
{
  w->width = width;
  w->height = height;
}
void
widget_get_geometry (w, width, height)
     widget_t w;
     integer_t *width, *height;
{
  *width = w->width;
  *height = w->height;
}


void
wigdet_set_pack_pixmap (item, pixmap)
     widget_t item;
     gpixmap_t pixmap;
{
  integer_t x, y;

  widget_configure (item, resource_pixmap, pixmap);
  gdev_drawable_get_geometry (item->dev, pixmap, &x, &y);
  widget_set_geometry (item, x, y);

  widget_pack (item->parent);
}


void
widget_abs_xy (o, x, y, l, t)
     widget_t o;
     integer_t x, y;
     integer_t *l, *t;
{
  widget_t parent;
  integer_t val1;
  integer_t val2;

  if (widget_fixed (o))
    {
      *l = widget_abs_x (o);
      *t = widget_abs_y (o);
      return;
    }
  parent = o->parent;
  val1 = o->left;
  val2 = o->top;
  while (parent)
    {
      val1 += parent->left;
      val2 += parent->top;
      parent = parent->parent;
    }
  *l = val1 + x;
  *t = val2 + y;
}



void
widget_sleep (w)
{
  sleep (1);
}

void
widget_set_color_change (w, fg, bg, inactivefg, inactivebg)
     widget_t w;
{
  model_change (w->dev, &w->active, fg, bg);
  model_change (w->dev, &w->inactive, inactivefg, inactivebg);
}

void 
widget_set_background (w, pixmap)
     widget_t w;
{
  gdev_set_background (w->dev, pixmap);
}

void widget_dev_map(w)
widget_t w;
{
  gdev_map (w->dev);
}
