#ifndef _WIDGET_H
#define _WIDGET_H
#include "include/deftype.h"
#include "dev/gdev.h"

#ifdef __STDC__
#define identcat(a,b)   a##b
#define identstr(a)     #a
#else
#define identcat(a,b)   a/**/b
#define identstr(a)     "a"
#endif

typedef struct widget *widget_t;
#include "itemtype.h"

struct widget {
#define _base_widget_body \
  item_type_t type;\
  gdev_t dev;\
  char *name;\
  integer_t left, top, width, height; \
  struct {byte_t fixed; integer_t left, top; } abs;\
  byte_t map; \
  byte_t packed; \
  byte_t border_width; \
  byte_t wrap;\
  byte_t transparent;\
  void *callbackproc;\
  struct model active;\
  struct model inactive;\
  struct widget * parent; \
  struct widget * child; \
  struct widget * next

  _base_widget_body ;
};

#include <varargs.h>

#include "resource.h"

#include "event.h"

#include "funcdecl.h"

#include "widgetdecl.h"
#include "../util/util.h"
#endif
