/*  -*- Mode: C -*- 
 * This file is part of my project
 * 
 * xmalloc.c -- 
 * 
 * $Id$
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Tue May  9 00:48:25 1995
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Tue May  9 00:48:26 1995
 * description:
 * 
 * history:
 *   programming by NBC02365@niftyserve.or.jp
 */

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <assert.h>
#include "nu.h"

char *
xmalloc (size)
     register unsigned long size;
{
  register char *p;

  if (size == 0)
    {
      return NULL;
    }
  p = (char *) malloc ((size_t) size);
  if (p == NULL)
    {
      exit (2);
    }
  return p;
}

char *
xcalloc (size)
     register unsigned long size;
{
  register char *p;

  if (size == 0)
    {
      return NULL;
    }
  p = (char *) malloc ((size_t) size);
  if (p == NULL)
    {
      exit (2);
    }
  memset (p, 0, size);
  return p;
}

char *
xrealloc (p, size)
     register char *p;
     register unsigned long size;
{
  register char *destp;

  if (size == 0)
    {
      return NULL;
    }
  destp = (char *) realloc ((char *) p, (size_t) size);
  if (destp == NULL)
    {
      exit (2);
    }
  return destp;
}

void
xfree (p)
     char *p;
{
  free (p);
}
