/*  -*- Mode: C -*- 
 * This file is part of my project
 * 
 * error.c -- 
 * 
 * $Id$
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Mon Apr 17 12:28:16 1995
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Fri Apr 28 16:23:36 1995
 * description:
 * 
 * history:
 *   programming by NBC02365@niftyserve.or.jp
 */

#include <stdio.h>
#include <stdarg.h>

typedef long integer_t;

#define cmdname "xnetmaj"

#if MSDOS
#define LD  "%ld"
#define LO  "%lo"
#define LU  "%lu"
#define LX  "%lx"
#else
#define LD  "%d"
#define LO  "%o"
#define LU  "%u"
#define LX  "%x"
#endif

static FILE *outfp = stderr;

static char *
message (msg, argp)
     char *msg;
     va_list *argp;
{
  va_list args = *argp;
  char *start;

  for (;;)
    {
      if (*msg == '\0')
	{
	  break;
	}
      else if (*msg == '%')
	{
	  msg++;
	  switch (*msg)
	    {
	    case 's':
	      fprintf (outfp, "%s", va_arg (args, char *));
	      break;
	    case 'd':
	      fprintf (outfp, LD, va_arg (args, integer_t));
	      break;
	    case 'u':
	      fprintf (outfp, LU, va_arg (args, integer_t));
	      break;
	    case 'o':
	      fprintf (outfp, LO, va_arg (args, integer_t));
	      break;
	    case 'x':
	      fprintf (outfp, LX, va_arg (args, integer_t));
	      break;
	    case '%':
	      fprintf (outfp, "%%");
	      break;
	    default:
	      fprintf (outfp, "unknown fmt char 0x%x\n", *msg);
	      break;
	    }
	  msg++;
	}
      else
	{
	  start = msg;
	  for (;;)
	    {
	      switch (*msg)
		{
		case '\0':
		  goto break1;
		case '%':
		  goto break1;
		}
	      msg++;
	    }
	break1:
	  fwrite (start, 1, msg - start, outfp);
	}
    }				/* for */
}


#if VARARGS
#define def_msg_func(funcname, string, done) \
void funcname(va_alist)\
     va_dcl\
{\
  va_list args;\
  char *msg;\
  fprintf(outfp, "%s:%s: ", cmdname, string);\
  va_start (args);\
  msg = va_arg (args, char *);\
  message(msg, &args);\
  va_end(args);\
  fprintf(outfp, "\n"); done;\
}

def_msg_func (error, "error", 0);
def_msg_func (warning, "warning", 0);
def_msg_func (fatal, "fatal", exit (1));

#else
#define def_msg_func(funcname, string, done) \
void funcname(char *msg, ...)\
{\
  va_list args;\
  fprintf(outfp, "%s:%s: ", cmdname, string);\
  va_start (args, msg);\
  message(msg, &args);\
  va_end(args);\
  fprintf(outfp, "\n"); done;\
}

def_msg_func (error, "error", 0);
def_msg_func (warning, "warning", 0);
def_msg_func (fatal, "fatal", exit (1));


#endif
