/*  -*- Mode: C -*- 
 * This file is part of my project
 * 
 * xmalloc.c -- 
 * 
 * $Id$
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Mon Apr 17 12:28:20 1995
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Thu Apr 20 10:24:44 1995
 * description:
 * 
 * history:
 *   programming by NBC02365@niftyserve.or.jp
 */

#include <stdio.h>
#include <stddef.h>

typedef size_t _size_t;

char *
xmalloc (size)
     register _size_t size;
{
  register char *p;

  if (size == 0)
    {
      return NULL;
    }

  p = (char *) malloc ((size_t) size);
  if (p == NULL)
    {
      abort ();
    }
  return p;
}

char *
xcalloc (size)
     register _size_t size;
{
  register char *p;

  if (size == 0)
    {
      size = 4;
    }
  p = (char *) malloc ((size_t) size);
  if (p == NULL)
    {
      abort ();
    }
  memset (p, 0, size);
  return p;
}

char *
xrealloc (p, size)
     register char *p;
     register _size_t size;
{
  register char *destp;

  if (size == 0)
    {
      return p;
    }
  destp = (char *) realloc ((char *) p, (size_t) size);
  if (destp == NULL)
    {
      abort ();
    }
  return destp;
}

void
xfree (p)
     char *p;
{
  free (p);
}
