/*  -*- Mode: C -*- 
 * This file is part of my project
 * 
 * about.c -- 
 * 
 * $Id$
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Thu May 11 10:27:04 1995
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Thu Jun  8 20:37:00 1995
 * description:
 * 
 * history:
 *   programming by NBC02365@niftyserve.or.jp
 */
#include "xnet.h"
#include "pixread.h"
#include "xnetmaj.h"

static widget_t about;

extern void testpai_callback();

static char *history[] = {
  "         version 1.0 beta2 7/6/1995 first distribution",
/*  "         version 1.0       7/7/1995", */
  0,
};

void
about_init ()
{
  widget_t framepoint, frames[5], canvas;
  integer_t x, y;
  extern integer_t xwidth, xheight;
  extern int yellow;
  char **p;

  framepoint = create_basic_info_frame ("frame", about, frames, PAI_W * 18,
					1, 1);
  {
    widget_t testbutton;
    testbutton = widget_create ("button", frames[4]); 
    widget_set_geometry (testbutton, BUTTON_W, BUTTON_H);
    widget_configure (testbutton, resource_text, "pai test");
    widget_configure (testbutton, resource_textcolor, yellow);
    widget_configure (testbutton, resource_textfont, TIMESI);
    widget_add_callback (testbutton,
			 resource_buttonpress_callback,
			 (void *) testpai_callback, "");
    testpai_init();
  }


  widget_get_geometry(framepoint, &x, &y);


#define aboutinfo(string, font) \
  canvas = widget_create("text", framepoint); \
  widget_set_geometry (canvas, xwidth, 32);\
  widget_configure(canvas, resource_textfont, font);\
  widget_configure(canvas, resource_text, string);

  aboutinfo("xnetmaj (from Japan)", LUCIDAB);
  for (p = history; *p; p++) {
    aboutinfo(*p, TIMESI);
  }
  aboutinfo("", HELVB);
  aboutinfo("xnetmaj: A2N computer entertainment", HELVB);
  aboutinfo("         Mail to NBC02365@niftyserve.or.jp", TIMESI);
  aboutinfo("", HELVB);
  aboutinfo("netmaj: suz@d2.bs1.fc.nec.co.jp", HELVB);
  aboutinfo("libss: Mat Watson and Hubert Bartels", HELVB);

  widget_pack (about);
  widget_fix (about);

  widget_set_geometry (about, xwidth, xheight);
}


void make_about()
{
  extern widget_t root_widget;
  extern integer_t xwidth, xheight;

  about = widget_create ("frame", root_widget);
  widget_configure (about, resource_name, "about");
  widget_set_geometry (about, xwidth, xheight);
  widget_add_callback (about,
		       resource_keypress_callback,
		       (void *) keywait_callback, "");
  widget_add_callback (about,
		       resource_buttonpress_callback,
		       (void *) keywait_callback, "");
  about_init ();
}

void about_callback  callbackarg_param
{
  extern widget_t board;

  widget_unmap (board);
  widget_map (about);
  widget_display (about);
  widget_flush (about);
  wait_key ();
  widget_unmap (about);

  board_redraw();
}
