/*  -*- Mode: C -*- 
 * This file is part of xnetmaj
 * 
 * xnet.c -- 
 * 
 * $Id: board.c,v 1.1 1995/04/23 01:32:45 ksr Exp ksr $
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Tue Apr 11 11:14:04 1995
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Thu Jun  8 20:13:17 1995
 * description:
 *   create and definition of main game board
 * history:
 *   programming by NBC02365@niftyserve.or.jp
 */

/*
   netmaj: unofficial front end (graphical interface version)
 */

#define XNET 1
#include "xnet.h"

static widget_t root;
integer_t xheight = 480;
integer_t xwidth = 640;

integer_t flag_enable_select = 0;
integer_t flag_enable_onboard = 0;
integer_t flag_effect = 0;
integer_t n_select;
integer_t choiced;


integer_t iam;

static void select_pai_callback callbackarg_param
{
  integer_t idx = val;
  integer_t x, y, n;
  if (!flag_enable_select)
    {
      return;
    }
  if (!(idx == 5 || idx == iam))
    {				/* 5 means this func is called from choice */
      return;
    }
  if (idx != 5 && !flag_enable_onboard)
    {
      return;
    }
  x = (arg->x - HANDPAISTART);	/* get clicked pos */
  y = arg->y;
  n = x / PAI_W;
  if (n_select != 0 && n == n_select)
    {
      n = (x - HANDPAIMARGIN) / PAI_W;	/* choice widen */
    }
  if (!(0 <= n && n < n_select))
    {
      return;			/* do nothing */
    }
  flag_enable_select = 0;
  flag_enable_onboard = 0;
  choiced = n;
  flag_effect = 1;
}

void
board_button3press_callback ()
{
  if (flag_enable_select
      && flag_enable_onboard)
    {
/* tumogiri: call from choice (mode, not res mode) */
/* n_select is n pais; tumo is always (n_select - 1) */
      choiced = n_select - 1;
    }
  else
    {
      choiced = X_CANCEL;
    }
  flag_enable_select = 0;
  flag_enable_onboard = 0;
  flag_effect = 1;

}

static void cancel_button_callback callbackarg_param
{
  extern integer_t   waitkey_flag ;
  waitkey_flag = 1;
  flag_enable_select = 0;
  flag_effect = 1;
  choiced = X_CANCEL;
}

static void tie_button_callback callbackarg_param
{
  flag_effect = 1;
  choiced = X_TIE;
}

static void pon_button_callback callbackarg_param
{
  flag_effect = 1;
  choiced = X_PON;
}

static void kan_button_callback callbackarg_param
{
  flag_effect = 1;
  choiced = X_KAN;
}

static void ron_button_callback callbackarg_param
{
  flag_effect = 1;
  choiced = X_RON;
}

static void tumo_button_callback callbackarg_param
{
  flag_effect = 1;
  choiced = X_TUMO;
}

static void reach_button_callback callbackarg_param
{
  flag_effect = 1;
  choiced = X_REACH;
}

extern void restart_callback ();
extern void flush_callback ();
extern void speed_callback ();
extern void one_callback ();
extern void auto_callback ();
extern void autoplay_callback ();
extern void auto_after_reach_callback ();
extern void visible_callback ();
extern void about_callback ();

void quit_callback callbackarg_param
{
  extern global_t *game_global;
  do_disconnect(game_global);
  term ();
}

void
get_choice ()
{
  flag_effect = 0;
  for (; flag_effect == 0;)
    {
      _widget_handle_event ();
    }
}


widget_t board;

void
board_sync ()
{
  widget_sync (board);
}

void
board_flush_sfx ()
{
  static int i = 0;
  if ( i++ % 2 ) {
    widget_flush_sfx_blind(board, 20, 20);
  } else {
    widget_flush_sfx_shatter(board, 10, 10);
  }
  widget_sync (board);
}


void
board_flush ()
{

  widget_flush(board);
  widget_sync (board);
}

void
board_button_flush()
{
  widget_flush(action);
  widget_sync(board);
}

void
board_display ()
{
  widget_display (board);
}

extern widget_t root_widget;

static void 
build_status (status1)
     widget_t status1;
{

  one_button = widget_create ("button", status1);
  visible_button = widget_create ("button", status1);
  speed_button = widget_create ("button", status1);
  autoplay_button = widget_create ("button", status1);
  auto_after_reach_button = widget_create ("button", status1);
  flush_button = widget_create ("button", status1);
  restart_button = widget_create ("button", status1);
  auto_button = widget_create ("button", status1);
  about_button = widget_create ("button", status1);
  quit_button = widget_create ("button", status1);

  widget_set_geometry (speed_button, MBUTTON_W, MBUTTON_H);
  widget_set_geometry (visible_button, MBUTTON_W, MBUTTON_H);
  widget_set_geometry (autoplay_button, MBUTTON_W, MBUTTON_H);
  widget_set_geometry (auto_after_reach_button, MBUTTON_W, MBUTTON_H);
  widget_set_geometry (flush_button, MBUTTON_W, MBUTTON_H);
  widget_set_geometry (restart_button, MBUTTON_W, MBUTTON_H);
  widget_set_geometry (one_button, MBUTTON_W, MBUTTON_H);
  widget_set_geometry (auto_button, MBUTTON_W, MBUTTON_H);
  widget_set_geometry (about_button, MBUTTON_W, MBUTTON_H);
  widget_set_geometry (quit_button, MBUTTON_W, MBUTTON_H);

  widget_configure (speed_button, resource_text, "speed");
  widget_configure (visible_button, resource_text, "visible");
  widget_configure (autoplay_button, resource_text, "autoplay");
  widget_configure (auto_after_reach_button, resource_text, "auto(R)");
  widget_configure (flush_button, resource_text, "flush");
  widget_configure (restart_button, resource_text, "restart");
  widget_configure (one_button, resource_text, "solitaire");
  widget_configure (auto_button, resource_text, "run auto");
  widget_configure (about_button, resource_text, "about");
  widget_configure (quit_button, resource_text, "quit");

  widget_configure (speed_button, resource_textfont, TIMESI);
  widget_configure (visible_button, resource_textfont, TIMESI);
  widget_configure (autoplay_button, resource_textfont, TIMESI);
  widget_configure (auto_after_reach_button, resource_textfont, TIMESI);
  widget_configure (flush_button, resource_textfont, TIMESI);
  widget_configure (restart_button, resource_textfont, TIMESI);
  widget_configure (one_button, resource_textfont, TIMESI);
  widget_configure (auto_button, resource_textfont, TIMESI);
  widget_configure (about_button, resource_textfont, TIMESI);
  widget_configure (quit_button, resource_textfont, TIMESI);

  widget_add_callback (visible_button,
		       resource_buttonpress_callback,
		       (void *) visible_callback, 0);
  widget_add_callback (speed_button,
		       resource_buttonpress_callback,
		       (void *) speed_callback, 0);
  widget_add_callback (autoplay_button,
		       resource_buttonpress_callback,
		       (void *) autoplay_callback, 0);
  widget_add_callback (auto_after_reach_button,
		       resource_buttonpress_callback,
		       (void *) auto_after_reach_callback, 0);
  widget_add_callback (flush_button,
		       resource_buttonpress_callback,
		       (void *) flush_callback, 0);
  widget_add_callback (restart_button,
		       resource_buttonpress_callback,
		       (void *) restart_callback, 0);
  widget_add_callback (one_button,
		       resource_buttonpress_callback,
		       (void *) one_callback, 0);
  widget_add_callback (auto_button,
		       resource_buttonpress_callback,
		       (void *) auto_callback, 0);
  widget_add_callback (quit_button,
		       resource_buttonpress_callback,
		       (void *) quit_callback, 0);
  widget_add_callback (about_button,
		       resource_buttonpress_callback,
		       (void *) about_callback, 0);

}

extern int tann, darkgreen, seagreen, darkorange;

void
make_board ()
{
  int i;
  widget_t root, menu, frame, status1, status2;
  widget_t dummy;
  widget_t plane[4];
  char buffer[64];

/* main board */
  root = board = widget_create ("frame", root_widget);
  widget_set_geometry (board, xwidth, xheight);
  widget_configure (board, resource_name, "board");

/* title and menu buttons */
  menu_frame = status1 = widget_create ("frame", root);
  widget_configure (status1, resource_packed, resource_horizontal);
  title_frame = widget_create ("text", status1);
  widget_set_geometry (title_frame, xwidth - MBUTTON_W * 10 - 4, MBUTTON_H);
#if PAI3D
  sprintf(buffer, "xnetmaj %s from japan", version);
  widget_configure (title_frame, resource_text, buffer);
  widget_configure (title_frame, resource_textcolor, seagreen);
  widget_configure (title_frame, resource_textfont, 6);
  widget_configure (title_frame, resource_textshadow, 1);
#else
  sprintf(buffer, "xnetmaj %s", version);
  widget_configure (title_frame, resource_text, buffer);
  widget_configure (title_frame, resource_textcolor, darkorange);
  widget_configure (title_frame, resource_textfont, TIMESIB);
  widget_configure (title_frame, resource_textshadow, 1);
#endif

  build_status (status1);

/* case, dora and uradora frames */
  status_frame = status2 = widget_create ("frame", root);
  widget_configure (status1, resource_wrap, 0);
  widget_configure (status1, resource_packed, resource_horizontal);
  widget_configure (status2, resource_wrap, 0);
  widget_configure (status2, resource_packed, resource_horizontal);
  state_frame = widget_create ("pmcontainer", status2);
  reststr_frame = widget_create ("pmcontainer", status2);
  rest_frame = widget_create ("text", status2);
  widget_configure (rest_frame, resource_textfont, TIMESI);
  mt_reststr_frame = widget_create ("pmcontainer", status2);
  mt_rest_frame = widget_create ("text", status2);
  widget_configure (mt_rest_frame, resource_textfont, HELVB);
  dorastr_frame = widget_create ("pmcontainer", status2);
  dora_frame = widget_create ("pmcontainer", status2);
  uradorastr_frame = widget_create ("pmcontainer", status2);
  uradora_frame = widget_create ("pmcontainer", status2);

  widget_set_geometry (status1, xwidth, TITLE_H + 4);
  widget_configure (status1, resource_border_width, 2);
  widget_set_geometry (status2, xwidth, STATE_H + 4);
  widget_configure (status2, resource_border_width, 2);

  widget_set_geometry (state_frame, 140, STATE_H);
  widget_set_geometry (reststr_frame, STATE_W, STATE_H);
  widget_set_geometry (rest_frame, 30, STATE_H);
  widget_set_geometry (mt_reststr_frame, STATE_W, STATE_H);
  widget_set_geometry (mt_rest_frame, 30, STATE_H);
  widget_set_geometry (dorastr_frame, STATE_W, STATE_H);
  widget_set_geometry (dora_frame, PAI_W * 5, STATE_H);
  widget_set_geometry (uradorastr_frame, STATE_W, STATE_H);
  widget_set_geometry (uradora_frame, PAI_W * 5, STATE_H);

  {
    extern int yellow, white, purple, blue;
    widget_configure (rest_frame, resource_textcolor, yellow);
    widget_configure (rest_frame, resource_textshadow, 1);
  }

/* user frame */
  for (i = 0; i < 4; i++)
    {
      integer_t pai_width;
      widget_t w;
      plane[i] = widget_create ("frame", root);
      widget_configure (plane[i], resource_packed, resource_horizontal);

      name_frame[i] = widget_create ("frame", plane[i]);
      widget_configure (name_frame[i], resource_border_width, 2);

      user_kaze[i] = widget_create ("pmcontainer", name_frame[i]);
      user_name[i] = widget_create ("text", name_frame[i]);

      w = widget_create("frame", name_frame[i]);
      widget_configure (w, resource_packed, resource_horizontal);
      user_state[i] = widget_create ("pmcontainer", w);
      mark_frame[i] = widget_create ("pmcontainer", w);

      user_gpoint[i] = widget_create ("text", name_frame[i]);
      user_ppoint[i] = widget_create ("text", name_frame[i]);

      pai_width = xwidth - name_width;
      {
	extern int yellow, white, purple, blue;
	widget_configure (user_name[i], resource_textcolor, yellow);
	widget_configure (user_name[i], resource_textfont, TIMESIB);
	widget_configure (user_gpoint[i], resource_textcolor, yellow);
	widget_configure (user_ppoint[i], resource_textcolor, white);
	widget_configure (user_name[i], resource_textshadow, 1);
	widget_configure (user_ppoint[i], resource_textshadow, 1);
	widget_configure (user_gpoint[i], resource_textshadow, 1);
	widget_configure (user_ppoint[i], resource_textfont, TIMESI);
	widget_configure (user_gpoint[i], resource_textfont, TIMESI);
      }
      pai_frame[i] = widget_create ("frame", plane[i]);
      widget_configure (pai_frame[i], resource_border_width, 2);

      river_attr1[i] = widget_create ("pmcontainer", pai_frame[i]);
      river_frame[i] = widget_create ("pmcontainer", pai_frame[i]);
      river_attr2[i] = widget_create ("pmcontainer", pai_frame[i]);
      river_attr3[i] = widget_create ("pmcontainer", pai_frame[i]);
      river_attr4[i] = widget_create ("pmcontainer", pai_frame[i]);
      hand_frame[i] = widget_create ("pmcontainer", pai_frame[i]);
      openhand_frame[i] = widget_create ("pmcontainer", pai_frame[i]);

      widget_set_geometry (river_attr1[i], pai_width - 4, ATTR_H);
      widget_set_geometry (river_frame[i], pai_width - 4, PAI_H);
      widget_set_geometry (river_attr2[i], pai_width - 4, ATTR_H);
      widget_set_geometry (river_attr3[i], pai_width - 4, ATTR_H);
      widget_set_geometry (river_attr4[i], pai_width - 4, ATTR_H);
      widget_set_geometry (hand_frame[i], pai_width - 4, PAI_H);
      widget_set_geometry (openhand_frame[i], pai_width - 4, PAI_H);

      widget_configure (hand_frame[i], resource_pixmapstart, HANDPAISTART);
      widget_configure (openhand_frame[i], resource_pixmapstart, PAI_W * 9);
      widget_add_callback (hand_frame[i],
			   resource_buttonpress_callback,
			   (void *) select_pai_callback, i);
      widget_pack (pai_frame[i]);
      widget_configure (pai_frame[i], resource_wrap, 0);

      {
	integer_t w, h;
	widget_get_geometry (pai_frame[i], &w, &h);

	widget_set_geometry (user_kaze[i], name_width - 4, STATE_H);
	widget_set_geometry (user_name[i], name_width - 4, NAME_H + 4);
	widget_set_geometry (mark_frame[i], (name_width - 4)/2, USERSTATE_H);
	widget_set_geometry (user_state[i], (name_width - 4)/2, USERSTATE_H);
	widget_set_geometry (user_gpoint[i], name_width - 4, DIGIT_H);
	widget_set_geometry (user_ppoint[i], name_width - 4, DIGIT_H);
	widget_pack (name_frame[i]);	/* calculation of sizeof name_frame  */
	widget_configure (name_frame[i], resource_wrap, 0);
	widget_set_geometry (name_frame[i], name_width, h);
      }
/*      widget_pack (plane[i]); */
    }

/* action frame */
  action = widget_create ("frame", root);
  widget_configure (action, resource_packed, resource_horizontal);

  choicestate_frame = widget_create ("pmcontainer", action);
  widget_set_geometry (choicestate_frame, PAI_W * 3, PAI_H + 4);
  choice_frame = widget_create ("pmcontainer", action);
  widget_set_geometry (choice_frame, xwidth - PAI_W * 3, PAI_H + 4);

  {
    widget_t buttonaction = widget_create ("frame", root);
    widget_configure (buttonaction, resource_packed,
		      resource_horizontal);
    cancel_button = widget_create ("button", buttonaction);
    tie_button = widget_create ("button", buttonaction);
    pon_button = widget_create ("button", buttonaction);
    kan_button = widget_create ("button", buttonaction);
    reach_button = widget_create ("button", buttonaction);
    tumo_button = widget_create ("button", buttonaction);
    ron_button = widget_create ("button", buttonaction);
  }
  actionbutton_setup ();
/*  widget_configure (cancel_button, resource_text, "cancel");
   widget_configure (kan_button, resource_text, "kan");
   widget_configure (tumo_button, resource_text, "tumo");
   widget_configure (tie_button, resource_text, "tie");
   widget_configure (pon_button, resource_text, "pon");
   widget_configure (ron_button, resource_text, "ron");
   widget_configure (reach_button, resource_text, "reach"); */


  widget_set_geometry (cancel_button, BUTTON_W, BUTTON_H);
  widget_set_geometry (kan_button, BUTTON_W, BUTTON_H);
  widget_set_geometry (tumo_button, BUTTON_W, BUTTON_H);
  widget_set_geometry (tie_button, BUTTON_W, BUTTON_H);
  widget_set_geometry (pon_button, BUTTON_W, BUTTON_H);
  widget_set_geometry (reach_button, BUTTON_W, BUTTON_H);
  widget_set_geometry (ron_button, BUTTON_W, BUTTON_H);

  widget_add_callback (cancel_button,
		       resource_buttonpress_callback,
		       (void *) cancel_button_callback, "cancel");
  widget_add_callback (kan_button,
		       resource_buttonpress_callback,
		       (void *) kan_button_callback, "kan");
  widget_add_callback (tumo_button, resource_buttonpress_callback,
		       (void *) tumo_button_callback, "tumo");
  widget_add_callback (tie_button, resource_buttonpress_callback,
		       (void *) tie_button_callback, "tie");
  widget_add_callback (pon_button, resource_buttonpress_callback,
		       (void *) pon_button_callback, "pon");
  widget_add_callback (reach_button, resource_buttonpress_callback,
		       (void *) reach_button_callback, "reach");
  widget_add_callback (ron_button, resource_buttonpress_callback,
		       (void *) ron_button_callback, "ron");
  widget_add_callback (choice_frame,
		       resource_buttonpress_callback,
		       (void *) select_pai_callback, 5);


  widget_pack (root);
  widget_fix (root);
  message_init ((widget_t *)&pai_frame);

  bind_save (resource_button3press_callback,
	     (void *)board_button3press_callback, 0);

  widget_set_geometry (root, xwidth, xheight);
}

void
board_redraw ()
{
  extern boolean button_map_p, button_map_flag;

  autoplay_config (); 
  auto_after_reach_config ();
  speed_config ();  
  invisible_config ();

  widget_map (board);
  message_unmap ();
  if (button_map_p) {
    board_button_unmap ();
    board_button_map (button_map_flag);
  } else {
    board_button_unmap ();
  }
  board_display ();
  board_flush_sfx ();
}

void
board_reset ()
{
  int i;
  extern boolean button_map_p;
  button_map_p = 0;
  for (i = 0; i < 4; i++)
    {
      pmcontainer_clear (river_attr1[i]);
      pmcontainer_clear (river_frame[i]);
      pmcontainer_clear (river_attr2[i]);
      pmcontainer_clear (river_attr3[i]);
      pmcontainer_clear (river_attr4[i]);
      pmcontainer_clear (hand_frame[i]);
      pmcontainer_clear (openhand_frame[i]);
      pmcontainer_clear (mark_frame[i]);
      widget_configure (openhand_frame[i], resource_pixmapstart, (PAI_W * 7));
      widget_display (river_attr1[i]);
      widget_display (river_frame[i]);
      widget_display (river_attr2[i]);
      widget_display (river_attr3[i]);
      widget_display (river_attr4[i]);
      widget_display (hand_frame[i]);
      widget_display (openhand_frame[i]);
      widget_display (mark_frame[i]);
      widget_flush (river_attr1[i]);
      widget_flush (river_frame[i]);
      widget_flush (river_attr2[i]);
      widget_flush (river_attr3[i]);
      widget_flush (river_attr4[i]);
      widget_flush (hand_frame[i]);
      widget_flush (openhand_frame[i]);
      widget_flush (mark_frame[i]);
    }
  widget_event_discard (root_widget);
  widget_sync (root_widget);
}
