/*  -*- Mode: C -*- 
 * This file is part of xnetmaj
 * 
 * init.c -- 
 * 
 * $Id: init.c,v 1.1 1995/04/23 01:32:45 ksr Exp ksr $
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Tue Apr 11 11:14:08 1995
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Thu Jun  8 02:09:58 1995
 * description:
 *   initialize of program
 * history:
 *   programming by NBC02365@niftyserve.or.jp
 */

#include "xnet.h"
#include "pixread.h"

widget_t root_widget;

static void openning_pixmapfree()
{
#if X11
#endif
}

integer_t waitkey_flag;
void
keywait_callback ()
{
  waitkey_flag = 1;
}

void
wait_key ()
{
  waitkey_flag = 0;
  widget_define_button_hook (3, keywait_callback);
  for (; waitkey_flag == 0;)
    {
      _widget_handle_event ();
    }
  widget_define_button_hook (3, 0);
}

extern integer_t xwidth, xheight;
#if 0
static widget_t
openning_setup (parent)
     widget_t parent;
{
  widget_t frame1, frame2, frame3, frame2left, frame2center, frame2right;

  frame1 = widget_create ("pmcontainer", parent);
  frame2 = widget_create ("frame", parent);
  frame3 = widget_create ("pmcontainer", parent);

  widget_configure (frame2, resource_packed, resource_horizontal);

  frame2left = widget_create ("pmcontainer", frame2);
  frame2center = widget_create ("frame", frame2);
  frame2right = widget_create ("pmcontainer", frame2);

/* widget_set_geometry (frame0, xwidth, TOPMARGIN);  */
  widget_set_geometry (frame1, xwidth, TOPMARGIN);
  widget_set_geometry (frame3, xwidth, TOPMARGIN);
  widget_set_geometry (frame2, xwidth, xheight - (TOPMARGIN * 2));
  widget_configure (frame2, resource_wrap, 0);
}
#endif

#include <time.h>

static void
open_frame_init (open_frame, bottom)
     widget_t open_frame;
     widget_t bottom;
{
#if PAI3D
  if (pm_taku.pm) pmcontainer_add (open_frame, pm_taku.pm, pm_taku.Mpm, 1);
  if (pm_asia.pm) pmcontainer_add (open_frame, pm_asia.pm, pm_asia.Mpm, 1);
  pmcontainer_add (bottom, pm_logo.pm, pm_logo.Mpm, 1);
#elif PAICARD3D
  {
    time_t t = time(0);
    if (t % 2) {
      if (pm_taku.pm) pmcontainer_add (open_frame, pm_taku.pm, pm_taku.Mpm, 1);
    } else {
      if (pm_asia.pm) pmcontainer_add (open_frame, pm_asia.pm, pm_asia.Mpm, 1);
    }
  }
  pmcontainer_add (bottom, pm_logo.pm, pm_logo.Mpm, 1);
#else
  pmcontainer_add (open_frame, pm_logo.pm, pm_logo.Mpm, 1);
#endif

}

void
openning ()
{
  widget_t open_frame, base_frame;
  extern integer_t xheight;
  extern integer_t xwidth;
  widget_t pmframes[5];

#if PAI3D
#define GSIZE  (400+300)
#else
#define GSIZE  (400)
#endif

  base_frame = widget_create ("frame", root_widget);
  open_frame = (widget_t) create_basic_info_frame ("pmcontainer", base_frame,
						   pmframes, GSIZE, 1, 0);

  widget_set_geometry (base_frame, xwidth, xheight);
  widget_add_callback (base_frame,
		       resource_keypress_callback,
		       keywait_callback, "");

  widget_set_background (root_widget, pm_mainbg.pm);
  open_frame_init (open_frame, pmframes[3]);

  widget_pack (base_frame);
  widget_map (base_frame);
  widget_set_geometry (base_frame, xwidth, xheight);
  widget_display (base_frame);
  widget_flush_sfx_shaffle (base_frame, 30, 30);

  load_rcfile();

  sleep (1);
/*  wait_key (); */

  pmcontainer_clear_frame (open_frame);
  pmcontainer_clear_frame (pmframes[3]);
  openning_pixmapfree();

  bg_init();
  widget_unmap (base_frame);
  widget_destory (base_frame); 
/*  widget_flush (base_frame); */

}

void
setup ()
{
  xwidth = XWIDTH;
  xheight = XHEIGHT;
  root_widget = widget_init (xwidth, xheight);

  attr_init ();
  read_pixmaps ();
  read_adigit_pixmap ();
  read_bdigit_pixmap ();
  pai2pix_init ();
  auto_init ();
}
