/*  -*- Mode: C -*- 
 * This file is part of xnetmaj
 * 
 * intint.c -- 
 * 
 * $Id$
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Fri Apr 28 16:52:31 1995
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Thu May 11 15:29:47 1995
 * description:
 * 
 * history:
 *   programming by NBC02365@niftyserve.or.jp
 */

#include "xnet.h"
#include "xnetmaj.h"

extern integer_t speed;
extern integer_t invisible_riverpai;
extern integer_t auto_after_reach;
extern integer_t stop_flag;

static void _loadrc(buf)
char *buf;
{
  if (nu_source(buf)) {
    if (name_exist("speed")) {
      speed = name_value("speed");
      speed_config();
    }
    if (name_exist("visible")) {
      invisible_riverpai = !name_value("visible");
      invisible_config();
    }
    if (name_exist("auto_after_reach")) {
      auto_after_reach = name_value("auto_after_reach");
      auto_after_reach_config();
    }
    if (name_exist("wait2")) {
      stop_flag = name_value("wait2");
    }

  }
}

void load_rcfile()
{
  char *p;
  char buf[512];

  p = getenv(NETMAJ_LIB);
  if (p) {
      sprintf(buf, "%s/.xnetmaj", p);
     _loadrc(buf);
   }

  p = getenv("HOME");
  if (p) {
    sprintf(buf, "%s/.xnetmaj", p);
    _loadrc(buf);
  }
}
/* end of file */
