/*  -*- Mode: C -*- 
 * This file is part of my project
 * 
 * itime.c -- 
 * 
 * $Id$
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Wed Jun  7 04:51:46 1995
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Wed Jun  7 04:51:47 1995
 * description:
 * 
 * history:
 *   programming by NBC02365@niftyserve.or.jp
 */

#include <signal.h>

static int (*handler)();
static int timer_interval;
static int timer_handler_invoke()
{
  (*handler)();
  alarm(timer_interval);
}

#include <sys/time.h>

void set_timer_handler(func, interval)
int (*func)();
{
  handler = func;
  alarm(timer_interval = interval);
  signal(SIGALRM, (void *)timer_handler_invoke);
}

void clear_timer_handler()
{
  alarm(0);
  signal(SIGALRM, SIG_IGN);  
}

void stop_timer()
{
  alarm(0);
}

void resume_timer()
{
  alarm(timer_interval);
}

