/*  -*- Mode: C -*- 
 * This file is part of xnetmaj
 * 
 * msg.c -- 
 * 
 * $Id: msg.c,v 1.1 1995/04/23 01:32:45 ksr Exp ksr $
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Tue Apr 11 11:13:41 1995
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Thu Jun  8 19:37:09 1995
 * description:
 *   message and declaration in game
 * history:
 *   programming by NBC02365@niftyserve.or.jp
 */

#include "xnet.h"
#include "xnetmaj.h"
#include "pixread.h"

extern integer_t xwidth, xheight;
extern global_t *game_global;
extern global_t *hora_global;

#define WAIT 0
integer_t speed = WAIT;

static struct
  {
    widget_t p;
    widget_t f;			/* frame */
    widget_t m;			/* msg */
  }
comm[4], decl[4], play;

#include "bitmap/misc/tting.xpm"
#include "bitmap/misc/connect.xpm"
#include "bitmap/misc/disconne.xpm"
#include "bitmap/misc/msgtumo.xpm"
#include "bitmap/misc/msgron.xpm"
#include "bitmap/misc/msgreach.xpm"

struct gpixmap2 pm_msgconnectting;
struct gpixmap2 pm_msgconnect;
struct gpixmap2 pm_msgdisconnect;
struct gpixmap2 pm_msgtumo;
struct gpixmap2 pm_msgron;
struct gpixmap2 pm_msgreach;

static
playmessage_clear ()
{
  widget_xunmap (play.f);
  widget_flush (play.f);
}
void
message_unmap ()
{
  int i;
  for (i = 0; i < 4; i++)
    {
      widget_xunmap (comm[i].f);
    }
  for (i = 0; i < 4; i++)
    {
      widget_xunmap (decl[i].f);
    }
  widget_xunmap (play.f);
}
void
message_init (r)
     widget_t r[4];
{
  integer_t i;
  widget_t frame;

  read_pix (tting, pm_msgconnectting);
  read_pix (connect, pm_msgconnect);
  read_pix (disconne, pm_msgdisconnect);
  read_pix (msgtumo, pm_msgtumo);
  read_pix (msgtumo, pm_msgtumo);
  read_pix (msgron, pm_msgron);
  read_pix (msgreach, pm_msgreach);

  for (i = 0; i < 4; i++)
    {
      comm[i].p = r[i];
      comm[i].f = widget_create ("frame", r[i]);
      widget_configure (comm[i].f, resource_border_width, 2);
      comm[i].m = widget_create ("text", comm[i].f);
      widget_set_geometry (comm[i].f, name_width - 4, MSG_H + 4);
      widget_set_geometry (comm[i].m, name_width - 8, MSG_H);

      decl[i].p = r[i];
      decl[i].f = widget_create ("frame", r[i]);
      widget_configure (decl[i].f, resource_border_width, 2);
      decl[i].m = widget_create ("pmcontainer", decl[i].f);
      widget_set_geometry (decl[i].f, name_width - 4, MSG_H + 4);
      widget_set_geometry (decl[i].m, name_width - 8, MSG_H);
      widget_pack (decl[i].f);
      {
	extern int yellowgreen, yellow, tann, white;
	widget_set_color_change (decl[i].f, tann, tann, tann, tann);
      }
    }

  play.p = r[0];
  play.f = widget_create ("frame", r[0]);
  widget_configure (play.f, resource_border_width, 2);
  play.m = widget_create ("pmcontainer", play.f);
  widget_set_geometry (play.f, 94, MSG_H + 4);
  widget_set_geometry (play.m, 90, MSG_H);
  widget_pack (play.f);
  {
    int i;
    for (i = 0; i < 4; i++)
      {
	widget_configure (comm[i].f, resource_packed, 0);
      }
    for (i = 0; i < 4; i++)
      {
	widget_configure (decl[i].f, resource_packed, 0);
      }
    widget_configure (play.f, resource_packed, 0);
  }

}




static void
popup_playmessage (pm)
     gpixmap2_t pm;
{
  pmcontainer_print (play.m, (*pm));
  widget_map (play.f);
  widget_display (play.f);
  widget_flush (play.f);
  sleep (speed);
  playmessage_clear ();
/*  set_timer_handler(playmessage_clear); */
}

static void
popup_declmessage (i, pm, timeout)
     gpixmap2_t pm;
{
  pmcontainer_print (decl[i].m, (*pm));
  widget_map (decl[i].f);
  widget_display (decl[i].f);
  widget_flush (decl[i].f);
  sleep (timeout);
  widget_xunmap (decl[i].f);
  widget_flush (decl[i].f);

/*  set_timer_handler(playmessage_clear); */
}




ui_message_connecting ()
{
  extern widget_t root_widget;
  if (widget_eventsqueued (root_widget))
    {
      widget_display (root_widget);
      widget_flush (root_widget);
    }
  popup_playmessage (&pm_msgconnectting);
}

ui_message_connect ()
{
  popup_playmessage (&pm_msgconnect);
}

ui_message_disconnect ()
{
  popup_playmessage (&pm_msgdisconnect);
}

ui_message_reach (i)
{
  i = pos2who (i);
  popup_declmessage (mytblpos (i), &pm_msgreach, 2 + speed);
}

integer_t stop_flag;
#define wait4key() \
      widget_configure (cancel_button, resource_text, "ok");\
      widget_map (cancel_button);\
      widget_display (cancel_button);\
      widget_flush (cancel_button);\
      wait_key ();\
      widget_configure (cancel_button, resource_text, "cancel");\
      widget_unmap (cancel_button);

ui_message_tumo (i)
{
  i = pos2who (i);
  popup_declmessage (mytblpos (i), &pm_msgtumo, 2 + speed);
  if (stop_flag)
    {
      wait4key ();
    }
  flag_not_needredraw = 1;
}

ui_message_ron (i)
{
  i = pos2who (i);
  popup_declmessage (mytblpos (i), &pm_msgron, 2 + speed);
  if (stop_flag)
    {
      wait4key ();
    }
  flag_not_needredraw = 1;
}

ui_message_player (gp)
{
  flag_not_needdraw_hand = 1;
}

ui_message_play (gp)
{
/*  flag_not_needredraw = 1; */
}

void
speed_config ()
{
  extern int white, yellow;
  extern integer_t stop_flag;
  char buf[64];
  if (speed == STOPVALUE)
    {
      sprintf (buf, "wait");
      stop_flag = 1;
      widget_configure (speed_button, resource_textcolor, yellow);
    }
  else
    {
      sprintf (buf, "speed %d", speed + 1);
      stop_flag = 0;
      widget_configure (speed_button, resource_textcolor, white);
    }
  widget_configure (speed_button, resource_text, buf);
  widget_display(speed_button);
  widget_flush(speed_button);
}

void
speed_callback ()
{
  speed++;
  if (speed == 4)
    {
      speed = STOPVALUE;
    }
  stop_flag = (speed == STOPVALUE);
  speed_config ();
}
