/*  -*- Mode: C -*- 
 * This file is part of xnetmaj
 * 
 * pixpai.c -- 
 * 
 * $Id: pixpai.c,v 1.1 1995/04/23 01:32:45 ksr Exp ksr $
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Tue Apr 11 11:14:29 1995
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Wed Jun  7 04:11:43 1995
 * description:
 *   paicard pixmaps are contributed by suz@d2.bs1.fc.nec.co.jp
 * history:
 *   programming by NBC02365@niftyserve.or.jp
 */
#include "xnet.h"
#include "pixread.h"

/*
  This file contains two global functions;
  pai2pix (n, pos, reach, opened)
  pixpai_init()

  If you'd like to change pai xpm data, please rewrite these functions;

  pai2pix(n, pos, reach, opened)

  n :  pai serial number, detail of pai serial number see below (include Japanese character, sorry);
  pos: 0, 1, 2, 3 means position of game frame. 3 means player(you).
  reach: reach pai or not(0 or 1) if pai is reach pai, then 1;
  opened: 0 or PAIOPEN, PAIDARK or PAIOPEN|PAIDARK
          0 means normal closed pai;
          PAIOPEN means opened pai on river
          PAIDARK means dark pai ( only PAIDARK is not specified )
          PAIOPEN|PAIDARK means opened dark pai ( pon'ed, kan'ed or tie'ed )

  pixpai_init
     pais of number 5 have initialized before starting play.
*/


#if PAICARD_ORG

#include "bitmap/pai/cyun_24.xpm"
#include "bitmap/pai/haku_24.xpm"
#include "bitmap/pai/hatu_24.xpm"
#include "bitmap/pai/man1_24.xpm"
#include "bitmap/pai/man2_24.xpm"
#include "bitmap/pai/man3_24.xpm"
#include "bitmap/pai/man4_24.xpm"
#include "bitmap/pai/man5_24.xpm"
#include "bitmap/pai/man5r_24.xpm"
#include "bitmap/pai/man6_24.xpm"
#include "bitmap/pai/man7_24.xpm"
#include "bitmap/pai/man8_24.xpm"
#include "bitmap/pai/man9_24.xpm"
#include "bitmap/pai/nan_24.xpm"
#include "bitmap/pai/pei_24.xpm"
#include "bitmap/pai/pin1_24.xpm"
#include "bitmap/pai/pin2_24.xpm"
#include "bitmap/pai/pin3_24.xpm"
#include "bitmap/pai/pin4_24.xpm"
#include "bitmap/pai/pin5_24.xpm"
#include "bitmap/pai/pin5r_24.xpm"
#include "bitmap/pai/pin6_24.xpm"
#include "bitmap/pai/pin7_24.xpm"
#include "bitmap/pai/pin8_24.xpm"
#include "bitmap/pai/pin9_24.xpm"
#include "bitmap/pai/rev_24.xpm"
#include "bitmap/pai/sou1_24.xpm"
#include "bitmap/pai/sou2_24.xpm"
#include "bitmap/pai/sou3_24.xpm"
#include "bitmap/pai/sou4_24.xpm"
#include "bitmap/pai/sou5_24.xpm"
#include "bitmap/pai/sou5r_24.xpm"
#include "bitmap/pai/sou6_24.xpm"
#include "bitmap/pai/sou7_24.xpm"
#include "bitmap/pai/sou8_24.xpm"
#include "bitmap/pai/sou9_24.xpm"
#include "bitmap/pai/sya_24.xpm"
#include "bitmap/pai/ton_24.xpm"

/*
   char *pai_strings[] = {
   "   ","$B"#(B ","XXX","$B"-(B ",

   "$B0l(B ","$B0l(B ","$B0l(B ","$B0l(B ",
   "$BFs(B ","$BFs(B ","$BFs(B ","$BFs(B ",
   "$B;0(B ","$B;0(B ","$B;0(B ","$B;0(B ",
   "$B;M(B ","$B;M(B ","$B;M(B ","$B;M(B ",
   "$B8^(B+","$B8^(B ","$B8^(B ","$B8^(B ",
   "$BO;(B ","$BO;(B ","$BO;(B ","$BO;(B ",
   "$B<7(B ","$B<7(B ","$B<7(B ","$B<7(B ",
   "$BH,(B ","$BH,(B ","$BH,(B ","$BH,(B ",
   "$B6e(B ","$B6e(B ","$B6e(B ","$B6e(B ",

   "(1)","(1)","(1)","(1)",
   "(2)","(2)","(2)","(2)",
   "(3)","(3)","(3)","(3)",
   "(4)","(4)","(4)","(4)",
   "[5]","(5)","(5)","(5)",
   "(6)","(6)","(6)","(6)",
   "(7)","(7)","(7)","(7)",
   "(8)","(8)","(8)","(8)",
   "(9)","(9)","(9)","(9)",

   "$B#1(B ","$B#1(B ","$B#1(B ","$B#1(B ",
   "$B#2(B ","$B#2(B ","$B#2(B ","$B#2(B ",
   "$B#3(B ","$B#3(B ","$B#3(B ","$B#3(B ",
   "$B#4(B ","$B#4(B ","$B#4(B ","$B#4(B ",
   "$B#5(B+","$B#5(B ","$B#5(B ","$B#5(B ",
   "$B#6(B ","$B#6(B ","$B#6(B ","$B#6(B ",
   "$B#7(B ","$B#7(B ","$B#7(B ","$B#7(B ",
   "$B#8(B ","$B#8(B ","$B#8(B ","$B#8(B ",
   "$B#9(B ","$B#9(B ","$B#9(B ","$B#9(B ",

   "$BEl(B ","$BEl(B ","$BEl(B ","$BEl(B ",
   "$BFn(B ","$BFn(B ","$BFn(B ","$BFn(B ",
   "$B@>(B ","$B@>(B ","$B@>(B ","$B@>(B ",
   "$BKL(B ","$BKL(B ","$BKL(B ","$BKL(B ",
   "$B""(B ","$B""(B ","$B""(B ","$B""(B ",
   "$BH/(B ","$BH/(B ","$BH/(B ","$BH/(B ",
   "$BCf(B ","$BCf(B ","$BCf(B ","$BCf(B ",
   };
 */


#undef fbitmap
#define fbitmap(a)  identcat(a,_24_xpm)

static char **pai24_data[] =
{
  fbitmap (man1),
  fbitmap (man2),
  fbitmap (man3),
  fbitmap (man4),
  fbitmap (man5),
  fbitmap (man6),
  fbitmap (man7),
  fbitmap (man8),
  fbitmap (man9),
  fbitmap (pin1),
  fbitmap (pin2),
  fbitmap (pin3),
  fbitmap (pin4),
  fbitmap (pin5),
  fbitmap (pin6),
  fbitmap (pin7),
  fbitmap (pin8),
  fbitmap (pin9),
  fbitmap (sou1),
  fbitmap (sou2),
  fbitmap (sou3),
  fbitmap (sou4),
  fbitmap (sou5),
  fbitmap (sou6),
  fbitmap (sou7),
  fbitmap (sou8),
  fbitmap (sou9),
  fbitmap (ton),
  fbitmap (nan),
  fbitmap (sya),
  fbitmap (pei),
  fbitmap (haku),
  fbitmap (hatu),
  fbitmap (cyun),
  0,
};

static struct gpixmap2 pm_pai[38 * 4];
static struct gpixmap2 pm_pai_have_to_free[38 * 4];
static have_to_free;


gpixmap2_t
pai2pix (n, pos, reach, opened)
     integer_t n;
     integer_t pos;
     integer_t reach;
/*   1   */
/* 2   0 */
/*   3   */
     integer_t opened;		/* opened or not */
{
  if (n < 4)
    {
    zero:
      if (n == 0)
	{
	  if (!pm_pai[n].pm)
	    {
	      read_pix_idx (rev_24_xpm, pm_pai[n]);
	      pm_pai_have_to_free[have_to_free++] = pm_pai[n];
	    }
	  return &pm_pai[n];
	}
      else
	{
	  n = 0;
	  goto zero;
	}
    }
  if (!pm_pai[n].pm)
    {
      int j = ((n - 4) / 4);
      read_pix_idx (pai24_data[j], pm_pai[n]);
      pm_pai_have_to_free[have_to_free++] = pm_pai[n];
    }
  return &pm_pai[n];
}

#define MAN5R  (5 * 4)
#define PIN5R  (14 * 4)
#define SOU5R  (23 * 4)

void
pai2pix_init ()
{
  read_pix (man5r, pm_pai[MAN5R]);
  pm_pai_have_to_free[have_to_free++] = pm_pai[MAN5R];
  read_pix (pin5r, pm_pai[PIN5R]);
  pm_pai_have_to_free[have_to_free++] = pm_pai[PIN5R];
  read_pix (sou5r, pm_pai[SOU5R]);
  pm_pai_have_to_free[have_to_free++] = pm_pai[SOU5R];

  read_pix (man5, pm_pai[MAN5R + 1]);
  pm_pai_have_to_free[have_to_free++] = pm_pai[MAN5R + 1];
  read_pix (pin5, pm_pai[PIN5R + 1]);
  pm_pai_have_to_free[have_to_free++] = pm_pai[PIN5R + 1];
  read_pix (sou5, pm_pai[SOU5R + 1]);
  pm_pai_have_to_free[have_to_free++] = pm_pai[SOU5R + 1];

  pm_pai[MAN5R + 3] = pm_pai[MAN5R + 2] = pm_pai[MAN5R + 1];
  pm_pai[PIN5R + 3] = pm_pai[PIN5R + 2] = pm_pai[PIN5R + 1];
  pm_pai[SOU5R + 3] = pm_pai[SOU5R + 2] = pm_pai[SOU5R + 1];
}

#elif PAI3D

/*
   round for 4 
 */
#include "bitmap/pai3/pai.h"
#include "bitmap/pai3/rpai.h"
#include "bitmap/pai3/hpai.h"

#include "bitmap/pai3/tpai.h"
#include "bitmap/pai3/rtpai.h"
#include "bitmap/pai3/htpai.h"

#include "bitmap/pai3/xpai.h"
#include "bitmap/pai3/xrpai.h"
#include "bitmap/pai3/xhpai.h"

#include "bitmap/pai3/xtpai.h"
#include "bitmap/pai3/xrtpai.h"
#include "bitmap/pai3/xhtpai.h"

static char **openedpai3_data[] =
{
  xphidden,
  xp1m, xp2m, xp3m, xp4m, xp5m, xp6m, xp7m, xp8m, xp9m,
  xp1p, xp2p, xp3p, xp4p, xp5p, xp6p, xp7p, xp8p, xp9p,
  xp1s, xp2s, xp3s, xp4s, xp5s, xp6s, xp7s, xp8s, xp9s,
  xpton, xpnan, xpsha, xppei, xphaku, xphatu, xpchun, 0,
};

static char **darkopenedpai3_data[] =
{
  xdphidden,
  xdp1m, xdp2m, xdp3m, xdp4m, xdp5m, xdp6m, xdp7m, xdp8m, xdp9m,
  xdp1p, xdp2p, xdp3p, xdp4p, xdp5p, xdp6p, xdp7p, xdp8p, xdp9p,
  xdp1s, xdp2s, xdp3s, xdp4s, xdp5s, xdp6s, xdp7s, xdp8s, xdp9s,
  xdpton, xdpnan, xdpsha, xdppei, xdphaku, xdphatu, xdpchun, 0,
};

static char **closedpai3_data[] =
{
  phidden,
  p1m, p2m, p3m, p4m, p5m, p6m, p7m, p8m, p9m,
  p1p, p2p, p3p, p4p, p5p, p6p, p7p, p8p, p9p,
  p1s, p2s, p3s, p4s, p5s, p6s, p7s, p8s, p9s,
  pton, pnan, psha, ppei, phaku, phatu, pchun, 0,
};

static char **openedpai0_data[] =
{
  xtphidden,
  xtp1m, xtp2m, xtp3m, xtp4m, xtp5m, xtp6m, xtp7m, xtp8m, xtp9m,
  xtp1p, xtp2p, xtp3p, xtp4p, xtp5p, xtp6p, xtp7p, xtp8p, xtp9p,
  xtp1s, xtp2s, xtp3s, xtp4s, xtp5s, xtp6s, xtp7s, xtp8s, xtp9s,
  xtpton, xtpnan, xtpsha, xtppei, xtphaku, xtphatu, xtpchun, 0,
};

static char **darkopenedpai0_data[] =
{
  xdtphidden,
  xdtp1m, xdtp2m, xdtp3m, xdtp4m, xdtp5m, xdtp6m, xdtp7m, xdtp8m, xdtp9m,
  xdtp1p, xdtp2p, xdtp3p, xdtp4p, xdtp5p, xdtp6p, xdtp7p, xdtp8p, xdtp9p,
  xdtp1s, xdtp2s, xdtp3s, xdtp4s, xdtp5s, xdtp6s, xdtp7s, xdtp8s, xdtp9s,
  xdtpton, xdtpnan, xdtpsha, xdtppei, xdtphaku, xdtphatu, xdtpchun, 0,
};

static char **closedpai0_data[] =
{
  tphidden,
  tp1m, tp2m, tp3m, tp4m, tp5m, tp6m, tp7m, tp8m, tp9m,
  tp1p, tp2p, tp3p, tp4p, tp5p, tp6p, tp7p, tp8p, tp9p,
  tp1s, tp2s, tp3s, tp4s, tp5s, tp6s, tp7s, tp8s, tp9s,
  tpton, tpnan, tpsha, tppei, tphaku, tphatu, tpchun, 0,
};

static char **openedpai1_data[sizeof (closedpai0_data) / sizeof (char **)];
static char **closedpai1_data[sizeof (closedpai0_data) / sizeof (char **)];
static char **darkopenedpai1_data[sizeof (closedpai0_data) / sizeof (char **)];

static char **openedpai2_data[sizeof (closedpai0_data) / sizeof (char **)];
static char **closedpai2_data[sizeof (closedpai0_data) / sizeof (char **)];
static char **darkopenedpai2_data[sizeof (closedpai0_data) / sizeof (char **)];

struct
  {
    char ***opened;
    char ***closed;
    char ***darkopened;
  }
pai_data[4] =
{
  {
    openedpai0_data, closedpai0_data, darkopenedpai0_data
  }
  ,
  {
    openedpai1_data, closedpai1_data, darkopenedpai1_data
  }
  ,
  {
    openedpai2_data, closedpai2_data, darkopenedpai2_data
  }
  ,
  {
    openedpai3_data, closedpai3_data, darkopenedpai3_data
  }
  ,
};

static struct
  {
    struct gpixmap2 opened[39 * 4];
    struct gpixmap2 darkopened[39 * 4];
    struct gpixmap2 closed[39 * 4];
  }
pm_pai[4];

gpixmap2_t
pai2pix (n, pos, reach, opened)
     integer_t n;
     integer_t pos;
     integer_t reach;
/*   1   */
/* 2   0 */
/*   3   */
     integer_t opened;		/* opened or not */
{
  gpixmap2_t pais;
  char ***data;
  int paidirec = 3; /* pos to pai direction */

  if (opened & PAIOPEN)
    {
      if (reach)
	{
#if 0
	  if (pos == 1 || pos == 3)
	    {
	      t = 0;
	    }
	  if (pos == 0 || pos == 2)
	    {
	      t = 3;
	    }
#else
          paidirec = 0; /* horizontal */
#endif
	} else {
#if 0
	  paidirec = pos; /* normal */
#else
	  paidirec = 3;
#endif
	}
      if (opened & PAIDARK)
	{
	  pais = pm_pai[paidirec].darkopened;
	  data = pai_data[paidirec].darkopened;
	}
      else
	{
	  pais = pm_pai[paidirec].opened;
	  data = pai_data[paidirec].opened;
	}
    }
  else
    {
#if 0
      if (opened & PAIDARK)
	{
	  pais = pm_pai[3].darkclosed;
	  data = pai_data[3].darkclosed;
	} else {
	  pais = pm_pai[3].closed;
	  data = pai_data[3].closed;
	}
#endif
 /* forcely virtical */
      pais = pm_pai[3].closed;
      data = pai_data[3].closed;
    }

  if (!pais[n].pm)
    {
      int j = (n / 4);
      if (n < 0 || n >= (37 * 4)) abort();
      read_pix_idx (data[j], pais[n]);
    }
  return &pais[n];
}



#define MAN5R  (5 * 4)
#define PIN5R  (14 * 4)
#define SOU5R  (23 * 4)


void
pai2pix_init ()
{
  gpixmap2_t pai;

  pai = pm_pai[3].opened;
  read_pix_idx (xp5mr, pai[MAN5R]);
  read_pix_idx (xp5pr, pai[PIN5R]);
  read_pix_idx (xp5sr, pai[SOU5R]);

  read_pix_idx (xp5m, pai[MAN5R + 1]);
  read_pix_idx (xp5p, pai[PIN5R + 1]);
  read_pix_idx (xp5s, pai[SOU5R + 1]);

  pai[MAN5R + 3] = pai[MAN5R + 2] = pai[MAN5R + 1];
  pai[PIN5R + 3] = pai[PIN5R + 2] = pai[PIN5R + 1];
  pai[SOU5R + 3] = pai[SOU5R + 2] = pai[SOU5R + 1];

  pai = pm_pai[3].darkopened;
  read_pix_idx (xdp5mr, pai[MAN5R]);
  read_pix_idx (xdp5pr, pai[PIN5R]);
  read_pix_idx (xdp5sr, pai[SOU5R]);

  read_pix_idx (xdp5m, pai[MAN5R + 1]);
  read_pix_idx (xdp5p, pai[PIN5R + 1]);
  read_pix_idx (xdp5s, pai[SOU5R + 1]);

  pai[MAN5R + 3] = pai[MAN5R + 2] = pai[MAN5R + 1];
  pai[PIN5R + 3] = pai[PIN5R + 2] = pai[PIN5R + 1];
  pai[SOU5R + 3] = pai[SOU5R + 2] = pai[SOU5R + 1];

  pai = pm_pai[3].closed;
  read_pix_idx (p5mr, pai[MAN5R]);
  read_pix_idx (p5pr, pai[PIN5R]);
  read_pix_idx (p5sr, pai[SOU5R]);

  read_pix_idx (p5m, pai[MAN5R + 1]);
  read_pix_idx (p5p, pai[PIN5R + 1]);
  read_pix_idx (p5s, pai[SOU5R + 1]);

  pai[MAN5R + 3] = pai[MAN5R + 2] = pai[MAN5R + 1];
  pai[PIN5R + 3] = pai[PIN5R + 2] = pai[PIN5R + 1];
  pai[SOU5R + 3] = pai[SOU5R + 2] = pai[SOU5R + 1];


  pai = pm_pai[0].opened;
  read_pix_idx (xtp5mr, pai[MAN5R]);
  read_pix_idx (xtp5pr, pai[PIN5R]);
  read_pix_idx (xtp5sr, pai[SOU5R]);

  read_pix_idx (xtp5m, pai[MAN5R + 1]);
  read_pix_idx (xtp5p, pai[PIN5R + 1]);
  read_pix_idx (xtp5s, pai[SOU5R + 1]);

  pai[MAN5R + 3] = pai[MAN5R + 2] = pai[MAN5R + 1];
  pai[PIN5R + 3] = pai[PIN5R + 2] = pai[PIN5R + 1];
  pai[SOU5R + 3] = pai[SOU5R + 2] = pai[SOU5R + 1];

  pai = pm_pai[0].darkopened;
  read_pix_idx (xdtp5mr, pai[MAN5R]);
  read_pix_idx (xdtp5pr, pai[PIN5R]);
  read_pix_idx (xdtp5sr, pai[SOU5R]);

  read_pix_idx (xdtp5m, pai[MAN5R + 1]);
  read_pix_idx (xdtp5p, pai[PIN5R + 1]);
  read_pix_idx (xdtp5s, pai[SOU5R + 1]);

  pai[MAN5R + 3] = pai[MAN5R + 2] = pai[MAN5R + 1];
  pai[PIN5R + 3] = pai[PIN5R + 2] = pai[PIN5R + 1];
  pai[SOU5R + 3] = pai[SOU5R + 2] = pai[SOU5R + 1];

  pai = pm_pai[0].closed;
  read_pix_idx (tp5mr, pai[MAN5R]);
  read_pix_idx (tp5pr, pai[PIN5R]);
  read_pix_idx (tp5sr, pai[SOU5R]);

  read_pix_idx (tp5m, pai[MAN5R + 1]);
  read_pix_idx (tp5p, pai[PIN5R + 1]);
  read_pix_idx (tp5s, pai[SOU5R + 1]);

  pai[MAN5R + 3] = pai[MAN5R + 2] = pai[MAN5R + 1];
  pai[PIN5R + 3] = pai[PIN5R + 2] = pai[PIN5R + 1];
  pai[SOU5R + 3] = pai[SOU5R + 2] = pai[SOU5R + 1];

}

#elif PAICARD


#include "bitmap/pai/pai.h"
#include "bitmap/pai/paih.h"
/* #include "bitmap/pai/rev.h" */



#define _bitmap(a)  identcat(a,_24_xpm)

static char **openedpai3_data[] =
{
  _bitmap (rev),
  _bitmap (man1),
  _bitmap (man2),
  _bitmap (man3),
  _bitmap (man4),
  _bitmap (man5),
  _bitmap (man6),
  _bitmap (man7),
  _bitmap (man8),
  _bitmap (man9),
  _bitmap (pin1),
  _bitmap (pin2),
  _bitmap (pin3),
  _bitmap (pin4),
  _bitmap (pin5),
  _bitmap (pin6),
  _bitmap (pin7),
  _bitmap (pin8),
  _bitmap (pin9),
  _bitmap (sou1),
  _bitmap (sou2),
  _bitmap (sou3),
  _bitmap (sou4),
  _bitmap (sou5),
  _bitmap (sou6),
  _bitmap (sou7),
  _bitmap (sou8),
  _bitmap (sou9),
  _bitmap (ton),
  _bitmap (nan),
  _bitmap (sya),
  _bitmap (pei),
  _bitmap (haku),
  _bitmap (hatu),
  _bitmap (cyun),
};


#define d_bitmap(a)  identcat(a,_24_xpm)

static char **darkopenedpai3_data[] =
{
  d_bitmap (rev),
  d_bitmap (man1),
  d_bitmap (man2),
  d_bitmap (man3),
  d_bitmap (man4),
  d_bitmap (man5),
  d_bitmap (man6),
  d_bitmap (man7),
  d_bitmap (man8),
  d_bitmap (man9),
  d_bitmap (pin1),
  d_bitmap (pin2),
  d_bitmap (pin3),
  d_bitmap (pin4),
  d_bitmap (pin5),
  d_bitmap (pin6),
  d_bitmap (pin7),
  d_bitmap (pin8),
  d_bitmap (pin9),
  d_bitmap (sou1),
  d_bitmap (sou2),
  d_bitmap (sou3),
  d_bitmap (sou4),
  d_bitmap (sou5),
  d_bitmap (sou6),
  d_bitmap (sou7),
  d_bitmap (sou8),
  d_bitmap (sou9),
  d_bitmap (ton),
  d_bitmap (nan),
  d_bitmap (sya),
  d_bitmap (pei),
  d_bitmap (haku),
  d_bitmap (hatu),
  d_bitmap (cyun),
};

#define c_bitmap(a)  identcat(a,_24_xpm)

static char **closedpai3_data[] =
{
  c_bitmap (rev),
  c_bitmap (man1),
  c_bitmap (man2),
  c_bitmap (man3),
  c_bitmap (man4),
  c_bitmap (man5),
  c_bitmap (man6),
  c_bitmap (man7),
  c_bitmap (man8),
  c_bitmap (man9),
  c_bitmap (pin1),
  c_bitmap (pin2),
  c_bitmap (pin3),
  c_bitmap (pin4),
  c_bitmap (pin5),
  c_bitmap (pin6),
  c_bitmap (pin7),
  c_bitmap (pin8),
  c_bitmap (pin9),
  c_bitmap (sou1),
  c_bitmap (sou2),
  c_bitmap (sou3),
  c_bitmap (sou4),
  c_bitmap (sou5),
  c_bitmap (sou6),
  c_bitmap (sou7),
  c_bitmap (sou8),
  c_bitmap (sou9),
  c_bitmap (ton),
  c_bitmap (nan),
  c_bitmap (sya),
  c_bitmap (pei),
  c_bitmap (haku),
  c_bitmap (hatu),
  c_bitmap (cyun),
};

#define _0bitmap(a)  identcat(a,_24h_xpm)

static char **openedpai0_data[] =
{
  _0bitmap (rev),
  _0bitmap (man1),
  _0bitmap (man2),
  _0bitmap (man3),
  _0bitmap (man4),
  _0bitmap (man5),
  _0bitmap (man6),
  _0bitmap (man7),
  _0bitmap (man8),
  _0bitmap (man9),
  _0bitmap (pin1),
  _0bitmap (pin2),
  _0bitmap (pin3),
  _0bitmap (pin4),
  _0bitmap (pin5),
  _0bitmap (pin6),
  _0bitmap (pin7),
  _0bitmap (pin8),
  _0bitmap (pin9),
  _0bitmap (sou1),
  _0bitmap (sou2),
  _0bitmap (sou3),
  _0bitmap (sou4),
  _0bitmap (sou5),
  _0bitmap (sou6),
  _0bitmap (sou7),
  _0bitmap (sou8),
  _0bitmap (sou9),
  _0bitmap (ton),
  _0bitmap (nan),
  _0bitmap (sya),
  _0bitmap (pei),
  _0bitmap (haku),
  _0bitmap (hatu),
  _0bitmap (cyun),
};

#define d_0bitmap(a)  identcat(a,_24_xpm)

static char **darkopenedpai0_data[] =
{
  d_0bitmap (rev),
  d_0bitmap (man1),
  d_0bitmap (man2),
  d_0bitmap (man3),
  d_0bitmap (man4),
  d_0bitmap (man5),
  d_0bitmap (man6),
  d_0bitmap (man7),
  d_0bitmap (man8),
  d_0bitmap (man9),
  d_0bitmap (pin1),
  d_0bitmap (pin2),
  d_0bitmap (pin3),
  d_0bitmap (pin4),
  d_0bitmap (pin5),
  d_0bitmap (pin6),
  d_0bitmap (pin7),
  d_0bitmap (pin8),
  d_0bitmap (pin9),
  d_0bitmap (sou1),
  d_0bitmap (sou2),
  d_0bitmap (sou3),
  d_0bitmap (sou4),
  d_0bitmap (sou5),
  d_0bitmap (sou6),
  d_0bitmap (sou7),
  d_0bitmap (sou8),
  d_0bitmap (sou9),
  d_0bitmap (ton),
  d_0bitmap (nan),
  d_0bitmap (sya),
  d_0bitmap (pei),
  d_0bitmap (haku),
  d_0bitmap (hatu),
  d_0bitmap (cyun),
};

#define c_0bitmap(a)  identcat(a,_24h_xpm)

static char **closedpai0_data[] =
{
  c_0bitmap (rev),
  c_0bitmap (man1),
  c_0bitmap (man2),
  c_0bitmap (man3),
  c_0bitmap (man4),
  c_0bitmap (man5),
  c_0bitmap (man6),
  c_0bitmap (man7),
  c_0bitmap (man8),
  c_0bitmap (man9),
  c_0bitmap (pin1),
  c_0bitmap (pin2),
  c_0bitmap (pin3),
  c_0bitmap (pin4),
  c_0bitmap (pin5),
  c_0bitmap (pin6),
  c_0bitmap (pin7),
  c_0bitmap (pin8),
  c_0bitmap (pin9),
  c_0bitmap (sou1),
  c_0bitmap (sou2),
  c_0bitmap (sou3),
  c_0bitmap (sou4),
  c_0bitmap (sou5),
  c_0bitmap (sou6),
  c_0bitmap (sou7),
  c_0bitmap (sou8),
  c_0bitmap (sou9),
  c_0bitmap (ton),
  c_0bitmap (nan),
  c_0bitmap (sya),
  c_0bitmap (pei),
  c_0bitmap (haku),
  c_0bitmap (hatu),
  c_0bitmap (cyun),
};

static char **openedpai1_data[sizeof (closedpai0_data) / sizeof (char **)];
static char **closedpai1_data[sizeof (closedpai0_data) / sizeof (char **)];
static char **darkopenedpai1_data[sizeof (closedpai0_data) / sizeof (char **)];

static char **openedpai2_data[sizeof (closedpai0_data) / sizeof (char **)];
static char **closedpai2_data[sizeof (closedpai0_data) / sizeof (char **)];
static char **darkopenedpai2_data[sizeof (closedpai0_data) / sizeof (char **)];

struct
  {
    char ***opened;
    char ***closed;
    char ***darkopened;
  }
pai_data[4] =
{
  {
    openedpai0_data, closedpai0_data, darkopenedpai0_data
  }
  ,
  {
    openedpai1_data, closedpai1_data, darkopenedpai1_data
  }
  ,
  {
    openedpai2_data, closedpai2_data, darkopenedpai2_data
  }
  ,
  {
    openedpai3_data, closedpai3_data, darkopenedpai3_data
  }
  ,
};

#define	xp5m _bitmap(man5)
#define xp5p _bitmap(pin5)
#define xp5s _bitmap(sou5)
#define	xp5mr _bitmap(man5r)
#define xp5pr _bitmap(pin5r)
#define xp5sr _bitmap(sou5r)
#define xdp5m d_bitmap(man5)
#define xdp5p d_bitmap(pin5)
#define xdp5s d_bitmap(sou5)
#define	xdp5mr d_bitmap(man5r)
#define xdp5pr d_bitmap(pin5r)
#define xdp5sr d_bitmap(sou5r)
#define	p5m  c_bitmap(man5)
#define p5p  c_bitmap(pin5)
#define p5s c_bitmap(sou5)
#define	p5mr c_bitmap(man5r)
#define p5pr c_bitmap(pin5r)
#define p5sr c_bitmap(sou5r)
#define	tp5m  c_0bitmap(man5)
#define tp5p  c_0bitmap(pin5)
#define tp5s  c_0bitmap(sou5)
#define	tp5mr  c_0bitmap(man5r)
#define tp5pr  c_0bitmap(pin5r)
#define tp5sr  c_0bitmap(sou5r)
#define	xtp5m  _0bitmap(man5)
#define xtp5p  _0bitmap(pin5)
#define xtp5s  _0bitmap(sou5)
#define xtp5mr  _0bitmap(man5r)
#define xtp5pr  _0bitmap(pin5r)
#define xtp5sr  _0bitmap(sou5r)
#define xdtp5m d_0bitmap(man5)
#define xdtp5p d_0bitmap(pin5)
#define xdtp5s d_0bitmap(sou5)
#define xdtp5mr d_0bitmap(man5r)
#define xdtp5pr d_0bitmap(pin5r)
#define xdtp5sr d_0bitmap(sou5r)

static struct pai3
  {
    struct gpixmap2 opened[39 * 4];
    struct gpixmap2 darkopened[39 * 4];
    struct gpixmap2 closed[39 * 4];
  }
pm_pai[4];


struct pai_5 {
  struct gpixmap2 *addr;
  char **pai[3];
  char **rpai[3];
} pai_5[6] = {{ (gpixmap2_t)&pm_pai[3].opened, 
		 { xp5m, xp5p, xp5s}, 
		 { xp5mr, xp5pr, xp5sr}}, /* 3 close reverse */
		{ (gpixmap2_t)&pm_pai[3].darkopened, 
		    {xdp5m, xdp5p, xdp5s}, 
		    {xdp5mr, xdp5pr, xdp5sr}}, /* 3 open dark reverse */
		{ (gpixmap2_t)&pm_pai[3].closed, 
		    {p5m, p5p, p5s}, 
		    {p5mr, p5pr, p5sr}}, /* 3 open dark reverse */	
		{ (gpixmap2_t)&pm_pai[0].closed, 
		    {tp5m, tp5p, tp5s},
		    {tp5mr, tp5pr, tp5sr}}, /* 0 close reverse */
		{ (gpixmap2_t)&pm_pai[0].opened, 
		    {xtp5m, xtp5p, xtp5s},
		    {xtp5mr, xtp5pr, xtp5sr}}, /* 0 open reverse */
	       { (gpixmap2_t)&pm_pai[0].darkopened, 
		  {xdtp5m, xdtp5p, xdtp5s},
		  {xdtp5mr, xdtp5pr, xdtp5sr}}} /* 0 open dark reverse */;


static struct gpixmap2 pm_pai_have_to_free[38 * 4 * 6];
static integer_t have_to_free;

gpixmap2_t
pai2pix (n, pos, reach, opened)
     integer_t n;
     integer_t pos;
     integer_t reach;
/*   1   */
/* 2   0 */
/*   3   */
     integer_t opened;		/* opened or not */
{
  gpixmap2_t pais;
  char ***data;
  int paidirec = 3; /* pos to pai direction */

  if (opened & PAIOPEN)
    {
      if (reach)
	{
          paidirec = 0; /* horizontal */
	} else {
	  paidirec = 3;
	}
      if (opened & PAIDARK)
	{
	  pais = pm_pai[paidirec].darkopened;
	  data = pai_data[paidirec].darkopened;
	}
      else
	{
	  pais = pm_pai[paidirec].opened;
	  data = pai_data[paidirec].opened;
	}
    }
  else
    {
 /* forcely virtical */
      pais = pm_pai[3].closed;
      data = pai_data[3].closed;
    }

  if (!pais[n].pm)
    {
      int j = (n / 4);
      if (n < 0 || n >= (37 * 4)) abort();
      read_pix_idx (data[j], pais[n]);
      pm_pai_have_to_free[have_to_free++] = pais[n];
    }
  return &pais[n];
}


#define MAN5R  (5 * 4)
#define PIN5R  (14 * 4)
#define SOU5R  (23 * 4)


void
pai2pix_init ()
{
  gpixmap2_t pai;
  char ***data;
  int i;

  for (i = 0; i < 6; i++) {
    pai = pai_5[i].addr;
    data = (char ***)pai_5[i].rpai;
    read_pix_idx (data[0], pai[MAN5R]);
    read_pix_idx (data[1], pai[PIN5R]);
    read_pix_idx (data[2], pai[SOU5R]);

    data = (char ***)pai_5[i].pai;
    read_pix_idx (data[0], pai[MAN5R + 1]);
    read_pix_idx (data[1], pai[PIN5R + 1]);
    read_pix_idx (data[2], pai[SOU5R + 1]);

    pai[MAN5R + 3] = pai[MAN5R + 2] = pai[MAN5R + 1];
    pai[PIN5R + 3] = pai[PIN5R + 2] = pai[PIN5R + 1];
    pai[SOU5R + 3] = pai[SOU5R + 2] = pai[SOU5R + 1];
  }
}


#elif PAICARD3D


#include "bitmap/pai2/p2_c0.h"
#include "bitmap/pai2/p2_o0.h"
#include "bitmap/pai2/p2_do0.h"
#include "bitmap/pai2/p2_c3.h"
#include "bitmap/pai2/p2_o3.h"
#include "bitmap/pai2/p2_do3.h"
#include "bitmap/pai2/hpai.h"
#include "bitmap/pai2/htpai.h"
#include "bitmap/pai2/xhpai.h"	
#include "bitmap/pai2/xhtpai.h"


#define _bitmap(a)  identcat(a,_24o3_xpm)

static char **openedpai3_data[] =
{
  _bitmap (rev),
  _bitmap (man1),
  _bitmap (man2),
  _bitmap (man3),
  _bitmap (man4),
  _bitmap (man5),
  _bitmap (man6),
  _bitmap (man7),
  _bitmap (man8),
  _bitmap (man9),
  _bitmap (pin1),
  _bitmap (pin2),
  _bitmap (pin3),
  _bitmap (pin4),
  _bitmap (pin5),
  _bitmap (pin6),
  _bitmap (pin7),
  _bitmap (pin8),
  _bitmap (pin9),
  _bitmap (sou1),
  _bitmap (sou2),
  _bitmap (sou3),
  _bitmap (sou4),
  _bitmap (sou5),
  _bitmap (sou6),
  _bitmap (sou7),
  _bitmap (sou8),
  _bitmap (sou9),
  _bitmap (ton),
  _bitmap (nan),
  _bitmap (sya),
  _bitmap (pei),
  _bitmap (haku),
  _bitmap (hatu),
  _bitmap (cyun),
};


#define d_bitmap(a)  identcat(a,_24do3_xpm)

static char **darkopenedpai3_data[] =
{
  d_bitmap (rev),
  d_bitmap (man1),
  d_bitmap (man2),
  d_bitmap (man3),
  d_bitmap (man4),
  d_bitmap (man5),
  d_bitmap (man6),
  d_bitmap (man7),
  d_bitmap (man8),
  d_bitmap (man9),
  d_bitmap (pin1),
  d_bitmap (pin2),
  d_bitmap (pin3),
  d_bitmap (pin4),
  d_bitmap (pin5),
  d_bitmap (pin6),
  d_bitmap (pin7),
  d_bitmap (pin8),
  d_bitmap (pin9),
  d_bitmap (sou1),
  d_bitmap (sou2),
  d_bitmap (sou3),
  d_bitmap (sou4),
  d_bitmap (sou5),
  d_bitmap (sou6),
  d_bitmap (sou7),
  d_bitmap (sou8),
  d_bitmap (sou9),
  d_bitmap (ton),
  d_bitmap (nan),
  d_bitmap (sya),
  d_bitmap (pei),
  d_bitmap (haku),
  d_bitmap (hatu),
  d_bitmap (cyun),
};

#define c_bitmap(a)  identcat(a,_24c3_xpm)

static char **closedpai3_data[] =
{
  c_bitmap (rev),
  c_bitmap (man1),
  c_bitmap (man2),
  c_bitmap (man3),
  c_bitmap (man4),
  c_bitmap (man5),
  c_bitmap (man6),
  c_bitmap (man7),
  c_bitmap (man8),
  c_bitmap (man9),
  c_bitmap (pin1),
  c_bitmap (pin2),
  c_bitmap (pin3),
  c_bitmap (pin4),
  c_bitmap (pin5),
  c_bitmap (pin6),
  c_bitmap (pin7),
  c_bitmap (pin8),
  c_bitmap (pin9),
  c_bitmap (sou1),
  c_bitmap (sou2),
  c_bitmap (sou3),
  c_bitmap (sou4),
  c_bitmap (sou5),
  c_bitmap (sou6),
  c_bitmap (sou7),
  c_bitmap (sou8),
  c_bitmap (sou9),
  c_bitmap (ton),
  c_bitmap (nan),
  c_bitmap (sya),
  c_bitmap (pei),
  c_bitmap (haku),
  c_bitmap (hatu),
  c_bitmap (cyun),
};

#define _0bitmap(a)  identcat(a,_24o0_xpm)

static char **openedpai0_data[] =
{
  _0bitmap (rev),
  _0bitmap (man1),
  _0bitmap (man2),
  _0bitmap (man3),
  _0bitmap (man4),
  _0bitmap (man5),
  _0bitmap (man6),
  _0bitmap (man7),
  _0bitmap (man8),
  _0bitmap (man9),
  _0bitmap (pin1),
  _0bitmap (pin2),
  _0bitmap (pin3),
  _0bitmap (pin4),
  _0bitmap (pin5),
  _0bitmap (pin6),
  _0bitmap (pin7),
  _0bitmap (pin8),
  _0bitmap (pin9),
  _0bitmap (sou1),
  _0bitmap (sou2),
  _0bitmap (sou3),
  _0bitmap (sou4),
  _0bitmap (sou5),
  _0bitmap (sou6),
  _0bitmap (sou7),
  _0bitmap (sou8),
  _0bitmap (sou9),
  _0bitmap (ton),
  _0bitmap (nan),
  _0bitmap (sya),
  _0bitmap (pei),
  _0bitmap (haku),
  _0bitmap (hatu),
  _0bitmap (cyun),
};

#define d_0bitmap(a)  identcat(a,_24do0_xpm)

static char **darkopenedpai0_data[] =
{
  d_0bitmap (rev),
  d_0bitmap (man1),
  d_0bitmap (man2),
  d_0bitmap (man3),
  d_0bitmap (man4),
  d_0bitmap (man5),
  d_0bitmap (man6),
  d_0bitmap (man7),
  d_0bitmap (man8),
  d_0bitmap (man9),
  d_0bitmap (pin1),
  d_0bitmap (pin2),
  d_0bitmap (pin3),
  d_0bitmap (pin4),
  d_0bitmap (pin5),
  d_0bitmap (pin6),
  d_0bitmap (pin7),
  d_0bitmap (pin8),
  d_0bitmap (pin9),
  d_0bitmap (sou1),
  d_0bitmap (sou2),
  d_0bitmap (sou3),
  d_0bitmap (sou4),
  d_0bitmap (sou5),
  d_0bitmap (sou6),
  d_0bitmap (sou7),
  d_0bitmap (sou8),
  d_0bitmap (sou9),
  d_0bitmap (ton),
  d_0bitmap (nan),
  d_0bitmap (sya),
  d_0bitmap (pei),
  d_0bitmap (haku),
  d_0bitmap (hatu),
  d_0bitmap (cyun),
};

#define c_0bitmap(a)  identcat(a,_24c0_xpm)

static char **closedpai0_data[] =
{
  c_0bitmap (rev),
  c_0bitmap (man1),
  c_0bitmap (man2),
  c_0bitmap (man3),
  c_0bitmap (man4),
  c_0bitmap (man5),
  c_0bitmap (man6),
  c_0bitmap (man7),
  c_0bitmap (man8),
  c_0bitmap (man9),
  c_0bitmap (pin1),
  c_0bitmap (pin2),
  c_0bitmap (pin3),
  c_0bitmap (pin4),
  c_0bitmap (pin5),
  c_0bitmap (pin6),
  c_0bitmap (pin7),
  c_0bitmap (pin8),
  c_0bitmap (pin9),
  c_0bitmap (sou1),
  c_0bitmap (sou2),
  c_0bitmap (sou3),
  c_0bitmap (sou4),
  c_0bitmap (sou5),
  c_0bitmap (sou6),
  c_0bitmap (sou7),
  c_0bitmap (sou8),
  c_0bitmap (sou9),
  c_0bitmap (ton),
  c_0bitmap (nan),
  c_0bitmap (sya),
  c_0bitmap (pei),
  c_0bitmap (haku),
  c_0bitmap (hatu),
  c_0bitmap (cyun),
};

static char **openedpai1_data[sizeof (closedpai0_data) / sizeof (char **)];
static char **closedpai1_data[sizeof (closedpai0_data) / sizeof (char **)];
static char **darkopenedpai1_data[sizeof (closedpai0_data) / sizeof (char **)];

static char **openedpai2_data[sizeof (closedpai0_data) / sizeof (char **)];
static char **closedpai2_data[sizeof (closedpai0_data) / sizeof (char **)];
static char **darkopenedpai2_data[sizeof (closedpai0_data) / sizeof (char **)];

struct
  {
    char ***opened;
    char ***closed;
    char ***darkopened;
  }
pai_data[4] =
{
  {
    openedpai0_data, closedpai0_data, darkopenedpai0_data
  }
  ,
  {
    openedpai1_data, closedpai1_data, darkopenedpai1_data
  }
  ,
  {
    openedpai2_data, closedpai2_data, darkopenedpai2_data
  }
  ,
  {
    openedpai3_data, closedpai3_data, darkopenedpai3_data
  }
  ,
};

#define	xp5m _bitmap(man5)
#define xp5p _bitmap(pin5)
#define xp5s _bitmap(sou5)
#define	xp5mr _bitmap(man5r)
#define xp5pr _bitmap(pin5r)
#define xp5sr _bitmap(sou5r)
#define xdp5m d_bitmap(man5)
#define xdp5p d_bitmap(pin5)
#define xdp5s d_bitmap(sou5)
#define	xdp5mr d_bitmap(man5r)
#define xdp5pr d_bitmap(pin5r)
#define xdp5sr d_bitmap(sou5r)
#define	p5m  c_bitmap(man5)
#define p5p  c_bitmap(pin5)
#define p5s c_bitmap(sou5)
#define	p5mr c_bitmap(man5r)
#define p5pr c_bitmap(pin5r)
#define p5sr c_bitmap(sou5r)
#define	tp5m  c_0bitmap(man5)
#define tp5p  c_0bitmap(pin5)
#define tp5s  c_0bitmap(sou5)
#define	tp5mr  c_0bitmap(man5r)
#define tp5pr  c_0bitmap(pin5r)
#define tp5sr  c_0bitmap(sou5r)
#define	xtp5m  _0bitmap(man5)
#define xtp5p  _0bitmap(pin5)
#define xtp5s  _0bitmap(sou5)
#define xtp5mr  _0bitmap(man5r)
#define xtp5pr  _0bitmap(pin5r)
#define xtp5sr  _0bitmap(sou5r)
#define xdtp5m d_0bitmap(man5)
#define xdtp5p d_0bitmap(pin5)
#define xdtp5s d_0bitmap(sou5)
#define xdtp5mr d_0bitmap(man5r)
#define xdtp5pr d_0bitmap(pin5r)
#define xdtp5sr d_0bitmap(sou5r)

static struct pai3
  {
    struct gpixmap2 opened[39 * 4];
    struct gpixmap2 darkopened[39 * 4];
    struct gpixmap2 closed[39 * 4];
  }
pm_pai[4];


struct pai_5 {
  struct gpixmap2 *addr;
  char **pai[3];
  char **rpai[3];
} pai_5[6] = {{ (gpixmap2_t)&pm_pai[3].opened, 
		 { xp5m, xp5p, xp5s}, 
		 { xp5mr, xp5pr, xp5sr}}, /* 3 close reverse */
		{ (gpixmap2_t)&pm_pai[3].darkopened, 
		    {xdp5m, xdp5p, xdp5s}, 
		    {xdp5mr, xdp5pr, xdp5sr}}, /* 3 open dark reverse */
		{ (gpixmap2_t)&pm_pai[3].closed, 
		    {p5m, p5p, p5s}, 
		    {p5mr, p5pr, p5sr}}, /* 3 open dark reverse */	
		{ (gpixmap2_t)&pm_pai[0].closed, 
		    {tp5m, tp5p, tp5s},
		    {tp5mr, tp5pr, tp5sr}}, /* 0 close reverse */
		{ (gpixmap2_t)&pm_pai[0].opened, 
		    {xtp5m, xtp5p, xtp5s},
		    {xtp5mr, xtp5pr, xtp5sr}}, /* 0 open reverse */
	       { (gpixmap2_t)&pm_pai[0].darkopened, 
		  {xdtp5m, xdtp5p, xdtp5s},
		  {xdtp5mr, xdtp5pr, xdtp5sr}}} /* 0 open dark reverse */;


static struct gpixmap2 pm_pai_have_to_free[38 * 4 * 6];
static integer_t have_to_free;

gpixmap2_t
pai2pix (n, pos, reach, opened)
     integer_t n;
     integer_t pos;
     integer_t reach;
/*   1   */
/* 2   0 */
/*   3   */
     integer_t opened;		/* opened or not */
{
  gpixmap2_t pais;
  char ***data;
  int paidirec = 3; /* pos to pai direction */

  if (opened & PAIOPEN)
    {
      if (reach)
	{
          paidirec = 0; /* horizontal */
	} else {
	  paidirec = 3;
	}
      if (opened & PAIDARK)
	{
	  pais = pm_pai[paidirec].darkopened;
	  data = pai_data[paidirec].darkopened;
	}
      else
	{
	  pais = pm_pai[paidirec].opened;
	  data = pai_data[paidirec].opened;
	}
      if (!(opened & 0x80)) {
        pai2pix (n, 3, 0, PAIOPEN | 0x80);
      }
    }
  else
    {
 /* forcely virtical */
      pais = pm_pai[3].closed;
      data = pai_data[3].closed;
    }

  if (!pais[n].pm)
    {
      int j = (n / 4);
      if (n < 0 || n >= (37 * 4)) abort();
      read_pix_idx (data[j], pais[n]);
      pm_pai_have_to_free[have_to_free++] = pais[n];
    }
  return &pais[n];
}


#define MAN5R  (5 * 4)
#define PIN5R  (14 * 4)
#define SOU5R  (23 * 4)


void
pai2pix_init ()
{
  gpixmap2_t pai;
  char ***data;
  int i;

  for (i = 0; i < 6; i++) {
    pai = pai_5[i].addr;
    data = (char ***)&pai_5[i].rpai;
    read_pix_idx (data[0], pai[MAN5R]);
    read_pix_idx (data[1], pai[PIN5R]);
    read_pix_idx (data[2], pai[SOU5R]);

    pm_pai_have_to_free[have_to_free++] = pai[MAN5R];
    pm_pai_have_to_free[have_to_free++] = pai[PIN5R];
    pm_pai_have_to_free[have_to_free++] = pai[SOU5R];

    data = (char ***)&pai_5[i].pai;
    read_pix_idx (data[0], pai[MAN5R + 1]);
    read_pix_idx (data[1], pai[PIN5R + 1]);
    read_pix_idx (data[2], pai[SOU5R + 1]);

    pm_pai_have_to_free[have_to_free++] = pai[MAN5R + 1];
    pm_pai_have_to_free[have_to_free++] = pai[PIN5R + 1];
    pm_pai_have_to_free[have_to_free++] = pai[SOU5R + 1];

    pai[MAN5R + 3] = pai[MAN5R + 2] = pai[MAN5R + 1];
    pai[PIN5R + 3] = pai[PIN5R + 2] = pai[PIN5R + 1];
    pai[SOU5R + 3] = pai[SOU5R + 2] = pai[SOU5R + 1];
  }
#define TEST 0
#if TEST
  for ( i = 0; i < 144; i++) {
    pai2pix(i, 3, 0, 0);
    pai2pix(i, 3, 1, 0);
    pai2pix(i, 3, 0, 1);
    pai2pix(i, 3, 1, 1);
    pai2pix(i, 3, 0, 3);
    pai2pix(i, 3, 1, 3);
  }
#endif
}



#else
unknown Pai ! !
#endif
